/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.outline;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.freeplane.features.filter.Filter;
import org.freeplane.view.swing.map.outline.TreeNode;

class OutlineTreeViewState {
    private final String firstVisibleNodeId;
    private final Map<String, Integer> expansionLevels;
    private final String rootNodeId;
    private final WeakReference<Filter> savedFilter;

    OutlineTreeViewState(String firstVisibleNodeId, Map<String, Integer> expansionLevels, String rootNodeId, WeakReference<Filter> savedFilter) {
        this.firstVisibleNodeId = firstVisibleNodeId;
        this.expansionLevels = new HashMap<String, Integer>(expansionLevels);
        this.rootNodeId = rootNodeId;
        this.savedFilter = savedFilter;
    }

    String getFirstVisibleNodeId() {
        return this.firstVisibleNodeId;
    }

    String getRootNodeId() {
        return this.rootNodeId;
    }

    WeakReference<Filter> getSavedFilter() {
        return this.savedFilter;
    }

    void applyTo(TreeNode root) {
        HashMap<String, TreeNode> byId = new HashMap<String, TreeNode>();
        HashMap<String, Integer> levelById = new HashMap<String, Integer>();
        this.collect(root, 0, byId, levelById);
        ArrayList<Map.Entry<String, Integer>> ordered = new ArrayList<Map.Entry<String, Integer>>();
        for (Map.Entry<String, Integer> e2 : this.expansionLevels.entrySet()) {
            if (!byId.containsKey(e2.getKey())) continue;
            ordered.add(e2);
        }
        Collections.sort(ordered, Comparator.comparingInt(e -> (Integer)levelById.get(e.getKey())));
        for (Map.Entry<String, Integer> e2 : ordered) {
            TreeNode n = (TreeNode)byId.get(e2.getKey());
            if (n == null) continue;
            n.applyExpansionLevel(e2.getValue());
        }
    }

    private void collect(TreeNode node, int level, Map<String, TreeNode> byId, Map<String, Integer> levelById) {
        byId.put(node.getId(), node);
        levelById.put(node.getId(), level);
        for (TreeNode c : node.getChildren()) {
            this.collect(c, level + 1, byId, levelById);
        }
    }
}

