/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.chat;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.memory.ChatMemory;
import dev.langchain4j.model.openai.OpenAiTokenCountEstimator;
import dev.langchain4j.model.output.TokenUsage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.freeplane.plugin.ai.chat.AssistantProfileInstructionMessage;
import org.freeplane.plugin.ai.chat.AssistantProfileSwitchMessage;
import org.freeplane.plugin.ai.chat.ChatMemoryRenderEntry;
import org.freeplane.plugin.ai.chat.ChatUsageTotals;
import org.freeplane.plugin.ai.chat.GeneralSystemMessage;
import org.freeplane.plugin.ai.chat.InstructionAckMessage;
import org.freeplane.plugin.ai.chat.RemovedForSpaceSystemMessage;
import org.freeplane.plugin.ai.chat.ToolCallSummaryMessage;
import org.freeplane.plugin.ai.chat.TranscriptHiddenSystemMessage;
import org.freeplane.plugin.ai.chat.history.AssistantProfileTranscriptEntry;
import org.freeplane.plugin.ai.chat.history.ChatTranscriptEntry;
import org.freeplane.plugin.ai.chat.history.ChatTranscriptRole;
import org.freeplane.plugin.ai.tools.MessageBuilder;
import org.freeplane.plugin.ai.tools.utilities.ToolCaller;

public class AssistantProfileChatMemory
implements ChatMemory {
    private final Object id;
    private final Function<Object, Integer> maxTokensProvider;
    private final ChatTokenEstimator tokenEstimator;
    private ProfileInstructionFactory profileInstructionFactory;
    private GeneralSystemMessage generalSystemMessage;
    private final List<ChatMessage> conversationMessages = new ArrayList<ChatMessage>();
    private int activeStartIndex;
    private final List<Integer> turnEndIndexes = new ArrayList<Integer>();
    private int currentTurnCount;

    private AssistantProfileChatMemory(Builder builder) {
        this.id = ValidationUtils.ensureNotNull((Object)builder.id, (String)"id");
        this.maxTokensProvider = (Function)ValidationUtils.ensureNotNull(builder.maxTokensProvider, (String)"maxTokensProvider");
        this.tokenEstimator = new ChatTokenEstimator(builder.tokenEstimatorModelNameProvider);
        this.profileInstructionFactory = this.resolveProfileInstructionFactory(builder.profileInstructionFactory);
        ValidationUtils.ensureGreaterThanZero((Integer)this.maxTokensProvider.apply(this.id), (String)"maxTokens");
    }

    public Object id() {
        return this.id;
    }

    public void add(ChatMessage message) {
        if (message == null) {
            return;
        }
        this.discardRedoBranchIfNeeded();
        if (message instanceof TranscriptHiddenSystemMessage) {
            if (!this.containsInstructionOfType(TranscriptHiddenSystemMessage.class)) {
                this.addConversationMessage(message);
                this.addConversationMessage((ChatMessage)new InstructionAckMessage());
                this.rebuildTurnBoundaries();
            }
            return;
        }
        if (message instanceof RemovedForSpaceSystemMessage) {
            this.markContextWindowStart();
            return;
        }
        if (message instanceof AssistantProfileSwitchMessage) {
            this.addConversationMessage(message);
            this.addConversationMessage((ChatMessage)new InstructionAckMessage());
            this.rebuildTurnBoundaries();
            return;
        }
        if (message instanceof InstructionAckMessage) {
            return;
        }
        if (message instanceof SystemMessage) {
            this.setGeneralSystemMessage(this.toGeneralSystemMessage((SystemMessage)message));
            this.rebuildTurnBoundaries();
            return;
        }
        this.addConversationMessage(message);
        this.rebuildTurnBoundaries();
    }

    public List<ChatMessage> messages() {
        return this.buildMessages(this.activeConversationEndIndex());
    }

    public void clear() {
        this.generalSystemMessage = null;
        this.conversationMessages.clear();
        this.activeStartIndex = 0;
        this.turnEndIndexes.clear();
        this.currentTurnCount = 0;
    }

    public boolean canUndo() {
        return this.currentTurnCount > this.firstActiveTurnIndex();
    }

    public int conversationMessageCount() {
        return this.conversationMessages.size();
    }

    public void truncateConversationMessagesTo(int size) {
        int targetSize = Math.max(0, Math.min(size, this.conversationMessages.size()));
        while (this.conversationMessages.size() > targetSize) {
            this.removeConversationMessage(this.conversationMessages.size() - 1);
        }
        this.activeStartIndex = Math.min(this.activeStartIndex, targetSize);
        this.rebuildTurnBoundaries();
    }

    public boolean canRedo() {
        return this.currentTurnCount < this.turnEndIndexes.size();
    }

    public String undo() {
        if (!this.canUndo()) {
            return "";
        }
        int turnIndex = this.currentTurnCount - 1;
        int from = turnIndex == 0 ? 0 : this.turnEndIndexes.get(turnIndex - 1);
        from = Math.max(from, this.activeStartIndex);
        int to = this.turnEndIndexes.get(turnIndex);
        this.currentTurnCount = turnIndex;
        this.rebalanceActiveWindowForCurrentTurnRange();
        return this.findUserMessageInRange(from, to);
    }

    public void redo() {
        if (!this.canRedo()) {
            return;
        }
        ++this.currentTurnCount;
        this.rebalanceActiveWindowForCurrentTurnRange();
    }

    public void initializeUndoRedoFromMessages() {
        this.rebuildTurnBoundaries();
    }

    void expandWindowAfterTranscriptRestoreIfUnderutilized() {
        long expandedTokens;
        int previousTurnStart;
        this.rebuildTurnBoundaries();
        int endIndex = this.activeConversationEndIndex();
        if (endIndex <= 0) {
            return;
        }
        int maxTokens = this.maxTokensProvider.apply(this.id);
        ValidationUtils.ensureGreaterThanZero((Integer)maxTokens, (String)"maxTokens");
        int startIndex = Math.min(this.activeStartIndex, endIndex);
        long activeTokens = this.estimateTotalTokensForRange(startIndex, endIndex);
        if (activeTokens >= (long)maxTokens) {
            return;
        }
        int selectedStart = startIndex;
        while ((previousTurnStart = this.previousTurnStartFor(selectedStart)) >= 0 && (expandedTokens = this.estimateTotalTokensForRange(previousTurnStart, endIndex)) <= (long)maxTokens) {
            selectedStart = previousTurnStart;
            if (expandedTokens < (long)maxTokens) continue;
            break;
        }
        this.activeStartIndex = selectedStart;
    }

    public boolean evictOldestTurn() {
        this.rebuildTurnBoundaries();
        if (!this.canAdvanceWindowByTurnWithMinimumRetention(1)) {
            return false;
        }
        return this.advanceWindowByOneTurn();
    }

    public List<ChatTranscriptEntry> transcriptEntriesForPersistence() {
        ArrayList<ChatTranscriptEntry> entries = new ArrayList<ChatTranscriptEntry>();
        int endIndex = this.activeConversationEndIndex();
        int startIndex = Math.min(this.activeStartIndex, endIndex);
        if (startIndex > 0) {
            startIndex = this.alignVisibleStartIndex(startIndex, endIndex);
        }
        for (int index = 0; index < endIndex; ++index) {
            ChatMessage message;
            ChatTranscriptEntry entry;
            if (index == startIndex && startIndex > 0 && endIndex > startIndex) {
                entries.add(new ChatTranscriptEntry(ChatTranscriptRole.REMOVED_FOR_SPACE_SYSTEM, "The earlier part of this conversation was removed for space. The user is continuing a previous thought."));
            }
            if ((entry = this.toTranscriptEntry(message = this.conversationMessages.get(index))) == null) continue;
            entries.add(entry);
        }
        return entries;
    }

    public List<ChatMessage> activeConversationMessagesForRendering() {
        return this.buildRawMessages(this.activeConversationEndIndex());
    }

    public List<ChatMemoryRenderEntry> activeConversationRenderEntries() {
        return this.buildRenderEntries(false);
    }

    public List<ChatMemoryRenderEntry> panelConversationRenderEntries() {
        return this.buildRenderEntries(true);
    }

    private List<ChatMemoryRenderEntry> buildRenderEntries(boolean includeMessagesBeforeActiveWindow) {
        int firstRenderedIndex;
        int startIndex;
        int endIndex = this.activeConversationEndIndex();
        if (endIndex == 0) {
            return Collections.emptyList();
        }
        ArrayList<ChatMemoryRenderEntry> entries = new ArrayList<ChatMemoryRenderEntry>();
        if (this.generalSystemMessage != null) {
            entries.add(ChatMemoryRenderEntry.forMessage((ChatMessage)this.generalSystemMessage));
        }
        if ((startIndex = Math.min(this.activeStartIndex, endIndex)) > 0) {
            startIndex = this.alignVisibleStartIndex(startIndex, endIndex);
        }
        for (int index = firstRenderedIndex = includeMessagesBeforeActiveWindow ? 0 : startIndex; index < endIndex; ++index) {
            ChatMessage message;
            if (index == startIndex && startIndex > 0 && endIndex > startIndex) {
                entries.add(ChatMemoryRenderEntry.forMessage((ChatMessage)new RemovedForSpaceSystemMessage()));
            }
            if ((message = this.conversationMessages.get(index)) instanceof ToolCallSummaryMessage) {
                ToolCallSummaryMessage summaryMessage = (ToolCallSummaryMessage)message;
                entries.add(ChatMemoryRenderEntry.forToolSummary(summaryMessage.text(), summaryMessage.toolCaller()));
                continue;
            }
            entries.add(ChatMemoryRenderEntry.forMessage(message));
        }
        return entries;
    }

    public void markContextWindowStart() {
        this.activeStartIndex = Math.max(this.activeStartIndex, this.conversationMessages.size());
    }

    void addToolCallSummary(String summaryText, ToolCaller toolCaller) {
        if (summaryText == null || summaryText.trim().isEmpty()) {
            return;
        }
        this.conversationMessages.add((ChatMessage)new ToolCallSummaryMessage(summaryText, toolCaller));
        this.rebuildTurnBoundaries();
    }

    ChatUsageTotals estimateTokenUsageForActiveWindow() {
        int endIndex = this.activeConversationEndIndex();
        int startIndex = Math.min(this.activeStartIndex, endIndex);
        return this.estimateTokenUsageForRange(startIndex, endIndex);
    }

    ChatUsageTotals estimateTokenUsageForFullConversation() {
        return this.estimateTokenUsageForRange(0, this.conversationMessages.size());
    }

    public boolean onResponseTokenUsage(TokenUsage ignoredUsage) {
        return this.evictIfNeededAfterResponse();
    }

    void setProfileInstructionFactory(ProfileInstructionFactory profileInstructionFactory) {
        this.profileInstructionFactory = this.resolveProfileInstructionFactory(profileInstructionFactory);
    }

    private boolean evictIfNeededAfterResponse() {
        int maxTokens = this.maxTokensProvider.apply(this.id);
        ValidationUtils.ensureGreaterThanZero((Integer)maxTokens, (String)"maxTokens");
        long estimatedTokens = this.estimateTotalTokensForActiveWindow();
        if (estimatedTokens < (long)maxTokens) {
            return false;
        }
        int resetTargetTokens = maxTokens / 4;
        int minimumTurnBlocksToKeep = this.minimumTurnBlocksToKeep(maxTokens);
        boolean evicted = false;
        while (this.estimateTotalTokensForActiveWindow() > (long)resetTargetTokens && this.canAdvanceWindowByTurnWithMinimumRetention(minimumTurnBlocksToKeep) && this.advanceWindowByOneTurn()) {
            evicted = true;
        }
        return evicted;
    }

    private List<ChatMessage> buildMessages(int conversationEndIndex) {
        ArrayList<ChatMessage> messages = new ArrayList<ChatMessage>();
        if (this.generalSystemMessage != null) {
            messages.add((ChatMessage)this.generalSystemMessage);
        }
        int endIndex = Math.max(0, Math.min(conversationEndIndex, this.conversationMessages.size()));
        int startIndex = Math.min(this.activeStartIndex, endIndex);
        int latestProfileSwitchIndex = this.findLatestProfileSwitchIndex(endIndex);
        UserMessage latestProfileInstruction = this.buildProfileInstructionForIndex(latestProfileSwitchIndex);
        if (latestProfileInstruction != null && latestProfileSwitchIndex >= 0 && latestProfileSwitchIndex < startIndex) {
            messages.add((ChatMessage)latestProfileInstruction);
        }
        for (int index = startIndex; index < endIndex; ++index) {
            ChatMessage message = this.conversationMessages.get(index);
            if (message instanceof AssistantProfileSwitchMessage) {
                if (index != latestProfileSwitchIndex || latestProfileInstruction == null) continue;
                messages.add((ChatMessage)latestProfileInstruction);
                continue;
            }
            if (message instanceof ToolCallSummaryMessage) continue;
            if (message instanceof TranscriptHiddenSystemMessage || message instanceof RemovedForSpaceSystemMessage) {
                messages.add((ChatMessage)MessageBuilder.buildSystemInstructionUserMessage(((SystemMessage)message).text()));
                continue;
            }
            messages.add(message);
        }
        return messages;
    }

    private List<ChatMessage> buildRawMessages(int conversationEndIndex) {
        ArrayList<ChatMessage> messages = new ArrayList<ChatMessage>();
        if (this.generalSystemMessage != null) {
            messages.add((ChatMessage)this.generalSystemMessage);
        }
        int endIndex = Math.max(0, Math.min(conversationEndIndex, this.conversationMessages.size()));
        for (int index = 0; index < endIndex; ++index) {
            messages.add(this.conversationMessages.get(index));
        }
        return messages;
    }

    private int activeConversationEndIndex() {
        if (this.canRedo()) {
            int firstActive = this.firstActiveTurnIndex();
            if (this.currentTurnCount <= firstActive) {
                return this.activeStartIndex;
            }
            return this.turnEndIndexes.get(this.currentTurnCount - 1);
        }
        return this.conversationMessages.size();
    }

    private int conversationEndIndexForCurrentTurnRange() {
        if (this.canRedo()) {
            if (this.currentTurnCount <= 0) {
                return 0;
            }
            return this.turnEndIndexes.get(this.currentTurnCount - 1);
        }
        return this.conversationMessages.size();
    }

    private boolean containsInstructionOfType(Class<? extends SystemMessage> messageClass) {
        for (ChatMessage message : this.conversationMessages) {
            if (!messageClass.isInstance(message)) continue;
            return true;
        }
        return false;
    }

    private GeneralSystemMessage toGeneralSystemMessage(SystemMessage message) {
        if (message instanceof GeneralSystemMessage) {
            return (GeneralSystemMessage)message;
        }
        return new GeneralSystemMessage(message.text());
    }

    private void rebuildTurnBoundaries() {
        this.turnEndIndexes.clear();
        for (int index = 0; index < this.conversationMessages.size(); ++index) {
            AiMessage aiMessage;
            ChatMessage message = this.conversationMessages.get(index);
            if (!(message instanceof AiMessage) || message instanceof InstructionAckMessage || (aiMessage = (AiMessage)message).hasToolExecutionRequests()) continue;
            this.turnEndIndexes.add(index + 1);
        }
        this.currentTurnCount = this.turnEndIndexes.size();
        int endIndex = this.activeConversationEndIndex();
        if (this.activeStartIndex > endIndex) {
            this.activeStartIndex = endIndex;
        }
    }

    private void discardRedoBranchIfNeeded() {
        int keepSize;
        if (!this.canRedo()) {
            return;
        }
        int n = keepSize = this.currentTurnCount == 0 ? 0 : this.turnEndIndexes.get(this.currentTurnCount - 1);
        while (this.conversationMessages.size() > keepSize) {
            this.removeConversationMessage(this.conversationMessages.size() - 1);
        }
        while (this.turnEndIndexes.size() > this.currentTurnCount) {
            this.turnEndIndexes.remove(this.turnEndIndexes.size() - 1);
        }
        this.activeStartIndex = Math.min(this.activeStartIndex, keepSize);
    }

    private int firstActiveTurnIndex() {
        int startIndex = Math.min(this.activeStartIndex, this.conversationMessages.size());
        for (int index = 0; index < this.turnEndIndexes.size(); ++index) {
            int turnEnd = this.turnEndIndexes.get(index);
            if (turnEnd <= startIndex) continue;
            return index;
        }
        return this.turnEndIndexes.size();
    }

    private String findUserMessageInRange(int from, int to) {
        int safeFrom = Math.max(0, from);
        int safeTo = Math.min(to, this.conversationMessages.size());
        for (int index = safeTo - 1; index >= safeFrom; --index) {
            String text;
            ChatMessage message = this.conversationMessages.get(index);
            if (!(message instanceof UserMessage) || (text = ((UserMessage)message).singleText()) == null || text.startsWith("control instruction, please confirm with \"ok\": ")) continue;
            return text;
        }
        return "";
    }

    private ChatTranscriptEntry toTranscriptEntry(ChatMessage message) {
        if (message == null) {
            return null;
        }
        if (message instanceof AssistantProfileSwitchMessage) {
            AssistantProfileSwitchMessage profileMessage = (AssistantProfileSwitchMessage)message;
            return new AssistantProfileTranscriptEntry(profileMessage.getProfileId(), profileMessage.getProfileName(), false);
        }
        if (message instanceof RemovedForSpaceSystemMessage) {
            return new ChatTranscriptEntry(ChatTranscriptRole.REMOVED_FOR_SPACE_SYSTEM, ((RemovedForSpaceSystemMessage)message).text());
        }
        if (message instanceof ToolCallSummaryMessage) {
            return null;
        }
        if (message instanceof UserMessage) {
            String text = ((UserMessage)message).singleText();
            if (text == null || text.trim().isEmpty() || text.startsWith("control instruction, please confirm with \"ok\": ")) {
                return null;
            }
            return new ChatTranscriptEntry(ChatTranscriptRole.USER, text);
        }
        if (message instanceof AiMessage && !(message instanceof InstructionAckMessage)) {
            String text = ((AiMessage)message).text();
            if (text == null || text.trim().isEmpty()) {
                return null;
            }
            return new ChatTranscriptEntry(ChatTranscriptRole.ASSISTANT, text);
        }
        return null;
    }

    private void setGeneralSystemMessage(GeneralSystemMessage message) {
        this.generalSystemMessage = message;
    }

    private void addConversationMessage(ChatMessage message) {
        this.conversationMessages.add(message);
    }

    private ChatMessage removeConversationMessage(int index) {
        return this.conversationMessages.remove(index);
    }

    private boolean advanceWindowByOneTurn() {
        this.rebuildTurnBoundaries();
        int endIndex = this.activeConversationEndIndex();
        int startIndex = Math.min(this.activeStartIndex, endIndex);
        int nextTurnEnd = this.findNextTurnEndAfter(startIndex);
        if (nextTurnEnd <= startIndex) {
            return false;
        }
        this.activeStartIndex = nextTurnEnd;
        this.rebuildTurnBoundaries();
        return true;
    }

    private void rebalanceActiveWindowForCurrentTurnRange() {
        int candidateStart;
        int maxTokens = this.maxTokensProvider.apply(this.id);
        ValidationUtils.ensureGreaterThanZero((Integer)maxTokens, (String)"maxTokens");
        int endIndex = this.conversationEndIndexForCurrentTurnRange();
        if (endIndex <= 0 || this.currentTurnCount <= 0) {
            this.activeStartIndex = 0;
            return;
        }
        int selectedStart = this.turnStartIndex(this.currentTurnCount - 1);
        for (int turnIndex = this.currentTurnCount - 2; turnIndex >= 0 && this.estimateTotalTokensForRange(candidateStart = this.turnStartIndex(turnIndex), endIndex) <= (long)maxTokens; --turnIndex) {
            selectedStart = candidateStart;
        }
        this.activeStartIndex = selectedStart;
    }

    private int turnStartIndex(int turnIndex) {
        if (turnIndex <= 0) {
            return 0;
        }
        return this.turnEndIndexes.get(turnIndex - 1);
    }

    private int previousTurnStartFor(int startIndex) {
        int turnEnd;
        int safeStart = Math.max(0, startIndex);
        int previousTurnIndex = -1;
        int index = 0;
        while (index < this.turnEndIndexes.size() && (turnEnd = this.turnEndIndexes.get(index).intValue()) <= safeStart) {
            previousTurnIndex = index++;
        }
        if (previousTurnIndex < 0) {
            return -1;
        }
        return this.turnStartIndex(previousTurnIndex);
    }

    private boolean canAdvanceWindowByTurnWithMinimumRetention(int minimumTurnBlocksToKeep) {
        return this.activeTurnRanges().size() > minimumTurnBlocksToKeep;
    }

    private int findNextTurnEndAfter(int startIndex) {
        for (int index = 0; index < this.turnEndIndexes.size(); ++index) {
            int turnEnd = this.turnEndIndexes.get(index);
            if (turnEnd <= startIndex) continue;
            return turnEnd;
        }
        return -1;
    }

    private int alignVisibleStartIndex(int startIndex, int endIndex) {
        ChatMessage message;
        int alignedStart;
        for (alignedStart = Math.max(0, Math.min(startIndex, endIndex)); alignedStart < endIndex && (message = this.conversationMessages.get(alignedStart)) instanceof ToolCallSummaryMessage; ++alignedStart) {
        }
        return alignedStart;
    }

    private int findLatestProfileSwitchIndex(int endIndex) {
        for (int index = endIndex - 1; index >= 0; --index) {
            if (!(this.conversationMessages.get(index) instanceof AssistantProfileSwitchMessage)) continue;
            return index;
        }
        return -1;
    }

    private UserMessage buildProfileInstructionForIndex(int messageIndex) {
        if (messageIndex < 0 || messageIndex >= this.conversationMessages.size()) {
            return null;
        }
        ChatMessage message = this.conversationMessages.get(messageIndex);
        if (!(message instanceof AssistantProfileSwitchMessage)) {
            return null;
        }
        AssistantProfileInstructionMessage profileInstruction = this.profileInstructionFactory.buildFor((AssistantProfileSwitchMessage)message);
        if (profileInstruction == null) {
            return null;
        }
        return MessageBuilder.buildSystemInstructionUserMessage(profileInstruction.singleText());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static AssistantProfileChatMemory withMaxTokens(int maxTokens) {
        return AssistantProfileChatMemory.builder().maxTokens(maxTokens).build();
    }

    private ProfileInstructionFactory resolveProfileInstructionFactory(ProfileInstructionFactory profileInstructionFactory) {
        if (profileInstructionFactory != null) {
            return profileInstructionFactory;
        }
        return profileSwitchMessage -> {
            if (profileSwitchMessage == null) {
                return null;
            }
            return new AssistantProfileInstructionMessage(profileSwitchMessage.getProfileId(), profileSwitchMessage.getProfileName(), "");
        };
    }

    private ChatUsageTotals estimateTokenUsageForRange(int startIndex, int endIndex) {
        long inputTokens = 0L;
        long outputTokens = 0L;
        int safeStart = Math.max(0, startIndex);
        int safeEnd = Math.min(endIndex, this.conversationMessages.size());
        for (int index = safeStart; index < safeEnd; ++index) {
            ChatMessage message = this.conversationMessages.get(index);
            if (!this.isRemovableMessage(message)) continue;
            int tokenCount = this.tokenEstimator.estimateTokenCountInMessage(message);
            if (message instanceof AiMessage) {
                outputTokens += (long)tokenCount;
                continue;
            }
            inputTokens += (long)tokenCount;
        }
        return ChatUsageTotals.estimated(inputTokens, outputTokens);
    }

    private long estimateTotalTokensForActiveWindow() {
        ChatUsageTotals totals = this.estimateTokenUsageForActiveWindow();
        return totals.getInputTokenCount() + totals.getOutputTokenCount();
    }

    private long estimateTotalTokensForRange(int startIndex, int endIndex) {
        ChatUsageTotals totals = this.estimateTokenUsageForRange(startIndex, endIndex);
        return totals.getInputTokenCount() + totals.getOutputTokenCount();
    }

    private int minimumTurnBlocksToKeep(int maxTokens) {
        List<ActiveTurnRange> ranges = this.activeTurnRanges();
        if (ranges.size() <= 1) {
            return 1;
        }
        ActiveTurnRange secondLast = ranges.get(ranges.size() - 2);
        ActiveTurnRange last = ranges.get(ranges.size() - 1);
        long twoTurnTokenCount = this.estimateTotalTokensForRange(secondLast.startIndex, last.endIndex);
        return twoTurnTokenCount <= (long)maxTokens ? 2 : 1;
    }

    private List<ActiveTurnRange> activeTurnRanges() {
        ArrayList<ActiveTurnRange> ranges = new ArrayList<ActiveTurnRange>();
        int endIndex = this.activeConversationEndIndex();
        int startIndex = Math.min(this.activeStartIndex, endIndex);
        int previousEnd = 0;
        for (int index = 0; index < this.turnEndIndexes.size(); ++index) {
            int turnEnd = this.turnEndIndexes.get(index);
            int turnStart = previousEnd;
            previousEnd = turnEnd;
            if (turnEnd <= startIndex) continue;
            int rangeStart = Math.max(turnStart, startIndex);
            int rangeEnd = Math.min(turnEnd, endIndex);
            if (rangeEnd <= rangeStart) continue;
            ranges.add(new ActiveTurnRange(rangeStart, rangeEnd));
        }
        return ranges;
    }

    private boolean isRemovableMessage(ChatMessage message) {
        if (message == null) {
            return false;
        }
        if (message instanceof AssistantProfileSwitchMessage || message instanceof InstructionAckMessage || message instanceof TranscriptHiddenSystemMessage || message instanceof RemovedForSpaceSystemMessage || message instanceof ToolCallSummaryMessage || message instanceof GeneralSystemMessage) {
            return false;
        }
        if (message instanceof SystemMessage) {
            return false;
        }
        return message instanceof UserMessage || message instanceof AiMessage || message instanceof ToolExecutionResultMessage;
    }

    public static class Builder {
        private Object id = "default";
        private Function<Object, Integer> maxTokensProvider;
        private Supplier<String> tokenEstimatorModelNameProvider = () -> null;
        private ProfileInstructionFactory profileInstructionFactory;

        public Builder id(Object id) {
            this.id = id;
            return this;
        }

        public Builder maxTokens(Integer maxTokens) {
            this.maxTokensProvider = ignored -> maxTokens;
            return this;
        }

        public Builder dynamicMaxTokens(Function<Object, Integer> maxTokensProvider) {
            this.maxTokensProvider = maxTokensProvider;
            return this;
        }

        public Builder tokenEstimatorModelNameProvider(Supplier<String> tokenEstimatorModelNameProvider) {
            this.tokenEstimatorModelNameProvider = tokenEstimatorModelNameProvider;
            return this;
        }

        public Builder profileInstructionFactory(ProfileInstructionFactory profileInstructionFactory) {
            this.profileInstructionFactory = profileInstructionFactory;
            return this;
        }

        public AssistantProfileChatMemory build() {
            return new AssistantProfileChatMemory(this);
        }
    }

    private static class ChatTokenEstimator {
        private static final String FALLBACK_MODEL_NAME = "gpt-4o-mini";
        private final Supplier<String> modelNameProvider;
        private OpenAiTokenCountEstimator estimator;
        private String activeModelName;

        private ChatTokenEstimator(Supplier<String> modelNameProvider) {
            this.modelNameProvider = modelNameProvider == null ? () -> null : modelNameProvider;
        }

        int estimateTokenCountInMessage(ChatMessage message) {
            OpenAiTokenCountEstimator activeEstimator = this.estimator();
            try {
                return activeEstimator.estimateTokenCountInMessage(message);
            }
            catch (RuntimeException error) {
                return 0;
            }
        }

        private OpenAiTokenCountEstimator estimator() {
            String modelName = this.normalizeModelName(this.modelNameProvider.get());
            if (this.estimator == null || !modelName.equals(this.activeModelName)) {
                this.estimator = this.buildEstimator(modelName);
                this.activeModelName = modelName;
            }
            return this.estimator;
        }

        private OpenAiTokenCountEstimator buildEstimator(String modelName) {
            try {
                return new OpenAiTokenCountEstimator(modelName);
            }
            catch (IllegalArgumentException error) {
                return new OpenAiTokenCountEstimator(FALLBACK_MODEL_NAME);
            }
        }

        private String normalizeModelName(String modelName) {
            if (modelName == null || modelName.trim().isEmpty()) {
                return FALLBACK_MODEL_NAME;
            }
            String normalized = modelName.trim();
            int slashIndex = normalized.lastIndexOf(47);
            if (slashIndex >= 0 && slashIndex < normalized.length() - 1) {
                normalized = normalized.substring(slashIndex + 1);
            }
            return normalized;
        }
    }

    static interface ProfileInstructionFactory {
        public AssistantProfileInstructionMessage buildFor(AssistantProfileSwitchMessage var1);
    }

    private static class ActiveTurnRange {
        private final int startIndex;
        private final int endIndex;

        private ActiveTurnRange(int startIndex, int endIndex) {
            this.startIndex = startIndex;
            this.endIndex = endIndex;
        }
    }
}

