/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.actions.datasource;

import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimElement;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceContainerProvider;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.connection.DBPConnectionType;
import org.jkiss.dbeaver.model.struct.DBStructUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.EditorUtils;

public class DataSourceToolbarUtils {
    public static final String CONNECTION_SELECTOR_TOOLBAR_ID = "dbeaver-connection-selector";

    public static DBPDataSourceContainer getCurrentDataSource(IWorkbenchWindow workbenchWindow) {
        if (workbenchWindow == null || workbenchWindow.getActivePage() == null) {
            return null;
        }
        IEditorPart activeEditor = workbenchWindow.getActivePage().getActiveEditor();
        if (activeEditor == null) {
            return null;
        }
        if (activeEditor instanceof DBPDataSourceContainerProvider) {
            DBPDataSourceContainerProvider dscp = (DBPDataSourceContainerProvider)activeEditor;
            return dscp.getDataSourceContainer();
        }
        return null;
    }

    public static void refreshSelectorToolbar(IWorkbenchWindow window) {
        if (window instanceof WorkbenchWindow && window.getActivePage() != null) {
            MTrimBar topTrim = ((WorkbenchWindow)window).getTopTrim();
            boolean showConnectionSelector = false;
            boolean showSchemaSelector = false;
            IEditorPart activeEditor = window.getActivePage().getActiveEditor();
            DBPDataSourceContainer dataSourceContainer = null;
            if (activeEditor instanceof DBPDataSourceContainerProvider) {
                DBPDataSourceContainerProvider dscp = (DBPDataSourceContainerProvider)activeEditor;
                showConnectionSelector = true;
                dataSourceContainer = dscp.getDataSourceContainer();
            }
            if (dataSourceContainer != null && dataSourceContainer.isConnected()) {
                showSchemaSelector = DBStructUtils.isSchemasSupported(dataSourceContainer);
            }
            DBPProject resourceProj = activeEditor == null ? null : EditorUtils.getFileProject((IEditorInput)activeEditor.getEditorInput());
            boolean canChangeConn = resourceProj == null || resourceProj.hasRealmPermission("project-resource-edit");
            Color bgColor = dataSourceContainer == null ? null : UIUtils.getConnectionTypeColor((DBPConnectionType)dataSourceContainer.getConnectionConfiguration().getConnectionType());
            for (MTrimElement element : topTrim.getChildren()) {
                if (!CONNECTION_SELECTOR_TOOLBAR_ID.equals(element.getElementId())) continue;
                if (element instanceof MElementContainer) {
                    MElementContainer container = (MElementContainer)element;
                    Object widget = element.getWidget();
                    if (widget instanceof Composite) {
                        Control[] childControl;
                        Composite controlsPanel = (Composite)widget;
                        for (Control cc : childControl = controlsPanel.getChildren()) {
                            cc.setBackground(bgColor);
                            cc.setEnabled(showConnectionSelector && canChangeConn);
                        }
                    }
                    for (MUIElement tbItem : container.getChildren()) {
                        if (showConnectionSelector) {
                            tbItem.setVisible(false);
                        }
                        if (!(tbItem instanceof MHandledItem)) continue;
                        MHandledItem hi = (MHandledItem)tbItem;
                        String commandId = hi.getCommand().getElementId();
                        if ("org.jkiss.dbeaver.ui.tools.select.schema".equals(commandId)) {
                            tbItem.setVisible(showSchemaSelector);
                            continue;
                        }
                        tbItem.setVisible(showConnectionSelector);
                    }
                }
                return;
            }
        }
        DataSourceToolbarUtils.updateCommandsUI();
    }

    public static void updateCommandsUI() {
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        if (commandService != null) {
            commandService.refreshElements("org.jkiss.dbeaver.ui.tools.select.connection", null);
            commandService.refreshElements("org.jkiss.dbeaver.ui.tools.select.schema", null);
        }
    }

    public static void triggerRefreshReadonlyElement() {
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        if (commandService != null) {
            commandService.refreshElements("org.jkiss.dbeaver.core.connection.readonly", null);
        }
    }
}

