/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.browser.macosx;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.ui.internal.browser.browsers.DefaultBrowser;

public class SafariBrowser
extends DefaultBrowser {
    public SafariBrowser(String id, String location, String parameters) {
        super(id, location, parameters);
        this.location = location;
        this.parameters = parameters;
    }

    @Override
    protected String[] prepareCommand(String path, String url) {
        if (url != null && url.toLowerCase().startsWith("file:")) {
            url = url.substring(5);
        }
        ArrayList<String> tokenList = new ArrayList<String>();
        StringTokenizer qTokenizer = new StringTokenizer(path.trim(), "\"", true);
        boolean withinQuotation = false;
        String quotedString = "";
        while (qTokenizer.hasMoreTokens()) {
            String curToken = qTokenizer.nextToken();
            if (curToken.equals("\"")) {
                if (withinQuotation) {
                    tokenList.add(quotedString);
                } else {
                    quotedString = "";
                }
                withinQuotation = !withinQuotation;
                continue;
            }
            if (withinQuotation) {
                quotedString = curToken;
                continue;
            }
            StringTokenizer parser = new StringTokenizer(curToken.trim());
            while (parser.hasMoreTokens()) {
                tokenList.add(parser.nextToken());
            }
        }
        boolean substituted = false;
        int i = 0;
        while (i < tokenList.size()) {
            String token = (String)tokenList.get(i);
            String newToken = this.doSubstitutions(token, url);
            if (newToken != null) {
                tokenList.set(i, newToken);
                substituted = true;
            }
            ++i;
        }
        if (!substituted) {
            tokenList.add(url);
        }
        String[] command = new String[tokenList.size()];
        tokenList.toArray(command);
        return command;
    }
}

