# Copyright 2026 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

# Autogenerated by pycargoebuild 0.13.5

EAPI=8

CRATES="
	adler2@2.0.1
	aho-corasick@1.1.3
	anyhow@1.0.99
	arc-swap@1.7.1
	ashpd@0.12.0
	async-broadcast@0.7.2
	async-channel@2.5.0
	async-executor@1.13.3
	async-fs@2.1.3
	async-global-executor@3.1.0
	async-io@2.5.0
	async-lock@3.4.1
	async-net@2.0.0
	async-process@2.4.0
	async-recursion@1.1.1
	async-signal@0.2.12
	async-task@4.7.1
	async-trait@0.1.89
	atomic-waker@1.1.2
	autocfg@1.5.0
	bitflags@2.9.4
	block@0.1.6
	blocking@1.6.2
	bytemuck@1.23.2
	byteorder@1.5.0
	cairo-rs@0.21.1
	cairo-sys-rs@0.21.1
	cc@1.2.36
	cfg-expr@0.20.2
	cfg-if@1.0.3
	cfg_aliases@0.2.1
	chrono@0.4.42
	concurrent-queue@2.5.0
	crc32fast@1.5.0
	crossbeam-deque@0.8.6
	crossbeam-epoch@0.9.18
	crossbeam-utils@0.8.21
	crunchy@0.2.4
	displaydoc@0.2.5
	dlib@0.5.2
	dunce@1.0.5
	either@1.15.0
	encoding_rs@0.8.35
	endi@1.1.0
	enumflags2@0.7.12
	enumflags2_derive@0.7.12
	env_filter@0.1.3
	env_logger@0.11.8
	equivalent@1.0.2
	errno@0.3.14
	event-listener-strategy@0.5.4
	event-listener@5.4.1
	fastrand@2.3.0
	field-offset@0.3.6
	find-msvc-tools@0.1.1
	flate2@1.1.2
	foreign-types-macros@0.2.3
	foreign-types-shared@0.3.1
	foreign-types@0.5.0
	form_urlencoded@1.2.2
	futures-channel@0.3.31
	futures-core@0.3.31
	futures-executor@0.3.31
	futures-io@0.3.31
	futures-lite@2.6.1
	futures-macro@0.3.31
	futures-task@0.3.31
	futures-timer@3.0.3
	futures-util@0.3.31
	gdk-pixbuf-sys@0.21.1
	gdk-pixbuf@0.21.1
	gdk4-sys@0.10.0
	gdk4-wayland-sys@0.10.0
	gdk4-wayland@0.10.0
	gdk4-x11-sys@0.10.0
	gdk4-x11@0.10.0
	gdk4@0.10.0
	getrandom@0.3.3
	gettext-rs@0.7.2
	gettext-sys@0.22.5
	gio-sys@0.21.1
	gio@0.21.1
	glib-macros@0.21.0
	glib-sys@0.21.1
	glib@0.21.1
	glycin-common@1.0.0
	glycin-utils@4.0.4
	glycin@3.0.4
	gobject-sys@0.21.1
	graphene-rs@0.21.1
	graphene-sys@0.21.1
	gsk4-sys@0.10.0
	gsk4@0.10.0
	gtk4-macros@0.10.0
	gtk4-sys@0.10.0
	gtk4@0.10.0
	gufo-common@1.0.1
	gufo-exif@0.3.1
	gufo-jpeg@0.3.0
	gufo-png@0.3.0
	gufo-tiff@0.3.0
	gufo-webp@0.3.0
	gufo-xmp@0.3.0
	gufo@0.3.0
	gvdb-macros@0.1.15
	gvdb@0.9.0
	gweather-sys@4.6.0
	half@2.6.0
	hashbrown@0.15.5
	heck@0.5.0
	hermit-abi@0.5.2
	hex@0.4.3
	icu_collections@2.0.0
	icu_locale_core@2.0.0
	icu_normalizer@2.0.0
	icu_normalizer_data@2.0.0
	icu_properties@2.0.1
	icu_properties_data@2.0.1
	icu_provider@2.0.0
	idna@1.1.0
	idna_adapter@1.2.1
	indexmap@2.11.1
	itoa@1.0.15
	jiff-static@0.2.15
	jiff@0.2.15
	jobserver@0.1.34
	lazy_static@1.5.0
	lcms2-sys@4.0.6
	lcms2@6.1.1
	libadwaita-sys@0.8.0
	libadwaita@0.8.0
	libc@0.2.175
	libgweather@4.6.0
	libloading@0.8.8
	libseccomp-sys@0.3.0
	libseccomp@0.4.0
	linux-raw-sys@0.11.0
	litemap@0.8.0
	litrs@0.5.1
	locale_config@0.3.0
	log@0.4.28
	malloc_buf@0.0.6
	matchers@0.2.0
	memchr@2.7.5
	memfd@0.6.5
	memmap2@0.9.8
	memoffset@0.9.1
	miniz_oxide@0.8.9
	nix@0.30.1
	nu-ansi-term@0.50.1
	num-traits@0.2.19
	objc-foundation@0.1.1
	objc@0.2.7
	objc_id@0.1.1
	once_cell@1.21.3
	ordered-stream@0.2.0
	pango-sys@0.21.1
	pango@0.21.1
	parking@2.2.1
	paste@1.0.15
	percent-encoding@2.3.2
	pin-project-lite@0.2.16
	pin-utils@0.1.0
	piper@0.2.4
	pkg-config@0.3.32
	polling@3.10.0
	portable-atomic-util@0.2.4
	portable-atomic@1.11.1
	potential_utf@0.1.3
	ppv-lite86@0.2.21
	proc-macro-crate@3.3.0
	proc-macro2@1.0.101
	quick-xml@0.38.3
	quote@1.0.40
	r-efi@5.3.0
	rand@0.9.2
	rand_chacha@0.9.0
	rand_core@0.9.3
	rayon-core@1.13.0
	rayon@1.11.0
	regex-automata@0.4.10
	regex-syntax@0.8.6
	regex@1.11.2
	rmp-serde@1.3.0
	rmp@0.8.14
	rustc_version@0.4.1
	rustix@1.1.2
	ryu@1.0.20
	same-file@1.0.6
	semver@1.0.26
	serde@1.0.219
	serde_derive@1.0.219
	serde_json@1.0.143
	serde_repr@0.1.20
	serde_spanned@0.6.9
	sharded-slab@0.1.7
	shlex@1.3.0
	signal-hook-registry@1.4.6
	slab@0.4.11
	smallvec@1.15.1
	stable_deref_trait@1.2.0
	static_assertions@1.1.0
	strum@0.27.2
	strum_macros@0.27.2
	syn@2.0.106
	synstructure@0.13.2
	system-deps@7.0.5
	target-lexicon@0.13.2
	temp-dir@0.1.16
	tempfile@3.22.0
	thiserror-impl@2.0.16
	thiserror@2.0.16
	thread_local@1.1.9
	tinystr@0.8.1
	toml@0.8.23
	toml_datetime@0.6.11
	toml_edit@0.22.27
	tracing-attributes@0.1.30
	tracing-core@0.1.34
	tracing-log@0.2.0
	tracing-subscriber@0.3.20
	tracing@0.1.41
	uds_windows@1.1.0
	unicode-ident@1.0.19
	url@2.5.7
	utf8_iter@1.0.4
	valuable@0.1.1
	version-compare@0.2.0
	walkdir@2.5.0
	wasi@0.14.5+wasi-0.2.4
	wasip2@1.0.0+wasi-0.2.4
	winapi-i686-pc-windows-gnu@0.4.0
	winapi-util@0.1.11
	winapi-x86_64-pc-windows-gnu@0.4.0
	winapi@0.3.9
	windows-link@0.1.3
	windows-sys@0.52.0
	windows-sys@0.60.2
	windows-targets@0.52.6
	windows-targets@0.53.3
	windows_aarch64_gnullvm@0.52.6
	windows_aarch64_gnullvm@0.53.0
	windows_aarch64_msvc@0.52.6
	windows_aarch64_msvc@0.53.0
	windows_i686_gnu@0.52.6
	windows_i686_gnu@0.53.0
	windows_i686_gnullvm@0.52.6
	windows_i686_gnullvm@0.53.0
	windows_i686_msvc@0.52.6
	windows_i686_msvc@0.53.0
	windows_x86_64_gnu@0.52.6
	windows_x86_64_gnu@0.53.0
	windows_x86_64_gnullvm@0.52.6
	windows_x86_64_gnullvm@0.53.0
	windows_x86_64_msvc@0.52.6
	windows_x86_64_msvc@0.53.0
	winnow@0.7.13
	wit-bindgen@0.45.1
	writeable@0.6.1
	x11@2.21.0
	xml-rs@0.8.27
	yeslogic-fontconfig-sys@6.0.0
	yoke-derive@0.8.0
	yoke@0.8.0
	zbus@5.11.0
	zbus_macros@5.11.0
	zbus_names@4.2.0
	zerocopy-derive@0.8.27
	zerocopy@0.8.27
	zerofrom-derive@0.1.6
	zerofrom@0.1.6
	zerotrie@0.2.2
	zerovec-derive@0.11.1
	zerovec@0.11.4
	zvariant@5.7.0
	zvariant_derive@5.7.0
	zvariant_utils@3.2.1
"

RUST_MIN_VER="1.85"

inherit cargo gnome.org gnome2 meson xdg

DESCRIPTION="View images"
HOMEPAGE="https://apps.gnome.org/Loupe"

# SRC_URI for loupe is set by gnome.org eclass.
SRC_URI+=" ${CARGO_CRATE_URIS}"

LICENSE="GPL-3+"
# Dependent crate licenses
LICENSE+="
	Apache-2.0 Apache-2.0-with-LLVM-exceptions BSD ISC MIT Unicode-3.0
	|| ( LGPL-2.1+ MPL-2.0 )
"
SLOT="0"
KEYWORDS="~amd64"

IUSE="X heif gif jpeg jpegxl svg tiff wayland"

BDEPEND="
	dev-util/itstool
	virtual/pkgconfig
"
# sys-crates in pycargoebuild order
DEPEND="
	x11-libs/cairo[X?]
	>x11-libs/gdk-pixbuf-2.42.10-r1[gif?,jpeg?,tiff?]
	dev-libs/glib:2
	sys-devel/gettext
	media-libs/graphene
	x11-libs/pango[X?]
	media-libs/fontconfig
"
# meson.build file
DEPEND+="
	>=gui-libs/gtk-4.16.0:4[X?,wayland?]
	>=gui-libs/libadwaita-1.7.0:1
	>=dev-libs/libgweather-4.0.0:4=
	>=media-libs/lcms-2.12.0:2[jpeg?,tiff?]
	>=sys-libs/libseccomp-2.5.0
"
RDEPEND="${DEPEND}
	media-libs/glycin-loaders:2=[heif?,jpegxl?,svg?]
"

QA_FLAGS_IGNORED="usr/bin/loupe"

src_configure() {
	local emesonargs=(
		$(meson_feature X x11)
	)
	meson_src_configure
	ln -s "${CARGO_HOME}" "${BUILD_DIR}/cargo-home" || die
}

pkg_preinst() {
	xdg_pkg_preinst
}

pkg_postinst() {
	xdg_pkg_postinst
	gnome2_schemas_update
}

pkg_postrm() {
	xdg_pkg_postrm
	gnome2_schemas_update
}
