# QingStor SDK for Go

[![Build Status](https://travis-ci.org/yunify/qingstor-sdk-go.svg?branch=master)](https://travis-ci.org/yunify/qingstor-sdk-go)
[![Go Report Card](https://goreportcard.com/badge/github.com/yunify/qingstor-sdk-go)](https://goreportcard.com/report/github.com/yunify/qingstor-sdk-go)
[![API Reference](http://img.shields.io/badge/api-reference-green.svg)](http://docs.qingcloud.com/qingstor/)
[![License](http://img.shields.io/badge/license-apache%20v2-blue.svg)](https://github.com/yunify/qingstor-sdk-go/blob/master/LICENSE)

[English](README.md) | 中文

Go 语言版本的 QingStor 官方 SDK.

在开始使用 SDK 之前，请确保你对[青云 QingStor 对象存储基本概念](https://docs.qingcloud.com/qingstor/api/common/overview.html)（如 Zone，Service，Bucket，Object 等）有一定的了解。

本 SDK 与[青云 QingStor 对象存储帮助文档](https://docs.qingcloud.com/qingstor/api/)上的方法尽量保持一一对应，具体每个方法的详细说明请查看上述链接中的对应章节。

## 快速开始

你可以根据自己的需要针对性地阅读列表中的内容。

- [准备工作](./docs/prepare_zh-CN.md)
- [安装](./docs/install_zh-CN.md)
- [配置](./docs/config_zh-CN.md)
- [初始化服务](./docs/service_zh-CN.md)
- [代码示例](./docs/examples_zh-CN.md)

查看我们的 [发布历史](https://github.com/yunify/qingstor-sdk-go/releases) 和 [更改日志](./CHANGELOG.md) 获取最新的特性和 bug 修复。

## 参考文档

- [QingStor 文档](https://docs.qingcloud.com/qingstor/index.html)
- [QingStor 指南](https://docs.qingcloud.com/qingstor/guide/index.html)
- [QingStor APIs](https://docs.qingcloud.com/qingstor/api/index.html)

## 贡献

1. Fork 仓库 ( https://github.com/yunify/qingstor-sdk-go/fork )
2. 创建您的 feature 分支 (`git checkout -b new-feature`)
3. 提交您的修改 (`git commit -asm 'Add some feature'`)
4. 推送到您的 origin 仓库 (`git push origin new-feature`)
5. 创建并提交相应的 Pull Request

## 许可证

The Apache License (Version 2.0, January 2004).
