#!/usr/bin/python
#//////////////////////////////////////////////////////////////////////////////
#
# Copyright (c) 2007,2009 Daniel Adler <dadler@uni-goettingen.de>, 
#                         Tassilo Philipp <tphilipp@potion-studios.com>
#
# Permission to use, copy, modify, and distribute this software for any
# purpose with or without fee is hereby granted, provided that the above
# copyright notice and this permission notice appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
# WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
# ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
# WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
# ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
# OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
#
#//////////////////////////////////////////////////////////////////////////////

import sys

# parameters

nargs  = 3

# all types without (float)

types  = ["DCint","DClonglong","DCdouble","DCpointer"]
sigs   = ['i','l','d','p']


# generator

ntypes = len(types)

sys.stderr.write("/* auto generated by mkcase (on stderr) */\n");
sys.stderr.write("".join(["#define NARGS  ",str(nargs),"\n"]))
sys.stderr.write("".join(["#define NTYPES ",str(ntypes),"\n"]))

def powerfact(x, n):
  if n==0:
    return 0
  else:
    return x**n+powerfact(x,n-1)

x     = 0
end   = powerfact(ntypes,nargs)+1

sys.stdout.write("/* auto generated by mkcase.py (on stdout) */\n");

while x < end:
  args = [str(x)]
  sig  = ["f_"]
  pos  = 0
  y    = x
  while y > 0:
    s     = (y-1) % ntypes
    y     = (y-1) / ntypes
    args += [ types[s] ]
    sig  += [ sigs[s] ] # types[s][2] ]
    pos  += 1
  sig   = "".join(sig)
  args += [ sig ]
  args  = ",".join(args)
  sys.stdout.write( "".join(["VF",str(pos),"(",args,")\n"]) )
  x += 1
