/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.tool;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.channels.FileChannel;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import jdk.jfr.internal.tool.Command;
import jdk.jfr.internal.tool.UserDataException;
import jdk.jfr.internal.tool.UserSyntaxException;

final class Assemble
extends Command {
    Assemble() {
    }

    @Override
    public String getName() {
        return "assemble";
    }

    @Override
    public List<String> getOptionSyntax() {
        return Collections.singletonList("<repository> <file>");
    }

    @Override
    public String getDescription() {
        return "Assemble leftover chunks from a disk repository into a recording file";
    }

    @Override
    public void displayOptionUsage(PrintStream printStream) {
        printStream.println("  <repository>   Directory where the repository is located");
        printStream.println();
        printStream.println("  <file>         Name of the recording file (.jfr) to create");
    }

    @Override
    public void execute(Deque<String> deque) throws UserSyntaxException, UserDataException {
        this.ensureMinArgumentCount(deque, 2);
        this.ensureMaxArgumentCount(deque, 2);
        Path path = this.getDirectory(deque.pop());
        Path path2 = Paths.get(deque.pop(), new String[0]);
        this.ensureFileDoesNotExist(path2);
        this.ensureJFRFile(path2);
        try (FileOutputStream fileOutputStream = new FileOutputStream(path2.toFile());){
            List<Path> list = this.listJFRFiles(path);
            if (list.isEmpty()) {
                throw new UserDataException("no *.jfr files found at " + path);
            }
            this.println();
            this.println("Assembling files... ");
            this.println();
            this.transferTo(list, path2, fileOutputStream.getChannel());
            this.println();
            this.println("Finished.");
        }
        catch (IOException iOException) {
            throw new UserDataException("could not open destination file " + path2 + ". " + iOException.getMessage());
        }
    }

    private List<Path> listJFRFiles(Path path3) throws UserDataException {
        try {
            ArrayList<Path> arrayList = new ArrayList<Path>();
            if (Files.isDirectory(path3, new LinkOption[0])) {
                try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path3, "*.jfr");){
                    for (Path path4 : directoryStream) {
                        if (Files.isDirectory(path4, new LinkOption[0]) || !Files.isReadable(path4)) continue;
                        arrayList.add(path4);
                    }
                }
            }
            arrayList.sort((path, path2) -> path.getFileName().compareTo(path2.getFileName()));
            return arrayList;
        }
        catch (IOException iOException) {
            throw new UserDataException("could not list *.jfr for directory " + path3 + ". " + iOException.getMessage());
        }
    }

    private void transferTo(List<Path> list, Path path, FileChannel fileChannel) throws UserDataException {
        long l = 0L;
        for (Path path2 : list) {
            this.println(" " + path2.toString());
            try {
                FileChannel fileChannel2 = FileChannel.open(path2, new OpenOption[0]);
                Throwable throwable = null;
                try {
                    long l2;
                    for (long i = Files.size(path2); i > 0L; i -= l2) {
                        long l3 = Math.min(i, 0x100000L);
                        l2 = fileChannel.transferFrom(fileChannel2, l, l3);
                        l += l2;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (fileChannel2 == null) continue;
                    if (throwable != null) {
                        try {
                            fileChannel2.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    fileChannel2.close();
                }
            }
            catch (IOException iOException) {
                throw new UserDataException("could not copy recording chunk " + path2 + " to new file. " + iOException.getMessage());
            }
        }
    }
}

