/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.legacy.connection;

import com.sun.corba.se.impl.logging.ORBUtilSystemException;
import com.sun.corba.se.impl.orbutil.ORBUtility;
import com.sun.corba.se.spi.legacy.connection.LegacyServerSocketEndPointInfo;
import com.sun.corba.se.spi.legacy.connection.LegacyServerSocketManager;
import com.sun.corba.se.spi.orb.ORB;
import java.util.Collection;
import java.util.Iterator;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;

public class LegacyServerSocketManagerImpl
implements LegacyServerSocketManager {
    protected ORB orb;
    private ORBUtilSystemException wrapper;

    public LegacyServerSocketManagerImpl(ORB oRB) {
        this.orb = oRB;
        this.wrapper = ORBUtilSystemException.get(oRB, "rpc.transport");
    }

    @Override
    public int legacyGetTransientServerPort(String string) {
        return this.legacyGetServerPort(string, false);
    }

    @Override
    public synchronized int legacyGetPersistentServerPort(String string) {
        if (this.orb.getORBData().getServerIsORBActivated()) {
            return this.legacyGetServerPort(string, true);
        }
        if (this.orb.getORBData().getPersistentPortInitialized()) {
            return this.orb.getORBData().getPersistentServerPort();
        }
        throw this.wrapper.persistentServerportNotSet(CompletionStatus.COMPLETED_MAYBE);
    }

    @Override
    public synchronized int legacyGetTransientOrPersistentServerPort(String string) {
        return this.legacyGetServerPort(string, this.orb.getORBData().getServerIsORBActivated());
    }

    @Override
    public synchronized LegacyServerSocketEndPointInfo legacyGetEndpoint(String string) {
        Iterator iterator = this.getAcceptorIterator();
        while (iterator.hasNext()) {
            LegacyServerSocketEndPointInfo legacyServerSocketEndPointInfo = this.cast(iterator.next());
            if (legacyServerSocketEndPointInfo == null || !string.equals(legacyServerSocketEndPointInfo.getName())) continue;
            return legacyServerSocketEndPointInfo;
        }
        throw new INTERNAL("No acceptor for: " + string);
    }

    @Override
    public boolean legacyIsLocalServerPort(int n) {
        Iterator iterator = this.getAcceptorIterator();
        while (iterator.hasNext()) {
            LegacyServerSocketEndPointInfo legacyServerSocketEndPointInfo = this.cast(iterator.next());
            if (legacyServerSocketEndPointInfo == null || legacyServerSocketEndPointInfo.getPort() != n) continue;
            return true;
        }
        return false;
    }

    private int legacyGetServerPort(String string, boolean bl) {
        Iterator iterator = this.getAcceptorIterator();
        while (iterator.hasNext()) {
            LegacyServerSocketEndPointInfo legacyServerSocketEndPointInfo = this.cast(iterator.next());
            if (legacyServerSocketEndPointInfo == null || !legacyServerSocketEndPointInfo.getType().equals(string)) continue;
            if (bl) {
                return legacyServerSocketEndPointInfo.getLocatorPort();
            }
            return legacyServerSocketEndPointInfo.getPort();
        }
        return -1;
    }

    private Iterator getAcceptorIterator() {
        Collection collection = this.orb.getCorbaTransportManager().getAcceptors(null, null);
        if (collection != null) {
            return collection.iterator();
        }
        throw this.wrapper.getServerPortCalledBeforeEndpointsInitialized();
    }

    private LegacyServerSocketEndPointInfo cast(Object object) {
        if (object instanceof LegacyServerSocketEndPointInfo) {
            return (LegacyServerSocketEndPointInfo)object;
        }
        return null;
    }

    protected void dprint(String string) {
        ORBUtility.dprint("LegacyServerSocketManagerImpl", string);
    }
}

