/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.structures.constants;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.gjt.jclasslib.structures.InvalidByteCodeException;
import org.gjt.jclasslib.structures.constants.ConstantLargeNumeric;

public class ConstantDoubleInfo
extends ConstantLargeNumeric {
    public byte getTag() {
        return 6;
    }

    public String getTagVerbose() {
        return "CONSTANT_Double_info";
    }

    public String getVerbose() throws InvalidByteCodeException {
        return String.valueOf(this.getDouble());
    }

    public double getDouble() {
        long l = (long)this.highBytes << 32 | (long)this.lowBytes & 0xFFFFFFFFL;
        return Double.longBitsToDouble(l);
    }

    public void setDouble(double d) {
        long l = Double.doubleToLongBits(d);
        this.highBytes = (int)(l >>> 32 & 0xFFFFFFFFL);
        this.lowBytes = (int)(l & 0xFFFFFFFFL);
    }

    public void read(DataInput dataInput) throws InvalidByteCodeException, IOException {
        super.read(dataInput);
        if (this.debug) {
            this.debug("read ");
        }
    }

    public void write(DataOutput dataOutput) throws InvalidByteCodeException, IOException {
        dataOutput.writeByte(6);
        super.write(dataOutput);
        if (this.debug) {
            this.debug("wrote ");
        }
    }

    protected void debug(String string) {
        super.debug(string + this.getTagVerbose() + " with high_bytes " + this.highBytes + " and low_bytes " + this.lowBytes);
    }
}

