#![cfg_attr(not(test), no_std)]

#[cfg(feature = "alloc")]
extern crate alloc;

include!(concat!(env!("OUT_DIR"), "/code_table.rs"));

#[cfg(feature = "alloc")]
mod string;

#[cfg(feature = "alloc")]
pub use string::*;

/// The type of hashmap used in this crate.
///
/// The hash library may be changed in the future release.
/// Make sure to use only APIs compatible with `std::collections::HashMap`.
pub type OEMCPHashMap<K, V> = phf::Map<K, V>;

pub mod code_table_type {
    /// Wrapper enumerate for decoding tables
    ///
    /// It has 2 types: `Complete`, complete tables (it doesn't have undefined codepoints) / `Incomplete`, incomplete tables (does have ones)
    #[derive(Debug, Clone)]
    pub enum TableType {
        /// complete table, which doen't have any undefined codepoints
        Complete(&'static [char; 128]),
        /// incomplete table, which has some undefined codepoints
        Incomplete(&'static [Option<char>; 128]),
    }
}
