sidebarNodes={"modules":[],"extras":[{"id":"readme","group":"","title":"Erlang/OTP System Documentation","headers":[]},{"id":"installation_guide","group":"Installation Guide","title":"Introduction","headers":[]},{"id":"install","group":"Installation Guide","title":"Building and Installing Erlang/OTP","headers":[{"id":"Introduction","anchor":"introduction"},{"id":"Required Utilities","anchor":"required-utilities"},{"id":"Optional Utilities","anchor":"optional-utilities"},{"id":"How to Build and Install Erlang/OTP","anchor":"how-to-build-and-install-erlang-otp"},{"id":"Advanced configuration and build of Erlang/OTP","anchor":"advanced-configuration-and-build-of-erlang-otp"},{"id":"Erlang/OTP test architectures","anchor":"erlang-otp-test-architectures"}]},{"id":"install-cross","group":"Installation Guide","title":"Cross Compiling Erlang/OTP","headers":[{"id":"Introduction","anchor":"introduction"},{"id":"Build and Install Procedure","anchor":"build-and-install-procedure"},{"id":"Building and Installing the Documentation","anchor":"building-and-installing-the-documentation"},{"id":"Testing the cross compiled system","anchor":"testing-the-cross-compiled-system"},{"id":"Currently Used Configuration Variables","anchor":"currently-used-configuration-variables"}]},{"id":"install-win32","group":"Installation Guide","title":"Building Erlang/OTP on Windows","headers":[{"id":"Introduction","anchor":"introduction"},{"id":"Short Version","anchor":"short-version"},{"id":"Tools you Need and Their Environment","anchor":"tools-you-need-and-their-environment"},{"id":"The Shell Environment","anchor":"the-shell-environment"},{"id":"Building and Installing","anchor":"building-and-installing"},{"id":"Development","anchor":"development"},{"id":"Frequently Asked Questions","anchor":"frequently-asked-questions"}]},{"id":"otp-patch-apply","group":"Installation Guide","title":"Patching OTP Applications","headers":[{"id":"Introduction","anchor":"introduction"},{"id":"Prerequisites","anchor":"prerequisites"},{"id":"Using otp_patch_apply","anchor":"using-otp_patch_apply"},{"id":"Sanity check","anchor":"sanity-check"}]},{"id":"getting_started","group":"Getting Started With Erlang","title":"Introduction","headers":[{"id":"Prerequisites","anchor":"prerequisites"},{"id":"Omitted Topics","anchor":"omitted-topics"}]},{"id":"seq_prog","group":"Getting Started With Erlang","title":"Sequential Programming","headers":[{"id":"The Erlang Shell","anchor":"the-erlang-shell"},{"id":"Modules and Functions","anchor":"modules-and-functions"},{"id":"Atoms","anchor":"atoms"},{"id":"Tuples","anchor":"tuples"},{"id":"Lists","anchor":"lists"},{"id":"Maps","anchor":"maps"},{"id":"Standard Modules and Manual Pages","anchor":"standard-modules-and-manual-pages"},{"id":"Writing Output to a Terminal","anchor":"writing-output-to-a-terminal"},{"id":"A Larger Example","anchor":"a-larger-example"},{"id":"Matching, Guards, and Scope of Variables","anchor":"matching-guards-and-scope-of-variables"},{"id":"More About Lists","anchor":"more-about-lists"},{"id":"If and Case","anchor":"if-and-case"},{"id":"Built-In Functions (BIFs)","anchor":"built-in-functions-bifs"},{"id":"Higher-Order Functions (Funs)","anchor":"higher-order-functions-funs"}]},{"id":"conc_prog","group":"Getting Started With Erlang","title":"Concurrent Programming","headers":[{"id":"Processes","anchor":"processes"},{"id":"Message Passing","anchor":"message-passing"},{"id":"Registered Process Names","anchor":"registered-process-names"},{"id":"Distributed Programming","anchor":"distributed-programming"},{"id":"A Larger Example","anchor":"a-larger-example"}]},{"id":"robustness","group":"Getting Started With Erlang","title":"Robustness","headers":[{"id":"Time-outs","anchor":"time-outs"},{"id":"Error Handling","anchor":"error-handling"},{"id":"The Larger Example with Robustness Added","anchor":"the-larger-example-with-robustness-added"}]},{"id":"records_macros","group":"Getting Started With Erlang","title":"Records and Macros","headers":[{"id":"The Larger Example Divided into Several Files","anchor":"the-larger-example-divided-into-several-files"},{"id":"Header Files","anchor":"header-files"},{"id":"Records","anchor":"records"},{"id":"Macros","anchor":"macros"}]},{"id":"howto_debug","group":"Getting Started With Erlang","title":"Debugging","headers":[{"id":"Tracing","anchor":"tracing"},{"id":"Debugger","anchor":"debugger"},{"id":"Print debugging","anchor":"print-debugging"}]},{"id":"system_principles","group":"System Principles","title":"System Principles","headers":[{"id":"Starting the System","anchor":"starting-the-system"},{"id":"Restarting and Stopping the System","anchor":"restarting-and-stopping-the-system"},{"id":"Boot Scripts","anchor":"boot-scripts"},{"id":"Code Loading Strategy","anchor":"code-loading-strategy"},{"id":"File Types","anchor":"file-types"}]},{"id":"error_logging","group":"System Principles","title":"Error Logging","headers":[{"id":"Error Information From the Runtime System","anchor":"error-information-from-the-runtime-system"},{"id":"Log events from OTP behaviours","anchor":"log-events-from-otp-behaviours"}]},{"id":"create_target","group":"System Principles","title":"Creating and Upgrading a Target System","headers":[{"id":"Creating a Target System","anchor":"creating-a-target-system"},{"id":"Installing a Target System","anchor":"installing-a-target-system"},{"id":"Starting a Target System","anchor":"starting-a-target-system"},{"id":"System Configuration Parameters","anchor":"system-configuration-parameters"},{"id":"Differences From the Install Script","anchor":"differences-from-the-install-script"},{"id":"Creating the Next Version","anchor":"creating-the-next-version"},{"id":"Upgrading the Target System","anchor":"upgrading-the-target-system"},{"id":"Listing of target_system.erl","anchor":"listing-of-target_system-erl"}]},{"id":"upgrade","group":"System Principles","title":"Upgrade when Erlang/OTP has Changed","headers":[{"id":"Introduction","anchor":"introduction"},{"id":"Upgrade of Core Applications","anchor":"upgrade-of-core-applications"},{"id":"Applications that Still do Not Allow Code Upgrade","anchor":"applications-that-still-do-not-allow-code-upgrade"}]},{"id":"versions","group":"System Principles","title":"Versions","headers":[{"id":"OTP Version","anchor":"otp-version"},{"id":"Application Version","anchor":"application-version"},{"id":"Version Scheme","anchor":"version-scheme"},{"id":"Releases and Patches","anchor":"releases-and-patches"},{"id":"OTP Versions Tree","anchor":"otp-versions-tree"},{"id":"OTP 17.0 Application Versions","anchor":"otp-17-0-application-versions"}]},{"id":"misc","group":"System Principles","title":"Support, Compatibility, Deprecations, and Removal","headers":[{"id":"Introduction","anchor":"introduction"},{"id":"Supported Releases","anchor":"supported-releases"},{"id":"Compatibility","anchor":"compatibility"},{"id":"Deprecation","anchor":"deprecation"},{"id":"Removal","anchor":"removal"}]},{"id":"design_principles","group":"OTP Design Principles","title":"Overview","headers":[{"id":"Supervision Trees","anchor":"supervision-trees"},{"id":"Behaviours","anchor":"behaviours"},{"id":"Applications","anchor":"applications"},{"id":"Releases","anchor":"releases"},{"id":"Release Handling","anchor":"release-handling"}]},{"id":"gen_server_concepts","group":"OTP Design Principles","title":"gen_server Behaviour","headers":[{"id":"Client-Server Principles","anchor":"client-server-principles"},{"id":"Example","anchor":"example"},{"id":"Starting a Gen_Server","anchor":"starting-a-gen_server"},{"id":"Synchronous Requests - Call","anchor":"synchronous-requests-call"},{"id":"Asynchronous Requests - Cast","anchor":"asynchronous-requests-cast"},{"id":"Stopping","anchor":"stopping"},{"id":"Handling Other Messages","anchor":"handling-other-messages"}]},{"id":"statem","group":"OTP Design Principles","title":"gen_statem Behaviour","headers":[{"id":"Event-Driven State Machines","anchor":"event-driven-state-machines"},{"id":"When to use gen_statem","anchor":"when-to-use-gen_statem"},{"id":"Callback Module","anchor":"callback-module"},{"id":"Callback Modes","anchor":"callback-modes"},{"id":"State Callback","anchor":"state-callback"},{"id":"Transition Actions","anchor":"transition-actions"},{"id":"Event Types and Event Content","anchor":"event-types-and-event-content"},{"id":"State Enter Calls","anchor":"state-enter-calls"},{"id":"Time-Outs","anchor":"time-outs"},{"id":"Example","anchor":"example"},{"id":"Starting gen_statem","anchor":"starting-gen_statem"},{"id":"Handling Events","anchor":"handling-events"},{"id":"State Time-Outs","anchor":"state-time-outs"},{"id":"All State Events","anchor":"all-state-events"},{"id":"One State Callback","anchor":"one-state-callback"},{"id":"Stopping","anchor":"stopping"},{"id":"Event Time-Outs","anchor":"event-time-outs"},{"id":"Generic Time-Outs","anchor":"generic-time-outs"},{"id":"Erlang Timers","anchor":"erlang-timers"},{"id":"Postponing Events","anchor":"postponing-events"},{"id":"State Enter Actions","anchor":"state-enter-actions"},{"id":"Inserted Events","anchor":"inserted-events"},{"id":"Example Revisited","anchor":"example-revisited"},{"id":"Filter the State","anchor":"filter-the-state"},{"id":"Complex State","anchor":"complex-state"},{"id":"Hibernation","anchor":"hibernation"}]},{"id":"events","group":"OTP Design Principles","title":"gen_event Behaviour","headers":[{"id":"Event Handling Principles","anchor":"event-handling-principles"},{"id":"Example","anchor":"example"},{"id":"Starting an Event Manager","anchor":"starting-an-event-manager"},{"id":"Adding an Event Handler","anchor":"adding-an-event-handler"},{"id":"Notifying about Events","anchor":"notifying-about-events"},{"id":"Deleting an Event Handler","anchor":"deleting-an-event-handler"},{"id":"Stopping","anchor":"stopping"},{"id":"Handling Other Messages","anchor":"handling-other-messages"}]},{"id":"sup_princ","group":"OTP Design Principles","title":"Supervisor Behaviour","headers":[{"id":"Supervision Principles","anchor":"supervision-principles"},{"id":"Example","anchor":"example"},{"id":"Supervisor Flags","anchor":"supervisor-flags"},{"id":"Restart Strategy","anchor":"restart-strategy"},{"id":"Maximum Restart Intensity","anchor":"maximum-restart-intensity"},{"id":"Automatic Shutdown","anchor":"automatic-shutdown"},{"id":"Child Specification","anchor":"child-specification"},{"id":"Starting a Supervisor","anchor":"starting-a-supervisor"},{"id":"Adding a Child Process","anchor":"adding-a-child-process"},{"id":"Stopping a Child Process","anchor":"stopping-a-child-process"},{"id":"Simplified one_for_one Supervisors","anchor":"simplified-one_for_one-supervisors"},{"id":"Stopping","anchor":"stopping"}]},{"id":"spec_proc","group":"OTP Design Principles","title":"sys and proc_lib","headers":[{"id":"Simple Debugging","anchor":"simple-debugging"},{"id":"Special Processes","anchor":"special-processes"},{"id":"User-Defined Behaviours","anchor":"user-defined-behaviours"}]},{"id":"applications","group":"OTP Design Principles","title":"Applications","headers":[{"id":"Application Concept","anchor":"application-concept"},{"id":"Application Callback Module","anchor":"application-callback-module"},{"id":"Application Resource File","anchor":"application-resource-file"},{"id":"Directory Structure","anchor":"directory-structure"},{"id":"Application Controller","anchor":"application-controller"},{"id":"Loading and Unloading Applications","anchor":"loading-and-unloading-applications"},{"id":"Starting and Stopping Applications","anchor":"starting-and-stopping-applications"},{"id":"Configuring an Application","anchor":"configuring-an-application"},{"id":"Application Start Types","anchor":"application-start-types"}]},{"id":"included_applications","group":"OTP Design Principles","title":"Included Applications","headers":[{"id":"Introduction","anchor":"introduction"},{"id":"Specifying Included Applications","anchor":"specifying-included-applications"},{"id":"Synchronizing Processes during Startup","anchor":"synchronizing-processes-during-startup"}]},{"id":"distributed_applications","group":"OTP Design Principles","title":"Distributed Applications","headers":[{"id":"Introduction","anchor":"introduction"},{"id":"Specifying Distributed Applications","anchor":"specifying-distributed-applications"},{"id":"Starting and Stopping Distributed Applications","anchor":"starting-and-stopping-distributed-applications"},{"id":"Failover","anchor":"failover"},{"id":"Takeover","anchor":"takeover"}]},{"id":"release_structure","group":"OTP Design Principles","title":"Releases","headers":[{"id":"Release Concept","anchor":"release-concept"},{"id":"Release Resource File","anchor":"release-resource-file"},{"id":"Generating Boot Scripts","anchor":"generating-boot-scripts"},{"id":"Creating a Release Package","anchor":"creating-a-release-package"},{"id":"Directory Structure","anchor":"directory-structure"}]},{"id":"release_handling","group":"OTP Design Principles","title":"Release Handling","headers":[{"id":"Release Handling Principles","anchor":"release-handling-principles"},{"id":"Requirements","anchor":"requirements"},{"id":"Distributed Systems","anchor":"distributed-systems"},{"id":"Release Handling Instructions","anchor":"release-handling-instructions"},{"id":"Application Upgrade File","anchor":"application-upgrade-file"},{"id":"Release Upgrade File","anchor":"release-upgrade-file"},{"id":"Installing a Release","anchor":"installing-a-release"},{"id":"Updating Application Specifications","anchor":"updating-application-specifications"}]},{"id":"appup_cookbook","group":"OTP Design Principles","title":"Appup Cookbook","headers":[{"id":"Changing a Functional Module","anchor":"changing-a-functional-module"},{"id":"Changing a Residence Module","anchor":"changing-a-residence-module"},{"id":"Changing a Callback Module","anchor":"changing-a-callback-module"},{"id":"Changing Internal State","anchor":"changing-internal-state"},{"id":"Module Dependencies","anchor":"module-dependencies"},{"id":"Changing Code for a Special Process","anchor":"changing-code-for-a-special-process"},{"id":"Changing a Supervisor","anchor":"changing-a-supervisor"},{"id":"Adding or Deleting a Module","anchor":"adding-or-deleting-a-module"},{"id":"Starting or Terminating a Process","anchor":"starting-or-terminating-a-process"},{"id":"Adding or Removing an Application","anchor":"adding-or-removing-an-application"},{"id":"Restarting an Application","anchor":"restarting-an-application"},{"id":"Changing an Application Specification","anchor":"changing-an-application-specification"},{"id":"Changing Application Configuration","anchor":"changing-application-configuration"},{"id":"Changing Included Applications","anchor":"changing-included-applications"},{"id":"Changing Non-Erlang Code","anchor":"changing-non-erlang-code"},{"id":"Runtime System Restart and Upgrade","anchor":"runtime-system-restart-and-upgrade"}]},{"id":"programming_examples","group":"Programming Examples","title":"Introduction","headers":[]},{"id":"prog_ex_records","group":"Programming Examples","title":"Records","headers":[{"id":"Records and Tuples","anchor":"records-and-tuples"},{"id":"Defining a Record","anchor":"defining-a-record"},{"id":"Creating a Record","anchor":"creating-a-record"},{"id":"Accessing a Record Field","anchor":"accessing-a-record-field"},{"id":"Updating a Record","anchor":"updating-a-record"},{"id":"Type Testing","anchor":"type-testing"},{"id":"Pattern Matching","anchor":"pattern-matching"},{"id":"Nested Records","anchor":"nested-records"},{"id":"A Longer Example","anchor":"a-longer-example"}]},{"id":"funs","group":"Programming Examples","title":"Funs","headers":[{"id":"map","anchor":"map"},{"id":"foreach","anchor":"foreach"},{"id":"Syntax of Funs","anchor":"syntax-of-funs"},{"id":"Variable Bindings Within a Fun","anchor":"variable-bindings-within-a-fun"},{"id":"Funs and Module Lists","anchor":"funs-and-module-lists"},{"id":"Funs Returning Funs","anchor":"funs-returning-funs"}]},{"id":"list_comprehensions","group":"Programming Examples","title":"List Comprehensions","headers":[{"id":"Simple Examples","anchor":"simple-examples"},{"id":"Quick Sort","anchor":"quick-sort"},{"id":"Permutations","anchor":"permutations"},{"id":"Pythagorean Triplets","anchor":"pythagorean-triplets"},{"id":"Simplifications With List Comprehensions","anchor":"simplifications-with-list-comprehensions"},{"id":"Variable Bindings in List Comprehensions","anchor":"variable-bindings-in-list-comprehensions"},{"id":"Strict and Relaxed Generators","anchor":"strict-and-relaxed-generators"}]},{"id":"bit_syntax","group":"Programming Examples","title":"Bit Syntax","headers":[{"id":"Introduction","anchor":"introduction"},{"id":"Lexical Note","anchor":"lexical-note"},{"id":"Segments","anchor":"segments"},{"id":"Defaults","anchor":"defaults"},{"id":"Constructing Binaries and Bitstrings","anchor":"constructing-binaries-and-bitstrings"},{"id":"Matching Binaries","anchor":"matching-binaries"},{"id":"Appending to a Binary","anchor":"appending-to-a-binary"}]},{"id":"reference_manual","group":"Erlang Reference Manual","title":"Introduction","headers":[{"id":"Purpose","anchor":"purpose"},{"id":"Prerequisites","anchor":"prerequisites"},{"id":"Document Conventions","anchor":"document-conventions"},{"id":"Complete List of BIFs","anchor":"complete-list-of-bifs"},{"id":"Reserved Words","anchor":"reserved-words"}]},{"id":"character_set","group":"Erlang Reference Manual","title":"Character Set and Source File Encoding","headers":[{"id":"Character Set","anchor":"character-set"},{"id":"Source File Encoding","anchor":"source-file-encoding"}]},{"id":"data_types","group":"Erlang Reference Manual","title":"Data Types","headers":[{"id":"Terms","anchor":"terms"},{"id":"Number","anchor":"number"},{"id":"Atom","anchor":"atom"},{"id":"Bit Strings and Binaries","anchor":"bit-strings-and-binaries"},{"id":"Reference","anchor":"reference"},{"id":"Fun","anchor":"fun"},{"id":"Port Identifier","anchor":"port-identifier"},{"id":"Pid","anchor":"pid"},{"id":"Tuple","anchor":"tuple"},{"id":"Map","anchor":"map"},{"id":"List","anchor":"list"},{"id":"String","anchor":"string"},{"id":"Sigil","anchor":"sigil"},{"id":"Record","anchor":"record"},{"id":"Boolean","anchor":"boolean"},{"id":"Escape Sequences","anchor":"escape-sequences"},{"id":"Type Conversions","anchor":"type-conversions"}]},{"id":"patterns","group":"Erlang Reference Manual","title":"Pattern Matching","headers":[{"id":"Pattern Matching","anchor":"pattern-matching"}]},{"id":"modules","group":"Erlang Reference Manual","title":"Modules","headers":[{"id":"Module Syntax","anchor":"module-syntax"},{"id":"Module Attributes","anchor":"module-attributes"},{"id":"The feature directive","anchor":"the-feature-directive"},{"id":"Comments","anchor":"comments"},{"id":"module_info/0 and module_info/1 functions","anchor":"module_info-0-and-module_info-1-functions"}]},{"id":"documentation","group":"Erlang Reference Manual","title":"Documentation","headers":[{"id":"Documentation metadata","anchor":"documentation-metadata"},{"id":"External documentation files","anchor":"external-documentation-files"},{"id":"Documenting a module","anchor":"documenting-a-module"},{"id":"Documenting functions, user-defined types, and callbacks","anchor":"documenting-functions-user-defined-types-and-callbacks"},{"id":"Links in Markdown","anchor":"links-in-markdown"},{"id":"What is visible versus hidden?","anchor":"what-is-visible-versus-hidden"},{"id":"Compiling and getting documentation","anchor":"compiling-and-getting-documentation"},{"id":"Using ExDoc to generate HTML/ePub documentation","anchor":"using-exdoc-to-generate-html-epub-documentation"}]},{"id":"ref_man_functions","group":"Erlang Reference Manual","title":"Functions","headers":[{"id":"Function Declaration Syntax","anchor":"function-declaration-syntax"},{"id":"Function Evaluation","anchor":"function-evaluation"},{"id":"Tail recursion","anchor":"tail-recursion"},{"id":"Built-In Functions (BIFs)","anchor":"built-in-functions-bifs"}]},{"id":"typespec","group":"Erlang Reference Manual","title":"Types and Function Specifications","headers":[{"id":"The Erlang Type Language","anchor":"the-erlang-type-language"},{"id":"Types and their Syntax","anchor":"types-and-their-syntax"},{"id":"Type Declarations of User-Defined Types","anchor":"type-declarations-of-user-defined-types"},{"id":"Type Information in Record Declarations","anchor":"type-information-in-record-declarations"},{"id":"Specifications for Functions","anchor":"specifications-for-functions"}]},{"id":"opaques","group":"Erlang Reference Manual","title":"Opaques","headers":[{"id":"Opaque Type Aliases","anchor":"opaque-type-aliases"}]},{"id":"nominals","group":"Erlang Reference Manual","title":"Nominals","headers":[{"id":"Rationale and Syntax","anchor":"rationale-and-syntax"},{"id":"Nominal Type-Checking Rules","anchor":"nominal-type-checking-rules"}]},{"id":"expressions","group":"Erlang Reference Manual","title":"Expressions","headers":[{"id":"Expression Evaluation","anchor":"expression-evaluation"},{"id":"Terms","anchor":"terms"},{"id":"Variables","anchor":"variables"},{"id":"Patterns","anchor":"patterns"},{"id":"The Match Operator","anchor":"the-match-operator"},{"id":"The Match Operator and the Compound Pattern Operator","anchor":"the-match-operator-and-the-compound-pattern-operator"},{"id":"Function Calls","anchor":"function-calls"},{"id":"If","anchor":"if"},{"id":"Case","anchor":"case"},{"id":"Maybe","anchor":"maybe"},{"id":"Send","anchor":"send"},{"id":"Receive","anchor":"receive"},{"id":"Term Comparisons","anchor":"term-comparisons"},{"id":"Arithmetic Expressions","anchor":"arithmetic-expressions"},{"id":"Boolean Expressions","anchor":"boolean-expressions"},{"id":"Short-Circuit Expressions","anchor":"short-circuit-expressions"},{"id":"List Operations","anchor":"list-operations"},{"id":"Map Expressions","anchor":"map-expressions"},{"id":"Bit Syntax Expressions","anchor":"bit-syntax-expressions"},{"id":"Fun Expressions","anchor":"fun-expressions"},{"id":"Catch and Throw","anchor":"catch-and-throw"},{"id":"Try","anchor":"try"},{"id":"Parenthesized Expressions","anchor":"parenthesized-expressions"},{"id":"Block Expressions","anchor":"block-expressions"},{"id":"Comprehensions","anchor":"comprehensions"},{"id":"Guard Sequences","anchor":"guard-sequences"},{"id":"Guard Expressions","anchor":"guard-expressions"},{"id":"Operator Precedence","anchor":"operator-precedence"}]},{"id":"macros","group":"Erlang Reference Manual","title":"Preprocessor","headers":[{"id":"File Inclusion","anchor":"file-inclusion"},{"id":"Defining and Using Macros","anchor":"defining-and-using-macros"},{"id":"Predefined Macros","anchor":"predefined-macros"},{"id":"Macros Overloading","anchor":"macros-overloading"},{"id":"Removing a macro definition","anchor":"removing-a-macro-definition"},{"id":"Conditional Compilation","anchor":"conditional-compilation"},{"id":"The -feature() directive","anchor":"the-feature-directive"},{"id":"-error() and -warning() directives","anchor":"error-and-warning-directives"},{"id":"Stringifying Macro Arguments","anchor":"stringifying-macro-arguments"}]},{"id":"ref_man_records","group":"Erlang Reference Manual","title":"Records","headers":[{"id":"Defining Records","anchor":"defining-records"},{"id":"Creating Records","anchor":"creating-records"},{"id":"Accessing Record Fields","anchor":"accessing-record-fields"},{"id":"Updating Records","anchor":"updating-records"},{"id":"Records in Guards","anchor":"records-in-guards"},{"id":"Records in Patterns","anchor":"records-in-patterns"},{"id":"Nested Records","anchor":"nested-records"},{"id":"Internal Representation of Records","anchor":"internal-representation-of-records"}]},{"id":"errors","group":"Erlang Reference Manual","title":"Errors and Error Handling","headers":[{"id":"Terminology","anchor":"terminology"},{"id":"Exceptions","anchor":"exceptions"},{"id":"Handling of Run-time Errors in Erlang","anchor":"handling-of-run-time-errors-in-erlang"},{"id":"Exit Reasons","anchor":"exit-reasons"}]},{"id":"features","group":"Erlang Reference Manual","title":"Features","headers":[{"id":"Life cycle of features","anchor":"life-cycle-of-features"},{"id":"Enabling and Disabling Features","anchor":"enabling-and-disabling-features"},{"id":"Preprocessor Additions","anchor":"preprocessor-additions"},{"id":"Information about Existing Features","anchor":"information-about-existing-features"},{"id":"Existing Features","anchor":"existing-features"}]},{"id":"ref_man_processes","group":"Erlang Reference Manual","title":"Processes","headers":[{"id":"Processes","anchor":"processes"},{"id":"Process Creation","anchor":"process-creation"},{"id":"Registered Processes","anchor":"registered-processes"},{"id":"Process Aliases","anchor":"process-aliases"},{"id":"Process Termination","anchor":"process-termination"},{"id":"Signals","anchor":"signals"},{"id":"Links","anchor":"links"},{"id":"Error Handling","anchor":"error-handling"},{"id":"Monitors","anchor":"monitors"},{"id":"Process Dictionary","anchor":"process-dictionary"}]},{"id":"distributed","group":"Erlang Reference Manual","title":"Distributed Erlang","headers":[{"id":"Distributed Erlang System","anchor":"distributed-erlang-system"},{"id":"Nodes","anchor":"nodes"},{"id":"Node Connections","anchor":"node-connections"},{"id":"epmd","anchor":"epmd"},{"id":"Hidden Nodes","anchor":"hidden-nodes"},{"id":"Dynamic Node Name","anchor":"dynamic-node-name"},{"id":"C Nodes","anchor":"c-nodes"},{"id":"Security","anchor":"security"},{"id":"Distribution BIFs","anchor":"distribution-bifs"},{"id":"Distribution Command-Line Flags","anchor":"distribution-command-line-flags"},{"id":"Distribution Modules","anchor":"distribution-modules"}]},{"id":"code_loading","group":"Erlang Reference Manual","title":"Compilation and Code Loading","headers":[{"id":"Compilation","anchor":"compilation"},{"id":"Code Loading","anchor":"code-loading"},{"id":"Code Replacement","anchor":"code-replacement"},{"id":"Running a Function When a Module is Loaded","anchor":"running-a-function-when-a-module-is-loaded"}]},{"id":"ports","group":"Erlang Reference Manual","title":"Ports and Port Drivers","headers":[{"id":"Ports","anchor":"ports"},{"id":"Port Drivers","anchor":"port-drivers"},{"id":"Port BIFs","anchor":"port-bifs"}]},{"id":"efficiency_guide","group":"Efficiency Guide","title":"Introduction","headers":[{"id":"Purpose","anchor":"purpose"},{"id":"Prerequisites","anchor":"prerequisites"}]},{"id":"commoncaveats","group":"Efficiency Guide","title":"Common Caveats","headers":[{"id":"Operator ++","anchor":"operator"},{"id":"Timer Module","anchor":"timer-module"},{"id":"Accidental Copying and Loss of Sharing","anchor":"accidental-copying-and-loss-of-sharing"},{"id":"list_to_atom/1","anchor":"list_to_atom-1"},{"id":"length/1","anchor":"length-1"},{"id":"setelement/3","anchor":"setelement-3"},{"id":"size/1","anchor":"size-1"},{"id":"Using NIFs","anchor":"using-nifs"}]},{"id":"binaryhandling","group":"Efficiency Guide","title":"Constructing and Matching Binaries","headers":[{"id":"How Binaries are Implemented","anchor":"how-binaries-are-implemented"},{"id":"Constructing Binaries","anchor":"constructing-binaries"},{"id":"Matching Binaries","anchor":"matching-binaries"}]},{"id":"maps","group":"Efficiency Guide","title":"Maps","headers":[{"id":"Maps or Records?","anchor":"maps-or-records"},{"id":"Using Maps as an Alternative to Records","anchor":"using-maps-as-an-alternative-to-records"},{"id":"Using Maps as Dictionaries","anchor":"using-maps-as-dictionaries"},{"id":"Using Maps as Sets","anchor":"using-maps-as-sets"},{"id":"How Maps are Implemented","anchor":"how-maps-are-implemented"},{"id":"Using the Map Syntax","anchor":"using-the-map-syntax"},{"id":"Using the Functions in the maps Module","anchor":"using-the-functions-in-the-maps-module"}]},{"id":"listhandling","group":"Efficiency Guide","title":"List Handling","headers":[{"id":"Creating a List","anchor":"creating-a-list"},{"id":"List Comprehensions","anchor":"list-comprehensions"},{"id":"Deep and Flat Lists","anchor":"deep-and-flat-lists"},{"id":"Recursive List Functions","anchor":"recursive-list-functions"}]},{"id":"eff_guide_functions","group":"Efficiency Guide","title":"Functions","headers":[{"id":"Pattern Matching","anchor":"pattern-matching"},{"id":"Function Calls","anchor":"function-calls"}]},{"id":"tablesdatabases","group":"Efficiency Guide","title":"Tables and Databases","headers":[{"id":"Ets, Dets, and Mnesia","anchor":"ets-dets-and-mnesia"},{"id":"ETS","anchor":"ets"},{"id":"Mnesia","anchor":"mnesia"}]},{"id":"eff_guide_processes","group":"Efficiency Guide","title":"Processes","headers":[{"id":"Creating an Erlang Process","anchor":"creating-an-erlang-process"},{"id":"Sending Messages","anchor":"sending-messages"},{"id":"Fetching Received Messages","anchor":"fetching-received-messages"},{"id":"Literal Pool","anchor":"literal-pool"},{"id":"Loss of Sharing","anchor":"loss-of-sharing"},{"id":"SMP Run-Time System","anchor":"smp-run-time-system"}]},{"id":"drivers","group":"Efficiency Guide","title":"Drivers","headers":[{"id":"Drivers and Concurrency","anchor":"drivers-and-concurrency"},{"id":"Avoiding Copying Binaries When Calling a Driver","anchor":"avoiding-copying-binaries-when-calling-a-driver"},{"id":"Returning Small Binaries from a Driver","anchor":"returning-small-binaries-from-a-driver"},{"id":"Returning Large Binaries without Copying from a Driver","anchor":"returning-large-binaries-without-copying-from-a-driver"}]},{"id":"memory","group":"Efficiency Guide","title":"Memory Usage","headers":[]},{"id":"system_limits","group":"Efficiency Guide","title":"System Limits","headers":[]},{"id":"profiling","group":"Efficiency Guide","title":"Profiling","headers":[{"id":"Never Guess About Performance Bottlenecks","anchor":"never-guess-about-performance-bottlenecks"},{"id":"Memory profiling","anchor":"memory-profiling"},{"id":"Large Systems","anchor":"large-systems"},{"id":"What to Look For","anchor":"what-to-look-for"},{"id":"Tools","anchor":"tools"}]},{"id":"benchmarking","group":"Efficiency Guide","title":"Benchmarking","headers":[{"id":"Using erlperf","anchor":"using-erlperf"},{"id":"Benchmarking using Erlang/OTP functionality","anchor":"benchmarking-using-erlang-otp-functionality"}]},{"id":"tutorial","group":"Interoperability Tutorial","title":"Introduction","headers":[{"id":"Purpose","anchor":"purpose"},{"id":"Prerequisites","anchor":"prerequisites"}]},{"id":"overview","group":"Interoperability Tutorial","title":"Overview","headers":[{"id":"Built-In Mechanisms","anchor":"built-in-mechanisms"},{"id":"C and Java Libraries","anchor":"c-and-java-libraries"},{"id":"Standard Protocols","anchor":"standard-protocols"},{"id":"IC and CORBA","anchor":"ic-and-corba"}]},{"id":"example","group":"Interoperability Tutorial","title":"Problem Example","headers":[{"id":"Description","anchor":"description"}]},{"id":"c_port","group":"Interoperability Tutorial","title":"Ports","headers":[{"id":"Erlang Program","anchor":"erlang-program"},{"id":"C Program","anchor":"c-program"},{"id":"Running the Example","anchor":"running-the-example"}]},{"id":"erl_interface","group":"Interoperability Tutorial","title":"Erl_Interface","headers":[{"id":"Erlang Program","anchor":"erlang-program"},{"id":"C Program","anchor":"c-program"},{"id":"Running the Example","anchor":"running-the-example"}]},{"id":"c_portdriver","group":"Interoperability Tutorial","title":"Port Drivers","headers":[{"id":"Erlang Program","anchor":"erlang-program"},{"id":"C Driver","anchor":"c-driver"},{"id":"Running the Example","anchor":"running-the-example"}]},{"id":"cnode","group":"Interoperability Tutorial","title":"C Nodes","headers":[]},{"id":"nif","group":"Interoperability Tutorial","title":"NIFs","headers":[{"id":"Erlang Program","anchor":"erlang-program"},{"id":"NIF Library Code","anchor":"nif-library-code"},{"id":"Running the Example","anchor":"running-the-example"}]},{"id":"debugging","group":"Interoperability Tutorial","title":"Debugging NIFs and Port Drivers","headers":[{"id":"With great power comes great responsibilty","anchor":"with-great-power-comes-great-responsibilty"},{"id":"Debug emulator","anchor":"debug-emulator"},{"id":"Address Sanitizer","anchor":"address-sanitizer"},{"id":"Valgrind","anchor":"valgrind"},{"id":"rr - Record and Replay","anchor":"rr-record-and-replay"}]},{"id":"embedded","group":"Embedded Systems User's Guide","title":"Introduction","headers":[{"id":"Installing an Embedded System","anchor":"installing-an-embedded-system"},{"id":"Starting Erlang","anchor":"starting-erlang"},{"id":"Programs","anchor":"programs"}]},{"id":"sbom","group":"Software Bill Of Materials","title":"Software Bill Of Materials","headers":[{"id":"Source SBOM Structure And General Understanding","anchor":"source-sbom-structure-and-general-understanding"},{"id":"Verification Of Source SBOM","anchor":"verification-of-source-sbom"}]},{"id":"vulnerabilities","group":"VEX Statements","title":"Vulnerabilities","headers":[{"id":"Introduction","anchor":"introduction"},{"id":"Erlang/OTP VEX Statements","anchor":"erlang-otp-vex-statements"},{"id":"Third Party VEX Statements","anchor":"third-party-vex-statements"},{"id":"Windows Binaries","anchor":"windows-binaries"}]}],"tasks":[]}