// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --version 5
// RUN: %clang_cc1 -triple amdgcn-- -target-cpu gfx1100 %s -emit-llvm -o - | FileCheck %s

#pragma OPENCL EXTENSION cl_khr_fp16 : enable

typedef int int4 __attribute__((ext_vector_type(4)));
typedef float float4 __attribute__((ext_vector_type(4)));
typedef _Float16 float16_4 __attribute__((ext_vector_type(4)));
typedef half half4 __attribute__((ext_vector_type(4)));

// CHECK-LABEL: define dso_local noundef <4 x half> @test_assign_half4_to_float16_4(
// CHECK-SAME: <4 x half> noundef returned [[F16_4:%.*]]) local_unnamed_addr #[[ATTR0:[0-9]+]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    ret <4 x half> [[F16_4]]
//
half4 test_assign_half4_to_float16_4(float16_4 f16_4) {
  return f16_4;
}

// CHECK-LABEL: define dso_local noundef <4 x half> @test_assign_float16_4_to_half4(
// CHECK-SAME: <4 x half> noundef returned [[H4:%.*]]) local_unnamed_addr #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    ret <4 x half> [[H4]]
//
float16_4 test_assign_float16_4_to_half4(half4 h4) {
  return h4;
}

// CHECK-LABEL: define dso_local noundef <4 x half> @test_float16_4_to_half4(
// CHECK-SAME: <4 x half> noundef returned [[F16_4:%.*]]) local_unnamed_addr #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    ret <4 x half> [[F16_4]]
//
half4 test_float16_4_to_half4(float16_4 f16_4) {
  return (half4)f16_4;
}
