//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfurlenumerator?language=objc)
#[repr(C)]
pub struct CFURLEnumerator {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl CFURLEnumerator {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"__CFURLEnumerator"> for CFURLEnumerator {}
);

unsafe impl ConcreteType for CFURLEnumerator {
    #[doc(alias = "CFURLEnumeratorGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CFURLEnumeratorGetTypeID() -> CFTypeID;
        }
        unsafe { CFURLEnumeratorGetTypeID() }
    }
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfurlenumeratoroptions?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CFURLEnumeratorOptions(pub CFOptionFlags);
bitflags::bitflags! {
    impl CFURLEnumeratorOptions: CFOptionFlags {
        #[doc(alias = "kCFURLEnumeratorDefaultBehavior")]
        const DefaultBehavior = 0;
        #[doc(alias = "kCFURLEnumeratorDescendRecursively")]
        const DescendRecursively = 1<<0;
        #[doc(alias = "kCFURLEnumeratorSkipInvisibles")]
        const SkipInvisibles = 1<<1;
        #[doc(alias = "kCFURLEnumeratorGenerateFileReferenceURLs")]
        const GenerateFileReferenceURLs = 1<<2;
        #[doc(alias = "kCFURLEnumeratorSkipPackageContents")]
        const SkipPackageContents = 1<<3;
        #[doc(alias = "kCFURLEnumeratorIncludeDirectoriesPreOrder")]
        const IncludeDirectoriesPreOrder = 1<<4;
        #[doc(alias = "kCFURLEnumeratorIncludeDirectoriesPostOrder")]
        const IncludeDirectoriesPostOrder = 1<<5;
        #[doc(alias = "kCFURLEnumeratorGenerateRelativePathURLs")]
        const GenerateRelativePathURLs = 1<<6;
    }
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CFURLEnumeratorOptions {
    const ENCODING: Encoding = CFOptionFlags::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CFURLEnumeratorOptions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

impl CFURLEnumerator {
    #[doc(alias = "CFURLEnumeratorCreateForDirectoryURL")]
    #[cfg(all(feature = "CFArray", feature = "CFURL"))]
    #[inline]
    pub unsafe fn new_for_directory_url(
        alloc: Option<&CFAllocator>,
        directory_url: Option<&CFURL>,
        option: CFURLEnumeratorOptions,
        property_keys: Option<&CFArray>,
    ) -> Option<CFRetained<CFURLEnumerator>> {
        extern "C-unwind" {
            fn CFURLEnumeratorCreateForDirectoryURL(
                alloc: Option<&CFAllocator>,
                directory_url: Option<&CFURL>,
                option: CFURLEnumeratorOptions,
                property_keys: Option<&CFArray>,
            ) -> Option<NonNull<CFURLEnumerator>>;
        }
        let ret = unsafe {
            CFURLEnumeratorCreateForDirectoryURL(alloc, directory_url, option, property_keys)
        };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFURLEnumeratorCreateForMountedVolumes")]
    #[cfg(feature = "CFArray")]
    #[inline]
    pub unsafe fn new_for_mounted_volumes(
        alloc: Option<&CFAllocator>,
        option: CFURLEnumeratorOptions,
        property_keys: Option<&CFArray>,
    ) -> Option<CFRetained<CFURLEnumerator>> {
        extern "C-unwind" {
            fn CFURLEnumeratorCreateForMountedVolumes(
                alloc: Option<&CFAllocator>,
                option: CFURLEnumeratorOptions,
                property_keys: Option<&CFArray>,
            ) -> Option<NonNull<CFURLEnumerator>>;
        }
        let ret = unsafe { CFURLEnumeratorCreateForMountedVolumes(alloc, option, property_keys) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfurlenumeratorresult?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CFURLEnumeratorResult(pub CFIndex);
impl CFURLEnumeratorResult {
    #[doc(alias = "kCFURLEnumeratorSuccess")]
    pub const Success: Self = Self(1);
    #[doc(alias = "kCFURLEnumeratorEnd")]
    pub const End: Self = Self(2);
    #[doc(alias = "kCFURLEnumeratorError")]
    pub const Error: Self = Self(3);
    #[doc(alias = "kCFURLEnumeratorDirectoryPostOrderSuccess")]
    pub const DirectoryPostOrderSuccess: Self = Self(4);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CFURLEnumeratorResult {
    const ENCODING: Encoding = CFIndex::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CFURLEnumeratorResult {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

impl CFURLEnumerator {
    #[doc(alias = "CFURLEnumeratorGetNextURL")]
    #[cfg(all(feature = "CFError", feature = "CFURL"))]
    #[inline]
    pub unsafe fn next_url(
        self: &CFURLEnumerator,
        url: *mut *const CFURL,
        error: *mut *mut CFError,
    ) -> CFURLEnumeratorResult {
        extern "C-unwind" {
            fn CFURLEnumeratorGetNextURL(
                enumerator: &CFURLEnumerator,
                url: *mut *const CFURL,
                error: *mut *mut CFError,
            ) -> CFURLEnumeratorResult;
        }
        unsafe { CFURLEnumeratorGetNextURL(self, url, error) }
    }

    #[doc(alias = "CFURLEnumeratorSkipDescendents")]
    #[inline]
    pub unsafe fn skip_descendents(self: &CFURLEnumerator) {
        extern "C-unwind" {
            fn CFURLEnumeratorSkipDescendents(enumerator: &CFURLEnumerator);
        }
        unsafe { CFURLEnumeratorSkipDescendents(self) }
    }

    #[doc(alias = "CFURLEnumeratorGetDescendentLevel")]
    #[inline]
    pub unsafe fn descendent_level(self: &CFURLEnumerator) -> CFIndex {
        extern "C-unwind" {
            fn CFURLEnumeratorGetDescendentLevel(enumerator: &CFURLEnumerator) -> CFIndex;
        }
        unsafe { CFURLEnumeratorGetDescendentLevel(self) }
    }

    #[doc(alias = "CFURLEnumeratorGetSourceDidChange")]
    #[deprecated = "Use File System Events API instead"]
    #[inline]
    pub unsafe fn source_did_change(self: &CFURLEnumerator) -> bool {
        extern "C-unwind" {
            fn CFURLEnumeratorGetSourceDidChange(enumerator: &CFURLEnumerator) -> Boolean;
        }
        let ret = unsafe { CFURLEnumeratorGetSourceDidChange(self) };
        ret != 0
    }
}

#[cfg(all(feature = "CFArray", feature = "CFURL"))]
#[deprecated = "renamed to `CFURLEnumerator::new_for_directory_url`"]
#[inline]
pub unsafe extern "C-unwind" fn CFURLEnumeratorCreateForDirectoryURL(
    alloc: Option<&CFAllocator>,
    directory_url: Option<&CFURL>,
    option: CFURLEnumeratorOptions,
    property_keys: Option<&CFArray>,
) -> Option<CFRetained<CFURLEnumerator>> {
    extern "C-unwind" {
        fn CFURLEnumeratorCreateForDirectoryURL(
            alloc: Option<&CFAllocator>,
            directory_url: Option<&CFURL>,
            option: CFURLEnumeratorOptions,
            property_keys: Option<&CFArray>,
        ) -> Option<NonNull<CFURLEnumerator>>;
    }
    let ret = unsafe {
        CFURLEnumeratorCreateForDirectoryURL(alloc, directory_url, option, property_keys)
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFArray")]
#[deprecated = "renamed to `CFURLEnumerator::new_for_mounted_volumes`"]
#[inline]
pub unsafe extern "C-unwind" fn CFURLEnumeratorCreateForMountedVolumes(
    alloc: Option<&CFAllocator>,
    option: CFURLEnumeratorOptions,
    property_keys: Option<&CFArray>,
) -> Option<CFRetained<CFURLEnumerator>> {
    extern "C-unwind" {
        fn CFURLEnumeratorCreateForMountedVolumes(
            alloc: Option<&CFAllocator>,
            option: CFURLEnumeratorOptions,
            property_keys: Option<&CFArray>,
        ) -> Option<NonNull<CFURLEnumerator>>;
    }
    let ret = unsafe { CFURLEnumeratorCreateForMountedVolumes(alloc, option, property_keys) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

extern "C-unwind" {
    #[cfg(all(feature = "CFError", feature = "CFURL"))]
    #[deprecated = "renamed to `CFURLEnumerator::next_url`"]
    pub fn CFURLEnumeratorGetNextURL(
        enumerator: &CFURLEnumerator,
        url: *mut *const CFURL,
        error: *mut *mut CFError,
    ) -> CFURLEnumeratorResult;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFURLEnumerator::skip_descendents`"]
    pub fn CFURLEnumeratorSkipDescendents(enumerator: &CFURLEnumerator);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFURLEnumerator::descendent_level`"]
    pub fn CFURLEnumeratorGetDescendentLevel(enumerator: &CFURLEnumerator) -> CFIndex;
}

#[deprecated = "renamed to `CFURLEnumerator::source_did_change`"]
#[inline]
pub unsafe extern "C-unwind" fn CFURLEnumeratorGetSourceDidChange(
    enumerator: &CFURLEnumerator,
) -> bool {
    extern "C-unwind" {
        fn CFURLEnumeratorGetSourceDidChange(enumerator: &CFURLEnumerator) -> Boolean;
    }
    let ret = unsafe { CFURLEnumeratorGetSourceDidChange(enumerator) };
    ret != 0
}
