/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.serializer.analysis;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.util.EmfFormatter;

public class GrammarElementDeclarationOrder
extends AdapterImpl
implements Comparator<EObject> {
    protected Map<EObject, Integer> elementIDCache = Maps.newHashMap();

    public static GrammarElementDeclarationOrder get(Grammar grammar) {
        for (Adapter a : grammar.eAdapters()) {
            if (!(a instanceof GrammarElementDeclarationOrder)) continue;
            return (GrammarElementDeclarationOrder)a;
        }
        GrammarElementDeclarationOrder result = new GrammarElementDeclarationOrder(grammar);
        grammar.eAdapters().add((Object)result);
        for (Grammar g : GrammarUtil.allUsedGrammars(grammar)) {
            EList adapters = g.eAdapters();
            Iterator it = adapters.iterator();
            while (it.hasNext()) {
                if (!(it.next() instanceof GrammarElementDeclarationOrder)) continue;
                it.remove();
            }
            adapters.add((Object)result);
        }
        return result;
    }

    protected GrammarElementDeclarationOrder(Grammar grammar) {
        ArrayList grammars = Lists.newArrayList((Object[])new Grammar[]{grammar});
        grammars.addAll(GrammarUtil.allUsedGrammars(grammar));
        int counter = 0;
        for (Grammar g : grammars) {
            this.elementIDCache.put(g, counter++);
            for (AbstractRule rule : g.getRules()) {
                this.elementIDCache.put(rule, counter++);
                TreeIterator iterator = rule.eAllContents();
                while (iterator.hasNext()) {
                    this.elementIDCache.put((EObject)iterator.next(), counter++);
                }
            }
        }
    }

    @Override
    public int compare(EObject o1, EObject o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return 1;
        }
        if (o2 == null) {
            return -1;
        }
        Integer i1 = this.elementIDCache.get(o1);
        Integer i2 = this.elementIDCache.get(o2);
        return i1.compareTo(i2);
    }

    public int getElementID(EObject ele) {
        Integer result = this.elementIDCache.get(ele);
        if (result == null) {
            Grammar grammar = GrammarUtil.getGrammar(ele);
            if (!this.elementIDCache.containsKey(grammar)) {
                String grammarName = grammar.getName() + "#" + System.identityHashCode(grammar);
                ArrayList indexed = Lists.newArrayList();
                for (EObject o : this.elementIDCache.keySet()) {
                    if (!(o instanceof Grammar)) continue;
                    indexed.add(((Grammar)o).getName() + "#" + System.identityHashCode(o));
                }
                throw new IllegalStateException("No ID found. Wrong grammar. \nRequested: " + grammarName + "\nAvailable: " + Joiner.on((String)", ").join((Iterable)indexed));
            }
            throw new IllegalStateException("No ID found. Not indexed. \nElement: " + EmfFormatter.objPath((EObject)ele));
        }
        return result;
    }

    public <T> Comparator<T> toComparator(final Function<T, EObject> elementAccess) {
        return new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return GrammarElementDeclarationOrder.this.compare((EObject)elementAccess.apply(o1), (EObject)elementAccess.apply(o2));
            }
        };
    }
}

