//  Copyright (c) 2005-2022 Hartmut Kaiser
//
//  SPDX-License-Identifier: BSL-1.0
//  Distributed under the Boost Software License, Version 1.0. (See accompanying
//  file LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#pragma once

#include <hpx/config.hpp>
#include <hpx/plugin/config/defines.hpp>
#include <hpx/preprocessor/stringize.hpp>

////////////////////////////////////////////////////////////////////////////////
// Older implementations of std::shared_ptr do not support binding function
// pointers (see http//wg21.link/lwg3018)
#if defined(HPX_HAVE_CXX11_STD_SHARED_PTR_LWG3018)

#include <memory>

namespace hpx::util::plugin {

    template <typename T>
    using shared_ptr = std::shared_ptr<T>;
}    // namespace hpx::util::plugin

#else

// hpxinspect:nodeprecatedinclude:boost/shared_ptr.hpp
// hpxinspect:nodeprecatedname:boost::shared_ptr

#include <boost/shared_ptr.hpp>

namespace hpx::util::plugin {

    template <typename T>
    using shared_ptr = boost::shared_ptr<T>;
}    // namespace hpx::util::plugin

#endif

///////////////////////////////////////////////////////////////////////////////
#if !defined(HPX_PLUGIN_NO_EXPORT_API)

#define HPX_PLUGIN_EXPORT_API HPX_SYMBOL_EXPORT

#if defined(HPX_WINDOWS)

#define HPX_PLUGIN_API __cdecl

#else    // HPX_WINDOWS

#if defined(__GNUC__) && defined(__i386)
#define HPX_PLUGIN_API __attribute__((cdecl))
#endif

#endif    // HPX_WINDOWS

#endif    // !HPX_PLUGIN_NO_EXPORT_API

#if !defined(HPX_PLUGIN_EXPORT_API)
#define HPX_PLUGIN_EXPORT_API /* empty */
#endif
#if !defined(HPX_PLUGIN_API)
#define HPX_PLUGIN_API /* empty */
#endif

///////////////////////////////////////////////////////////////////////////////
//
//  The HPX_PLUGIN_ARGUMENT_LIMIT defines the upper limit of possible arguments
//  to the virtual constructors.
//
///////////////////////////////////////////////////////////////////////////////
#if !defined(HPX_PLUGIN_ARGUMENT_LIMIT)
#define HPX_PLUGIN_ARGUMENT_LIMIT 10
#endif

///////////////////////////////////////////////////////////////////////////////
//
//  The HPX_PLUGIN_SYMBOLS_PREFIX defines the prefix to use for all exported
//  names generated by this library.
//
///////////////////////////////////////////////////////////////////////////////
#if !defined(HPX_PLUGIN_SYMBOLS_PREFIX)
#if defined(HPX_DEBUG)
#define HPX_PLUGIN_SYMBOLS_PREFIX_DYNAMIC hpxd
#define HPX_PLUGIN_SYMBOLS_PREFIX hpxd
#else
#define HPX_PLUGIN_SYMBOLS_PREFIX_DYNAMIC hpx
#define HPX_PLUGIN_SYMBOLS_PREFIX hpx
#endif
#endif

#define HPX_PLUGIN_SYMBOLS_PREFIX_DYNAMIC_STR                                  \
    HPX_PP_STRINGIZE(HPX_PLUGIN_SYMBOLS_PREFIX_DYNAMIC)                        \
    /**/

#define HPX_PLUGIN_SYMBOLS_PREFIX_STR                                          \
    HPX_PP_STRINGIZE(HPX_PLUGIN_SYMBOLS_PREFIX)                                \
    /**/
