import { ChannelParameter, ServerVariable, Schema } from '@asyncapi/parser';
export declare enum SchemaCustomTypes {
    ANY = "any",
    RESTRICTED_ANY = "restricted any",
    NEVER = "never",
    UNKNOWN = "unknown"
}
export declare class SchemaHelpers {
    static extRenderType: string;
    static extRenderAdditionalInfo: string;
    static extRawValue: string;
    static extParameterLocation: string;
    static toSchemaType(schema: Schema): string;
    static prettifyValue(value: any, strict?: boolean): string;
    static humanizeConstraints(schema: Schema): string[];
    static isExpandable(schema: Schema): boolean;
    static serverVariablesToSchema(urlVariables?: Record<string, ServerVariable>): Schema | undefined;
    static parametersToSchema(parameters?: Record<string, ChannelParameter>): Schema | undefined;
    static jsonToSchema(value: any): any;
    static getCustomExtensions(value: any): {} | undefined;
    static getDependentRequired(propertyName: string, schema: Schema): string[] | undefined;
    static getDependentSchemas(schema: Schema): Schema | undefined;
    private static toType;
    private static toItemsType;
    private static toCombinedType;
    private static inferType;
    private static humanizeNumberRangeConstraint;
    private static humanizeMultipleOfConstraint;
    private static humanizeRangeConstraint;
    private static jsonFieldToSchema;
    private static isJSONSchema;
}
//# sourceMappingURL=schema.d.ts.map