import React from 'react';
import { Href, Markdown, Tags } from '../../components';
import { useSpec } from '../../contexts';
import { TERMS_OF_SERVICE_TEXT, CONTENT_TYPES_SITE, URL_SUPPORT_TEXT, EXTERAL_DOCUMENTATION_TEXT, } from '../../constants';
export var Info = function () {
    var asyncapi = useSpec();
    var info = asyncapi.info();
    if (!info) {
        return null;
    }
    var specId = asyncapi.id();
    var externalDocs = asyncapi.externalDocs();
    var license = info.license();
    var termsOfService = info.termsOfService();
    var defaultContentType = asyncapi.defaultContentType();
    var contact = info.contact();
    var showInfoList = license || termsOfService || defaultContentType || contact || externalDocs;
    return (React.createElement("div", { className: "panel-item" },
        React.createElement("div", { className: "panel-item--center px-8 text-left", id: "introduction" },
            React.createElement("div", { className: "text-4xl" },
                info.title(),
                "\u00A0",
                info.version()),
            showInfoList && (React.createElement("ul", { className: "flex flex-wrap mt-2 leading-normal" },
                license && (React.createElement("li", { className: "inline-block mt-2 mr-2" }, license.url() ? (React.createElement(Href, { className: "border border-solid border-orange-300 hover:bg-orange-300 hover:text-orange-600 text-orange-500 font-bold no-underline text-xs uppercase rounded px-3 py-1", href: license.url() },
                    React.createElement("span", null, license.name()))) : (React.createElement("span", { className: "border border-solid border-orange-300 hover:bg-orange-300 hover:text-orange-600 text-orange-500 font-bold no-underline text-xs uppercase rounded px-3 py-1" }, license.name())))),
                termsOfService && (React.createElement("li", { className: "inline-block mt-2 mr-2" },
                    React.createElement(Href, { className: "border border-solid border-orange-300 hover:bg-orange-300 hover:text-orange-600 text-orange-500 font-bold no-underline text-xs uppercase rounded px-3 py-1", href: termsOfService },
                        React.createElement("span", null, TERMS_OF_SERVICE_TEXT)))),
                defaultContentType && (React.createElement("li", { className: "inline-block mt-2 mr-2" },
                    React.createElement(Href, { className: "border border-solid border-orange-300 hover:bg-orange-300 hover:text-orange-600 text-orange-500 font-bold no-underline text-xs uppercase rounded px-3 py-1", href: "".concat(CONTENT_TYPES_SITE, "/").concat(defaultContentType) },
                        React.createElement("span", null, defaultContentType)))),
                externalDocs && (React.createElement("li", { className: "inline-block mt-2 mr-2" },
                    React.createElement(Href, { className: "border border-solid border-orange-300 hover:bg-orange-300 hover:text-orange-600 text-orange-500 font-bold no-underline text-xs uppercase rounded px-3 py-1", href: externalDocs.url() },
                        React.createElement("span", null, EXTERAL_DOCUMENTATION_TEXT)))),
                contact && (React.createElement(React.Fragment, null,
                    contact.url() && (React.createElement("li", { className: "inline-block mt-2 mr-2" },
                        React.createElement(Href, { className: "border border-solid border-purple-300 hover:bg-purple-300 hover:text-purple-600 text-purple-500 font-bold no-underline text-xs uppercase rounded px-3 py-1", href: contact.url() },
                            React.createElement("span", null, contact.name() || URL_SUPPORT_TEXT)))),
                    contact.email() && (React.createElement("li", { className: "inline-block mt-2 mr-2" },
                        React.createElement(Href, { className: "border border-solid border-purple-300 hover:bg-purple-300 hover:text-purple-600 text-purple-500 font-bold no-underline text-xs uppercase rounded px-3 py-1", href: "mailto:".concat(contact.email()) },
                            React.createElement("span", null, contact.email())))))),
                specId && (React.createElement("li", { className: "inline-block mt-2 mr-2" },
                    React.createElement("span", { className: "border border-solid border-blue-300 hover:bg-blue-300 hover:text-blue-600 text-blue-500 font-bold no-underline text-xs uppercase rounded px-3 py-1" },
                        "ID: ",
                        specId))))),
            info.hasDescription() && (React.createElement("div", { className: "mt-4" },
                React.createElement(Markdown, null, info.description()))),
            asyncapi.hasTags() && (React.createElement("div", { className: "mt-4" },
                React.createElement(Tags, { tags: asyncapi.tags() })))),
        React.createElement("div", { className: "panel-item--right" })));
};
//# sourceMappingURL=Info.js.map