"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Error = void 0;
var react_1 = __importDefault(require("react"));
var constants_1 = require("../../constants");
var renderErrors = function (errors) {
    if (!errors) {
        return null;
    }
    return errors
        .map(function (singleError, index) {
        if (!singleError || !singleError.title || !singleError.location) {
            return null;
        }
        return (react_1.default.createElement("div", { key: index, className: "flex" },
            react_1.default.createElement("span", null, "".concat(singleError.location.startLine, ".")),
            react_1.default.createElement("code", { className: "whitespace-pre-wrap break-all ml-2" }, singleError.title)));
    })
        .filter(Boolean);
};
var Error = function (_a) {
    var error = _a.error;
    if (!error) {
        return null;
    }
    var title = error.title, validationErrors = error.validationErrors;
    return (react_1.default.createElement("div", { className: "panel-item" },
        react_1.default.createElement("div", { className: "panel-item--center p-8" },
            react_1.default.createElement("section", { className: "shadow rounded bg-gray-200 border-red-500 border-l-8" },
                react_1.default.createElement("h2", { className: "p-2" }, title ? "".concat(constants_1.ERROR_TEXT, ": ").concat(title) : constants_1.ERROR_TEXT),
                validationErrors && validationErrors.length ? (react_1.default.createElement("div", { className: "bg-gray-800 text-white text-xs p-2" },
                    react_1.default.createElement("pre", null, renderErrors(validationErrors)))) : null)),
        react_1.default.createElement("div", { className: "panel-item--right" })));
};
exports.Error = Error;
//# sourceMappingURL=Error.js.map