/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.helpers.MysqlBaseJdbcHelper;
import java.sql.Connection;
import java.sql.Driver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MysqlJdbcHelper
extends MysqlBaseJdbcHelper {
    public MysqlJdbcHelper(@NotNull String dbmsName, @Nullable String version, @Nullable Connection connection) {
        if (dbmsName == null) {
            MysqlJdbcHelper.$$$reportNull$$$0(0);
        }
        super(dbmsName, version, connection);
    }

    @Override
    public boolean detect(@NotNull Driver driver, @Nullable String url) {
        if (driver == null) {
            MysqlJdbcHelper.$$$reportNull$$$0(1);
        }
        return MysqlJdbcHelper.classNameContains(driver, "mysql");
    }

    @Override
    public JdbcHelperImpl create(@Nullable String version, @Nullable Connection connection) {
        return new MysqlJdbcHelper(this.getDbmsName(), version, connection);
    }

    public MysqlJdbcHelper(@Nullable String version, @Nullable Connection connection) {
        this("MYSQL", version, connection);
    }

    public MysqlJdbcHelper() {
        this(null, null);
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return MysqlJdbcHelper.extractVersion(version);
    }

    @NotNull
    static MysqlJdbcHelper create(@Nullable Connection delegate, @Nullable String versionStr) {
        String version = MysqlJdbcHelper.extractVersion(versionStr);
        return new MysqlJdbcHelper(version, delegate);
    }

    @Nullable
    public static String extractVersion(@Nullable String str) {
        return JdbcNativeUtil.findVersion(str, JdbcNativeUtil.DEFAULT_VERSION_PATTERN);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbmsName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/MysqlJdbcHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "detect";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

