/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.view.registry;

import com.intellij.docker.agent.registry.model.DockerGitlabRegistryKt;
import com.intellij.docker.agent.registry.model.DockerRegistry;
import com.intellij.docker.agent.util.HttpRequestExecutor;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.registry.DockerRegistryConfiguration;
import com.intellij.docker.utils.InternalUtilsKt;
import com.intellij.docker.view.registry.DockerRegistryProvider;
import com.intellij.docker.view.registry.node.DockerRegistryRoot;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/intellij/docker/view/registry/DockerGitlabRegistryProvider;", "Lcom/intellij/docker/view/registry/DockerRegistryProvider;", "<init>", "()V", "registryName", "", "getRegistryName", "()Ljava/lang/String;", "id", "getId", "createConfigurator", "Lcom/intellij/docker/view/registry/DockerRegistryProvider$Configurator;", "doGetRegistryRoot", "Lcom/intellij/docker/view/registry/node/DockerRegistryRoot;", "registry", "Lcom/intellij/docker/registry/DockerRegistryConfiguration;", "intellij.clouds.docker"})
@ApiStatus.Internal
public final class DockerGitlabRegistryProvider
extends DockerRegistryProvider {
    @NotNull
    private final String registryName;
    @NotNull
    private final String id;

    public DockerGitlabRegistryProvider() {
        this.registryName = "GitLab";
        this.id = "DockerGitlabRegistryProvider";
    }

    @Override
    @NotNull
    public String getRegistryName() {
        return this.registryName;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public DockerRegistryProvider.Configurator createConfigurator() {
        String string = DockerBundle.message("DockerRegistryConfigurable.token.text", new Object[0]);
        return new DockerRegistryProvider.Configurator.Default(string){
            {
                Intrinsics.checkNotNull((Object)$super_call_param$1);
                super(false, false, $super_call_param$1, "gitlab.com", 1, null);
            }

            public void validate$intellij_clouds_docker(DockerRegistryConfiguration registry) {
                Intrinsics.checkNotNullParameter((Object)((Object)registry), (String)"registry");
                DockerRegistryProvider.Configurator.Default.defaultPasswordValidation(registry.getPasswordSafe());
            }
        };
    }

    @Override
    @NotNull
    protected DockerRegistryRoot doGetRegistryRoot(@NotNull DockerRegistryConfiguration registry) {
        Intrinsics.checkNotNullParameter((Object)((Object)registry), (String)"registry");
        return new DockerRegistryRoot(registry, (Function1<? super HttpRequestExecutor, ? extends DockerRegistry>)((Function1)arg_0 -> DockerGitlabRegistryProvider.doGetRegistryRoot$lambda$0(registry, arg_0)));
    }

    private static final DockerRegistry doGetRegistryRoot$lambda$0(DockerRegistryConfiguration $registry, HttpRequestExecutor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = $registry.getAddress();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAddress(...)");
        return DockerGitlabRegistryKt.gitlabRegistry$default(string, it, InternalUtilsKt.userdata($registry), 0, 8, null);
    }
}

