/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.composeFile.model;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.docker.composeFile.i18n.DockerComposeBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLElementGenerator;
import org.jetbrains.yaml.meta.model.YamlStringType;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLQuotedText;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.impl.YAMLQuotedTextImpl;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\u000b"}, d2={"Lcom/intellij/docker/composeFile/model/ComposeStrictStringType;", "Lorg/jetbrains/yaml/meta/model/YamlStringType;", "<init>", "()V", "validateScalarValue", "", "scalarValue", "Lorg/jetbrains/yaml/psi/YAMLScalar;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "QuickFix", "intellij.clouds.docker.compose"})
public final class ComposeStrictStringType
extends YamlStringType {
    protected void validateScalarValue(@NotNull YAMLScalar scalarValue, @NotNull ProblemsHolder holder) {
        Intrinsics.checkNotNullParameter((Object)scalarValue, (String)"scalarValue");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (!(scalarValue instanceof YAMLQuotedText)) {
            String string = DockerComposeBundle.message("ComposeStrictStringType.validation.error", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String message = string;
            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new QuickFix((PsiElement)scalarValue)};
            holder.registerProblem((PsiElement)scalarValue, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, localQuickFixArray);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J)\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0096\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/docker/composeFile/model/ComposeStrictStringType$QuickFix;", "Lcom/intellij/codeInspection/LocalQuickFixOnPsiElement;", "element", "Lcom/intellij/psi/PsiElement;", "<init>", "(Lcom/intellij/psi/PsiElement;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "startElement", "endElement", "intellij.clouds.docker.compose"})
    private static final class QuickFix
    extends LocalQuickFixOnPsiElement {
        public QuickFix(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            super(element);
        }

        @NotNull
        public String getFamilyName() {
            String string = DockerComposeBundle.message("ComposeStrictStringType.quick.fix", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @NotNull
        public String getText() {
            return this.getFamilyName();
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
            Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
            YAMLElementGenerator generator = YAMLElementGenerator.getInstance((Project)project);
            YAMLFile yAMLFile = generator.createDummyYamlWithText("\"" + startElement.getText() + "\"");
            Intrinsics.checkNotNullExpressionValue((Object)yAMLFile, (String)"createDummyYamlWithText(...)");
            YAMLFile dummyElement = yAMLFile;
            Class[] classArray = new Class[]{YAMLQuotedTextImpl.class};
            Collection collection = PsiTreeUtil.collectElementsOfType((PsiElement)((PsiElement)dummyElement), (Class[])classArray);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"collectElementsOfType(...)");
            YAMLQuotedTextImpl yAMLQuotedTextImpl = (YAMLQuotedTextImpl)CollectionsKt.firstOrNull((Iterable)collection);
            if (yAMLQuotedTextImpl == null) {
                return;
            }
            YAMLQuotedTextImpl element = yAMLQuotedTextImpl;
            startElement.replace((PsiElement)element);
        }
    }
}

