/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.compose;

import com.intellij.codeWithMe.ClientId;
import com.intellij.docker.agent.compose.beans.v2.DockerComposeConfigurationV2;
import com.intellij.docker.agent.compose.cli.DockerComposeRunCliBuilder;
import com.intellij.docker.agent.util.DockerComposeUtilsKt;
import com.intellij.docker.compose.cli.DockerComposeCliUtil;
import com.intellij.docker.compose.service.commands.ServiceCmdExecUtils;
import com.intellij.docker.compose.service.commands.SharedVolume;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.remoteRunRuntime.RemoteDockerRuntime;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessRunner;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.ui.EDT;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\b\u0001\u0018\u0000 \u00182\u00020\u0001:\u0002\u0018\u0019B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JR\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0016\b\u0002\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u0016H\u0007JF\u0010\u0017\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0014\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u0016H\u0002R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/docker/compose/DockerComposeIntegrationService;", "", "<init>", "()V", "lock", "processed", "", "Lcom/intellij/docker/compose/DockerComposeIntegrationService$SharedVolumeKey;", "Ljava/util/concurrent/CountDownLatch;", "prePopulateSharedVolume", "", "dockerRuntime", "Lcom/intellij/docker/remoteRunRuntime/RemoteDockerRuntime;", "projectName", "", "configurationPaths", "", "Ljava/nio/file/Path;", "configurationVersion", "volume", "Lcom/intellij/docker/compose/service/commands/SharedVolume;", "envs", "", "doPrePopulateSharedVolume", "Companion", "SharedVolumeKey", "intellij.clouds.docker"})
@SourceDebugExtension(value={"SMAP\nDockerComposeIntegrationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerComposeIntegrationService.kt\ncom/intellij/docker/compose/DockerComposeIntegrationService\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,135:1\n15#2:136\n*S KotlinDebug\n*F\n+ 1 DockerComposeIntegrationService.kt\ncom/intellij/docker/compose/DockerComposeIntegrationService\n*L\n23#1:136\n*E\n"})
public final class DockerComposeIntegrationService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Object lock = new Object();
    @NotNull
    private final Map<SharedVolumeKey, CountDownLatch> processed = new HashMap();
    @NotNull
    private static final Logger LOG;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    public final void prePopulateSharedVolume(@NotNull RemoteDockerRuntime dockerRuntime, @Nullable String projectName, @NotNull List<? extends Path> configurationPaths, @Nullable String configurationVersion, @NotNull SharedVolume volume2, @Nullable Map<String, String> envs) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)dockerRuntime, (String)"dockerRuntime");
        Intrinsics.checkNotNullParameter(configurationPaths, (String)"configurationPaths");
        Intrinsics.checkNotNullParameter((Object)volume2, (String)"volume");
        DockerComposeConfigurationV2 dockerComposeConfigurationV2 = ServiceCmdExecUtils.setupSharedService(configurationVersion, volume2);
        Intrinsics.checkNotNullExpressionValue((Object)dockerComposeConfigurationV2, (String)"setupSharedService(...)");
        DockerComposeConfigurationV2 helpersConfiguration = dockerComposeConfigurationV2;
        File file = ServiceCmdExecUtils.writeDockerComposeOverrideYml(helpersConfiguration);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"writeDockerComposeOverrideYml(...)");
        File helpersConfigurationFile = file;
        String composeProjectName = DockerComposeUtilsKt.getEffectiveDockerComposeProjectName(projectName, configurationPaths, envs);
        Object object = this.lock;
        synchronized (object) {
            Pair pair2;
            boolean bl = false;
            SharedVolumeKey key = new SharedVolumeKey(dockerRuntime.getAccount().getApiUrl(), composeProjectName, volume2.getVolumeName());
            CountDownLatch latch = this.processed.get(key);
            if (latch == null) {
                CountDownLatch newLatch = new CountDownLatch(1);
                this.processed.put(key, newLatch);
                pair2 = TuplesKt.to((Object)newLatch, (Object)true);
            } else {
                pair2 = TuplesKt.to((Object)latch, (Object)false);
            }
            pair = pair2;
        }
        Pair pair3 = pair;
        CountDownLatch latch = (CountDownLatch)pair3.component1();
        boolean startPopulate = (Boolean)pair3.component2();
        if (startPopulate) {
            try {
                this.doPrePopulateSharedVolume(dockerRuntime, CollectionsKt.plus((Collection)configurationPaths, (Iterable)CollectionsKt.listOf((Object)helpersConfigurationFile.toPath())), volume2, projectName, envs);
            }
            finally {
                latch.countDown();
            }
        } else {
            latch.await();
        }
    }

    public static /* synthetic */ void prePopulateSharedVolume$default(DockerComposeIntegrationService dockerComposeIntegrationService, RemoteDockerRuntime remoteDockerRuntime, String string, List list2, String string2, SharedVolume sharedVolume, Map map2, int n, Object object) {
        if ((n & 0x20) != 0) {
            map2 = null;
        }
        dockerComposeIntegrationService.prePopulateSharedVolume(remoteDockerRuntime, string, list2, string2, sharedVolume, map2);
    }

    private final void doPrePopulateSharedVolume(RemoteDockerRuntime dockerRuntime, List<? extends Path> configurationPaths, SharedVolume volume2, String projectName, Map<String, String> envs) {
        LOG.info("Populate shared volume " + volume2.getVolumeName());
        DockerComposeRunCliBuilder commandLine = ((DockerComposeRunCliBuilder)((DockerComposeRunCliBuilder)((DockerComposeRunCliBuilder)DockerComposeCliUtil.buildRunCommand(dockerRuntime.getAccount()).withFiles(configurationPaths)).withRemove(true).withService(volume2.getServiceName()).withProjectName(projectName)).withEnvironment(envs)).withDetached(false);
        Object[] objectArray = new Object[]{volume2.getVolumeName()};
        String string = DockerBundle.message("DockerComposeIntegrationService.progress.title.updating.volume", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String progressText = string;
        if (EDT.isCurrentThreadEdt()) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> DockerComposeIntegrationService.doPrePopulateSharedVolume$lambda$1(commandLine, dockerRuntime), progressText, true, null);
        } else {
            ProcessOutput processOutput2 = new CapturingProcessRunner((BaseProcessHandler)DockerComposeCliUtil.run(commandLine, dockerRuntime, ProgressManager.getInstance().getProgressIndicator())).runProcess();
            Intrinsics.checkNotNull((Object)processOutput2);
        }
    }

    @JvmOverloads
    public final void prePopulateSharedVolume(@NotNull RemoteDockerRuntime dockerRuntime, @Nullable String projectName, @NotNull List<? extends Path> configurationPaths, @Nullable String configurationVersion, @NotNull SharedVolume volume2) {
        Intrinsics.checkNotNullParameter((Object)dockerRuntime, (String)"dockerRuntime");
        Intrinsics.checkNotNullParameter(configurationPaths, (String)"configurationPaths");
        Intrinsics.checkNotNullParameter((Object)volume2, (String)"volume");
        DockerComposeIntegrationService.prePopulateSharedVolume$default(this, dockerRuntime, projectName, configurationPaths, configurationVersion, volume2, null, 32, null);
    }

    private static final void doPrePopulateSharedVolume$lambda$1(DockerComposeRunCliBuilder $commandLine, RemoteDockerRuntime $dockerRuntime) {
        new CapturingProcessRunner((BaseProcessHandler)DockerComposeCliUtil.run($commandLine, $dockerRuntime, ProgressManager.getInstance().getProgressIndicator())).runProcess();
    }

    @JvmStatic
    @NotNull
    public static final DockerComposeIntegrationService getInstance() {
        return Companion.getInstance();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DockerComposeIntegrationService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/docker/compose/DockerComposeIntegrationService$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/intellij/docker/compose/DockerComposeIntegrationService;", "intellij.clouds.docker"})
    @SourceDebugExtension(value={"SMAP\nDockerComposeIntegrationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerComposeIntegrationService.kt\ncom/intellij/docker/compose/DockerComposeIntegrationService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,135:1\n40#2,3:136\n*S KotlinDebug\n*F\n+ 1 DockerComposeIntegrationService.kt\ncom/intellij/docker/compose/DockerComposeIntegrationService$Companion\n*L\n26#1:136,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final DockerComposeIntegrationService getInstance() {
            boolean $i$f$service = false;
            Class<DockerComposeIntegrationService> serviceClass$iv = DockerComposeIntegrationService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (DockerComposeIntegrationService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J)\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0016"}, d2={"Lcom/intellij/docker/compose/DockerComposeIntegrationService$SharedVolumeKey;", "", "account", "", "composeProjectName", "volumeName", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getAccount", "()Ljava/lang/String;", "getComposeProjectName", "getVolumeName", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.clouds.docker"})
    private static final class SharedVolumeKey {
        @NotNull
        private final String account;
        @Nullable
        private final String composeProjectName;
        @NotNull
        private final String volumeName;

        public SharedVolumeKey(@NotNull String account, @Nullable String composeProjectName, @NotNull String volumeName) {
            Intrinsics.checkNotNullParameter((Object)account, (String)"account");
            Intrinsics.checkNotNullParameter((Object)volumeName, (String)"volumeName");
            this.account = account;
            this.composeProjectName = composeProjectName;
            this.volumeName = volumeName;
        }

        @NotNull
        public final String getAccount() {
            return this.account;
        }

        @Nullable
        public final String getComposeProjectName() {
            return this.composeProjectName;
        }

        @NotNull
        public final String getVolumeName() {
            return this.volumeName;
        }

        @NotNull
        public final String component1() {
            return this.account;
        }

        @Nullable
        public final String component2() {
            return this.composeProjectName;
        }

        @NotNull
        public final String component3() {
            return this.volumeName;
        }

        @NotNull
        public final SharedVolumeKey copy(@NotNull String account, @Nullable String composeProjectName, @NotNull String volumeName) {
            Intrinsics.checkNotNullParameter((Object)account, (String)"account");
            Intrinsics.checkNotNullParameter((Object)volumeName, (String)"volumeName");
            return new SharedVolumeKey(account, composeProjectName, volumeName);
        }

        public static /* synthetic */ SharedVolumeKey copy$default(SharedVolumeKey sharedVolumeKey, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = sharedVolumeKey.account;
            }
            if ((n & 2) != 0) {
                string2 = sharedVolumeKey.composeProjectName;
            }
            if ((n & 4) != 0) {
                string3 = sharedVolumeKey.volumeName;
            }
            return sharedVolumeKey.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "SharedVolumeKey(account=" + this.account + ", composeProjectName=" + this.composeProjectName + ", volumeName=" + this.volumeName + ")";
        }

        public int hashCode() {
            int result2 = this.account.hashCode();
            result2 = result2 * 31 + (this.composeProjectName == null ? 0 : this.composeProjectName.hashCode());
            result2 = result2 * 31 + this.volumeName.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SharedVolumeKey)) {
                return false;
            }
            SharedVolumeKey sharedVolumeKey = (SharedVolumeKey)other;
            if (!Intrinsics.areEqual((Object)this.account, (Object)sharedVolumeKey.account)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.composeProjectName, (Object)sharedVolumeKey.composeProjectName)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.volumeName, (Object)sharedVolumeKey.volumeName);
        }
    }
}

