/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent;

import com.github.dockerjava.api.model.Container;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\f\b\u0086\u0081\u0002\u0018\u0000 \f2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\r"}, d2={"Lcom/intellij/docker/agent/DockerAgentContainerState;", "", "<init>", "(Ljava/lang/String;I)V", "CREATED", "RUNNING", "PAUSED", "EXITED", "HEALTH_CHECK_STARTING", "RUNNING_HEALTHY", "RUNNING_UNHEALTHY", "UNEXPECTED", "Companion", "intellij.clouds.docker.agent"})
public final class DockerAgentContainerState
extends Enum<DockerAgentContainerState> {
    @NotNull
    public static final Companion Companion;
    public static final /* enum */ DockerAgentContainerState CREATED;
    public static final /* enum */ DockerAgentContainerState RUNNING;
    public static final /* enum */ DockerAgentContainerState PAUSED;
    public static final /* enum */ DockerAgentContainerState EXITED;
    public static final /* enum */ DockerAgentContainerState HEALTH_CHECK_STARTING;
    public static final /* enum */ DockerAgentContainerState RUNNING_HEALTHY;
    public static final /* enum */ DockerAgentContainerState RUNNING_UNHEALTHY;
    public static final /* enum */ DockerAgentContainerState UNEXPECTED;
    private static final /* synthetic */ DockerAgentContainerState[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    public static DockerAgentContainerState[] values() {
        return (DockerAgentContainerState[])$VALUES.clone();
    }

    public static DockerAgentContainerState valueOf(String value) {
        return Enum.valueOf(DockerAgentContainerState.class, value);
    }

    @NotNull
    public static EnumEntries<DockerAgentContainerState> getEntries() {
        return $ENTRIES;
    }

    @JvmStatic
    @NotNull
    public static final DockerAgentContainerState forContainer(@NotNull Container container) {
        return Companion.forContainer(container);
    }

    @JvmStatic
    private static final DockerAgentContainerState stateFromStatus(Container container) {
        return DockerAgentContainerState.Companion.stateFromStatus(container);
    }

    static {
        CREATED = new DockerAgentContainerState();
        RUNNING = new DockerAgentContainerState();
        PAUSED = new DockerAgentContainerState();
        EXITED = new DockerAgentContainerState();
        HEALTH_CHECK_STARTING = new DockerAgentContainerState();
        RUNNING_HEALTHY = new DockerAgentContainerState();
        RUNNING_UNHEALTHY = new DockerAgentContainerState();
        UNEXPECTED = new DockerAgentContainerState();
        $VALUES = dockerAgentContainerStateArray = new DockerAgentContainerState[]{DockerAgentContainerState.CREATED, DockerAgentContainerState.RUNNING, DockerAgentContainerState.PAUSED, DockerAgentContainerState.EXITED, DockerAgentContainerState.HEALTH_CHECK_STARTING, DockerAgentContainerState.RUNNING_HEALTHY, DockerAgentContainerState.RUNNING_UNHEALTHY, DockerAgentContainerState.UNEXPECTED};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0003\u00a8\u0006\t"}, d2={"Lcom/intellij/docker/agent/DockerAgentContainerState$Companion;", "", "<init>", "()V", "forContainer", "Lcom/intellij/docker/agent/DockerAgentContainerState;", "container", "Lcom/github/dockerjava/api/model/Container;", "stateFromStatus", "intellij.clouds.docker.agent"})
    @SourceDebugExtension(value={"SMAP\nDockerAgentContainerState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerAgentContainerState.kt\ncom/intellij/docker/agent/DockerAgentContainerState$Companion\n+ 2 logging.kt\ncom/intellij/docker/agent/util/LoggingKt\n*L\n1#1,50:1\n8#2:51\n*S KotlinDebug\n*F\n+ 1 DockerAgentContainerState.kt\ncom/intellij/docker/agent/DockerAgentContainerState$Companion\n*L\n27#1:51\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @JvmStatic
        @NotNull
        public final DockerAgentContainerState forContainer(@NotNull Container container) {
            Intrinsics.checkNotNullParameter((Object)container, (String)"container");
            DockerAgentContainerState dockerAgentContainerState = this.stateFromStatus(container);
            DockerAgentContainerState dockerAgentContainerState2 = dockerAgentContainerState;
            if (dockerAgentContainerState != null) return dockerAgentContainerState2;
            String string = container.getState();
            if (string != null) {
                int n = -1;
                switch (string.hashCode()) {
                    case 1550783935: {
                        if (!string.equals("running")) break;
                        n = 1;
                        break;
                    }
                    case -995321554: {
                        if (!string.equals("paused")) break;
                        n = 2;
                        break;
                    }
                    case 1028554472: {
                        if (!string.equals("created")) break;
                        n = 3;
                        break;
                    }
                    case 795560349: {
                        if (!string.equals("healthy")) break;
                        n = 4;
                        break;
                    }
                    case -1787605788: {
                        if (!string.equals("unhealthy")) break;
                        n = 5;
                        break;
                    }
                    case -1289357763: {
                        if (!string.equals("exited")) break;
                        n = 6;
                        break;
                    }
                }
                switch (n) {
                    case 1: {
                        dockerAgentContainerState2 = RUNNING;
                        return dockerAgentContainerState2;
                    }
                    case 3: {
                        dockerAgentContainerState2 = CREATED;
                        return dockerAgentContainerState2;
                    }
                    case 2: {
                        dockerAgentContainerState2 = PAUSED;
                        return dockerAgentContainerState2;
                    }
                    case 6: {
                        dockerAgentContainerState2 = EXITED;
                        return dockerAgentContainerState2;
                    }
                    case 4: {
                        dockerAgentContainerState2 = RUNNING_HEALTHY;
                        return dockerAgentContainerState2;
                    }
                    case 5: {
                        dockerAgentContainerState2 = RUNNING_UNHEALTHY;
                        return dockerAgentContainerState2;
                    }
                }
            }
            boolean $i$f$logger = false;
            Logger logger = LoggerFactory.getLogger(DockerAgentContainerState.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
            logger.error("Can't compute state for " + container);
            dockerAgentContainerState2 = UNEXPECTED;
            return dockerAgentContainerState2;
        }

        @JvmStatic
        private final DockerAgentContainerState stateFromStatus(Container container) {
            String status2 = container.getStatus();
            return status2 == null ? RUNNING : (StringsKt.contains$default((CharSequence)status2, (CharSequence)"(health: starting)", (boolean)false, (int)2, null) ? HEALTH_CHECK_STARTING : (StringsKt.contains$default((CharSequence)status2, (CharSequence)"(healthy)", (boolean)false, (int)2, null) ? RUNNING_HEALTHY : (StringsKt.contains$default((CharSequence)status2, (CharSequence)"(unhealthy)", (boolean)false, (int)2, null) ? RUNNING_UNHEALTHY : (StringsKt.endsWith$default((String)status2, (String)"(Paused)", (boolean)false, (int)2, null) ? PAUSED : (StringsKt.startsWith$default((String)status2, (String)"Exited", (boolean)false, (int)2, null) ? EXITED : (StringsKt.startsWith$default((String)status2, (String)"Up", (boolean)false, (int)2, null) ? RUNNING : (StringsKt.startsWith$default((String)status2, (String)"Created", (boolean)false, (int)2, null) ? CREATED : null)))))));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

