/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.dap.connection;

import com.intellij.execution.TaskExecutor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.platform.dap.connection.DebugAdapterHandle;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BaseOutputReader;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0004\u0013\u0014\u0015\u0016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0010\u001a\u00020\u0011H\u0096@\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lcom/intellij/platform/dap/connection/CommandLineDebugAdapterHandle;", "Lcom/intellij/platform/dap/connection/DebugAdapterHandle;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "<init>", "(Lcom/intellij/execution/configurations/GeneralCommandLine;)V", "handler", "Lcom/intellij/platform/dap/connection/CommandLineDebugAdapterHandle$MyProcessHandler;", "input", "Ljava/io/InputStream;", "getInput", "()Ljava/io/InputStream;", "output", "Ljava/io/OutputStream;", "getOutput", "()Ljava/io/OutputStream;", "disconnect", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "MyProcessHandler", "NullReader", "MyProcessListener", "intellij.platform.dap"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nCommandLineDebugAdapterHandle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandLineDebugAdapterHandle.kt\ncom/intellij/platform/dap/connection/CommandLineDebugAdapterHandle\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,60:1\n15#2:61\n*S KotlinDebug\n*F\n+ 1 CommandLineDebugAdapterHandle.kt\ncom/intellij/platform/dap/connection/CommandLineDebugAdapterHandle\n*L\n22#1:61\n*E\n"})
public final class CommandLineDebugAdapterHandle
implements DebugAdapterHandle {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final MyProcessHandler handler;
    @NotNull
    private final InputStream input;
    @NotNull
    private final OutputStream output;
    @NotNull
    private static final Logger LOG;

    public CommandLineDebugAdapterHandle(@NotNull GeneralCommandLine commandLine) {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        this.handler = new MyProcessHandler(commandLine);
        this.handler.addProcessListener(MyProcessListener.INSTANCE);
        this.handler.startNotify();
        InputStream inputStream = this.handler.getProcess().getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
        this.input = inputStream;
        OutputStream outputStream = this.handler.getProcess().getOutputStream();
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"getOutputStream(...)");
        this.output = outputStream;
    }

    @Override
    @NotNull
    public InputStream getInput() {
        return this.input;
    }

    @Override
    @NotNull
    public OutputStream getOutput() {
        return this.output;
    }

    @Override
    @Nullable
    public Object disconnect(@NotNull Continuation<? super Unit> $completion) {
        if (!this.handler.isProcessTerminating() && !this.handler.isProcessTerminated()) {
            LOG.info("Stopping debug adapter process: " + this.handler.getCommandLine());
            ExecutionManagerImpl.Companion.stopProcess((ProcessHandler)this.handler);
        }
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CommandLineDebugAdapterHandle.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/platform/dap/connection/CommandLineDebugAdapterHandle$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.dap"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007H\u0014\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0014\u00a8\u0006\f"}, d2={"Lcom/intellij/platform/dap/connection/CommandLineDebugAdapterHandle$MyProcessHandler;", "Lcom/intellij/execution/process/KillableProcessHandler;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "<init>", "(Lcom/intellij/execution/configurations/GeneralCommandLine;)V", "readerOptions", "Lcom/intellij/util/io/BaseOutputReader$Options;", "kotlin.jvm.PlatformType", "()Lcom/intellij/util/io/BaseOutputReader$Options;", "createOutputDataReader", "Lcom/intellij/platform/dap/connection/CommandLineDebugAdapterHandle$NullReader;", "intellij.platform.dap"})
    private static final class MyProcessHandler
    extends KillableProcessHandler {
        public MyProcessHandler(@NotNull GeneralCommandLine commandLine) {
            Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
            super(commandLine);
        }

        protected BaseOutputReader.Options readerOptions() {
            return BaseOutputReader.Options.forMostlySilentProcess();
        }

        @NotNull
        protected NullReader createOutputDataReader() {
            return new NullReader((TaskExecutor)this);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/platform/dap/connection/CommandLineDebugAdapterHandle$MyProcessListener;", "Lcom/intellij/execution/process/ProcessListener;", "<init>", "()V", "onTextAvailable", "", "event", "Lcom/intellij/execution/process/ProcessEvent;", "outputType", "Lcom/intellij/openapi/util/Key;", "intellij.platform.dap"})
    private static final class MyProcessListener
    implements ProcessListener {
        @NotNull
        public static final MyProcessListener INSTANCE = new MyProcessListener();

        private MyProcessListener() {
        }

        public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key<?> outputType) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
            if (ProcessOutputType.isStderr(outputType)) {
                Logger logger = LOG;
                String string = event.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                logger.info("STDERR: " + ((Object)StringsKt.trimEnd((CharSequence)string)).toString());
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0019\u0010\u0006\u001a\u000b\u0012\u0002\b\u00030\u0007\u00a2\u0006\u0002\b\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u000b\u001a\u00020\fH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/platform/dap/connection/CommandLineDebugAdapterHandle$NullReader;", "Lcom/intellij/util/io/BaseDataReader;", "taskExecutor", "Lcom/intellij/execution/TaskExecutor;", "<init>", "(Lcom/intellij/execution/TaskExecutor;)V", "executeOnPooledThread", "Ljava/util/concurrent/Future;", "Lorg/jetbrains/annotations/NotNull;", "runnable", "Ljava/lang/Runnable;", "close", "", "intellij.platform.dap"})
    private static final class NullReader
    extends BaseDataReader {
        @NotNull
        private final TaskExecutor taskExecutor;

        public NullReader(@NotNull TaskExecutor taskExecutor) {
            Intrinsics.checkNotNullParameter((Object)taskExecutor, (String)"taskExecutor");
            super(BaseDataReader.SleepingPolicy.BLOCKING);
            this.taskExecutor = taskExecutor;
        }

        @NotNull
        protected Future<?> executeOnPooledThread(@NotNull Runnable runnable) {
            Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
            Future future = this.taskExecutor.executeTask(runnable);
            Intrinsics.checkNotNullExpressionValue((Object)future, (String)"executeTask(...)");
            return future;
        }

        protected void close() {
        }
    }
}

