/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DataGridBundle;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridHelper;
import com.intellij.database.datagrid.GridMutator;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridSelection;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.run.actions.DeleteActionBase;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.DataGridRequestPlace;
import com.intellij.openapi.util.NlsSafe;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeleteColumnsAction
extends DeleteActionBase {
    @Override
    protected boolean isVisible(@Nullable DataGrid grid) {
        return GridUtil.canMutateColumns(grid);
    }

    @Override
    protected boolean isEnabled(@NotNull DataGrid grid) {
        if (grid == null) {
            DeleteColumnsAction.$$$reportNull$$$0(0);
        }
        return GridUtil.canMutateColumns(grid) && DeleteColumnsAction.getColumns(grid).size() != 0;
    }

    @NotNull
    public static ModelIndexSet<GridColumn> getColumns(@NotNull DataGrid grid) {
        if (grid == null) {
            DeleteColumnsAction.$$$reportNull$$$0(1);
        }
        ModelIndex<GridColumn> column = grid.getContextColumn();
        ModelIndexSet modelIndexSet = column.value != -1 ? ModelIndexSet.forColumns((CoreGrid)grid, (int[])new int[]{column.value}) : grid.getSelectionModel().getSelectedColumns();
        if (modelIndexSet == null) {
            DeleteColumnsAction.$$$reportNull$$$0(2);
        }
        return modelIndexSet;
    }

    @Override
    protected void doDelete(@NotNull DataGrid grid, @NotNull ModelIndex<GridColumn> contextColumn) {
        if (grid == null) {
            DeleteColumnsAction.$$$reportNull$$$0(3);
        }
        if (contextColumn == null) {
            DeleteColumnsAction.$$$reportNull$$$0(4);
        }
        DeleteColumnsAction.deleteColumns(grid, (ModelIndexSet<GridColumn>)(contextColumn.value != -1 ? ModelIndexSet.forColumns((CoreGrid)grid, (int[])new int[]{contextColumn.value}) : grid.getSelectionModel().getSelectedColumns()));
    }

    public static void deleteColumns(@NotNull DataGrid grid, @NotNull ModelIndexSet<GridColumn> columns) {
        GridMutator.ColumnsMutator<GridRow, GridColumn> mutator;
        if (grid == null) {
            DeleteColumnsAction.$$$reportNull$$$0(5);
        }
        if (columns == null) {
            DeleteColumnsAction.$$$reportNull$$$0(6);
        }
        if ((mutator = GridUtil.getColumnsMutator(grid)) != null) {
            GridSelection selection = grid.getSelectionModel().store();
            GridRequestSource source = new GridRequestSource((GridRequestSource.RequestPlace)new DataGridRequestPlace((CoreGrid)grid, ModelIndexSet.forRows((CoreGrid)grid, (int[])new int[0]), columns));
            mutator.deleteColumns(source, columns);
            source.getActionCallback().doWhenDone(() -> grid.getAutoscrollLocker().runWithLock(() -> grid.getSelectionModel().restore(grid.getSelectionModel().fit(selection))));
        }
    }

    @Override
    protected int itemsCount(@NotNull DataGrid grid) {
        ModelIndex<GridColumn> contextColumn;
        if (grid == null) {
            DeleteColumnsAction.$$$reportNull$$$0(7);
        }
        return (contextColumn = grid.getContextColumn()).asInteger() != -1 ? 1 : grid.getSelectionModel().getSelectedColumnCount();
    }

    @Override
    @NlsSafe
    @NotNull
    protected String getItemName(@NotNull DataGrid grid) {
        ModelIndex column;
        if (grid == null) {
            DeleteColumnsAction.$$$reportNull$$$0(8);
        }
        if ((column = grid.getContextColumn()).asInteger() == -1) {
            column = grid.getSelectionModel().getSelectedColumn();
        }
        String string = Objects.requireNonNull((GridColumn)grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getColumn(column)).getName();
        if (string == null) {
            DeleteColumnsAction.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    @NotNull
    protected DeleteActionBase.ActionText text(@NotNull DataGrid grid) {
        if (grid == null) {
            DeleteColumnsAction.$$$reportNull$$$0(10);
        }
        int acrossCollection = GridHelper.get(grid).isModifyColumnAcrossCollection() ? 1 : 0;
        return new DeleteActionBase.ActionText(DataGridBundle.message((String)"grid.delete.column.action.text", (Object[])new Object[]{acrossCollection}), DataGridBundle.message((String)"grid.delete.columns.action.text", (Object[])new Object[]{acrossCollection}), DataGridBundle.message((String)"grid.delete.selected.column.action.text", (Object[])new Object[]{acrossCollection}), DataGridBundle.message((String)"grid.delete.selected.columns.action.text", (Object[])new Object[]{acrossCollection}), DataGridBundle.message((String)"grid.delete.selected.column.action.confirmation", (Object[])new Object[0]), DataGridBundle.message((String)"grid.delete.selected.columns.action.confirmation", (Object[])new Object[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/DeleteColumnsAction";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextColumn";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/DeleteColumnsAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumns";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getColumns";
                break;
            }
            case 2: 
            case 9: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doDelete";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "deleteColumns";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "itemsCount";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getItemName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "text";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 9 -> new IllegalStateException(string);
        };
    }
}

