/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.ui.flat;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.microservices.endpoints.EndpointsListItem;
import com.intellij.microservices.ui.MicroservicesUiBundle;
import com.intellij.microservices.ui.flat.LoadingMoreItem;
import com.intellij.microservices.utils.MicroservicesUsageCollector;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUiKind;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.help.HelpManager;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.DefaultListModel;
import javax.swing.ListModel;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\u0016\u0010\f\u001a\u00020\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000eH\u0002J\u0016\u0010\u000f\u001a\u00020\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000eH\u0002J\b\u0010\u0010\u001a\u00020\nH\u0002J\b\u0010\u0011\u001a\u00020\nH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lcom/intellij/microservices/ui/flat/EndpointsList;", "Lcom/intellij/ui/components/JBList;", "Lcom/intellij/microservices/endpoints/EndpointsListItem;", "<init>", "()V", "busyFlag", "", "isBusyLoading", "()Z", "setPaintBusy", "", "paintBusy", "updateLoadingTextAndIndicator", "modifiableModel", "Ljavax/swing/DefaultListModel;", "updateEmptyText", "emptyTextWithActions", "performActionOnEmptyText", "intellij.microservices.ui"})
public final class EndpointsList
extends JBList<EndpointsListItem> {
    private boolean busyFlag;

    public EndpointsList() {
        this.emptyTextWithActions();
        this.setExpandableItemsEnabled(false);
        this.setSelectionMode(2);
    }

    public final boolean isBusyLoading() {
        return this.busyFlag;
    }

    public void setPaintBusy(boolean paintBusy) {
        super.setPaintBusy(paintBusy);
        if (this.busyFlag != paintBusy) {
            this.busyFlag = paintBusy;
            ListModel listModel = super.getModel();
            DefaultListModel defaultListModel = listModel instanceof DefaultListModel ? (DefaultListModel)listModel : null;
            if (defaultListModel == null) {
                return;
            }
            DefaultListModel modifiableModel = defaultListModel;
            if (paintBusy) {
                this.updateLoadingTextAndIndicator(modifiableModel);
            } else {
                this.updateEmptyText(modifiableModel);
            }
        }
    }

    private final void updateLoadingTextAndIndicator(DefaultListModel<EndpointsListItem> modifiableModel) {
        this.getEmptyText().setText(MicroservicesUiBundle.message("endpoints.loading.text", new Object[0]));
        this.getEmptyText().setCenterAlignText(true);
        if (modifiableModel.size() > 0) {
            modifiableModel.addElement(LoadingMoreItem.INSTANCE);
        }
    }

    private final void updateEmptyText(DefaultListModel<EndpointsListItem> modifiableModel) {
        this.emptyTextWithActions();
        modifiableModel.removeElement(LoadingMoreItem.INSTANCE);
    }

    private final void emptyTextWithActions() {
        if (PluginManager.getInstance().findEnabledPlugin(PluginId.getId((String)"com.intellij.swagger")) == null) {
            this.getEmptyText().setText(MicroservicesUiBundle.message("endpoints.empty.text", new Object[0]));
        } else {
            this.getEmptyText().setCenterAlignText(false);
            this.getEmptyText().clear();
            this.getEmptyText().appendLine(MicroservicesUiBundle.message("endpoints.empty.text.add.endpoints.from", new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, arg_0 -> EndpointsList.emptyTextWithActions$lambda$0(this, arg_0)).appendText(MicroservicesUiBundle.message("endpoints.empty.text.hint", new Object[0])).appendLine(MicroservicesUiBundle.message("endpoints.empty.text.hint.search", new Object[0])).appendLine(MicroservicesUiBundle.message("endpoints.empty.text.hint.url.completion", new Object[0])).appendLine(MicroservicesUiBundle.message("endpoints.empty.text.hint.body.completion", new Object[0])).appendLine("").appendLine(AllIcons.General.ContextHelp, MicroservicesUiBundle.message("endpoints.empty.text.help", new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, EndpointsList::emptyTextWithActions$lambda$1);
        }
    }

    private final void performActionOnEmptyText() {
        AnAction anAction = ActionManager.getInstance().getAction("EndpointsActions.EmptyTextActions");
        Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.DefaultActionGroup");
        DefaultActionGroup group = (DefaultActionGroup)anAction;
        AnActionEvent anActionEvent = AnActionEvent.createEvent((DataContext)DataManager.getInstance().getDataContext((Component)((Object)this)), null, (String)"unknown", (ActionUiKind)ActionUiKind.NONE, null);
        Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createEvent(...)");
        AnActionEvent anActionEvent2 = anActionEvent;
        AnAction[] anActionArray = group.getChildren(anActionEvent2);
        Intrinsics.checkNotNullExpressionValue((Object)anActionArray, (String)"getChildren(...)");
        AnAction anAction2 = (AnAction)ArraysKt.singleOrNull((Object[])anActionArray);
        if (anAction2 == null) {
            anAction2 = (AnAction)group;
        }
        AnAction action = anAction2;
        ActionUtil.performActionDumbAwareWithCallbacks((AnAction)action, (AnActionEvent)anActionEvent2);
    }

    private static final void emptyTextWithActions$lambda$0(EndpointsList this$0, ActionEvent it) {
        this$0.performActionOnEmptyText();
        MicroservicesUsageCollector.INSTANCE.getENDPOINTS_EMPTY_STATE_ACTIVATED_EVENT().log();
    }

    private static final void emptyTextWithActions$lambda$1(ActionEvent it) {
        HelpManager.getInstance().invokeHelp("OpenAPI");
    }
}

