/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.run.configuration;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Computable;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.run.AbstractPythonRunConfigurationParams;
import com.jetbrains.python.run.configuration.PyInterpreterModeNotifier;
import com.jetbrains.python.sdk.PySdkListCellRenderer;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00012\u00020\u0003B!\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0010\u0010\u0006\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u000fJ\u000e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0014\u001a\u00020\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\bJ\u0012\u0010\u0016\u001a\u00020\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\bH\u0002J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0005H\u0002J\b\u0010\u0019\u001a\u00020\u0005H\u0002J\b\u0010\u001a\u001a\u0004\u0018\u00010\u0002J\b\u0010\u001b\u001a\u00020\u0005H\u0016J\b\u0010\u001c\u001a\u00020\u000fH\u0002J\u0016\u0010\u001d\u001a\u00020\u000f2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00050\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/python/run/configuration/PySdkComboBox;", "Lcom/intellij/openapi/ui/ComboBox;", "Lcom/intellij/openapi/projectRoots/Sdk;", "Lcom/jetbrains/python/run/configuration/PyInterpreterModeNotifier;", "addDefault", "", "moduleProvider", "Lcom/intellij/openapi/util/Computable;", "Lcom/intellij/openapi/module/Module;", "<init>", "(ZLcom/intellij/openapi/util/Computable;)V", "interpreterModeListeners", "", "Ljava/util/function/Consumer;", "reset", "", "config", "Lcom/jetbrains/python/run/AbstractPythonRunConfigurationParams;", "initList", "apply", "setModule", "module", "updateDefaultInterpreter", "setUseModuleSdk", "useModuleSdk", "isUseModuleSdk", "getSelectedSdk", "isRemoteSelected", "updateRemoteInterpreterMode", "addInterpreterModeListener", "listener", "intellij.python.community.impl"})
public final class PySdkComboBox
extends ComboBox<Sdk>
implements PyInterpreterModeNotifier {
    private final boolean addDefault;
    @NotNull
    private final Computable<? extends Module> moduleProvider;
    @NotNull
    private final List<Consumer<Boolean>> interpreterModeListeners;

    public PySdkComboBox(boolean addDefault, @NotNull Computable<? extends Module> moduleProvider) {
        Intrinsics.checkNotNullParameter(moduleProvider, (String)"moduleProvider");
        this.addDefault = addDefault;
        this.moduleProvider = moduleProvider;
        this.interpreterModeListeners = new ArrayList();
    }

    public final void reset(@NotNull AbstractPythonRunConfigurationParams config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.initList();
        this.setSelectedItem(config.getSdk());
        this.setUseModuleSdk(config.isUseModuleSdk());
        this.setModule(config.getModule());
        this.addActionListener(arg_0 -> PySdkComboBox.reset$lambda$0(this, arg_0));
        this.updateRemoteInterpreterMode();
    }

    public final void initList() {
        List<Sdk> list = PythonSdkUtil.getAllSdks();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getAllSdks(...)");
        List pythonSdks = CollectionsKt.toMutableList((Collection)list);
        if (this.addDefault) {
            pythonSdks.add(0, null);
        }
        for (Sdk item : pythonSdks) {
            this.addItem(item);
        }
    }

    public final void apply(@NotNull AbstractPythonRunConfigurationParams config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Object object = this.getSelectedItem();
        config.setSdk(object instanceof Sdk ? (Sdk)object : null);
        config.setUseModuleSdk(this.isUseModuleSdk());
    }

    public final void setModule(@Nullable Module module) {
        this.updateDefaultInterpreter(module);
        this.updateRemoteInterpreterMode();
    }

    private final void updateDefaultInterpreter(Module module) {
        PySdkListCellRenderer pySdkListCellRenderer;
        Sdk sdk2;
        Module module2 = module;
        Sdk sdk3 = sdk2 = module2 == null ? null : ModuleRootManager.getInstance((Module)module2).getSdk();
        if (sdk2 == null) {
            pySdkListCellRenderer = new PySdkListCellRenderer(null, null, 3, null);
        } else {
            Object[] objectArray = new Object[]{sdk2.getName()};
            String string = PyBundle.message("python.sdk.rendering.project.default.0", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            pySdkListCellRenderer = new PySdkListCellRenderer(string, sdk2);
        }
        this.setRenderer((ListCellRenderer)((Object)pySdkListCellRenderer));
    }

    private final void setUseModuleSdk(boolean useModuleSdk) {
        if (this.getSelectedItem() != null && useModuleSdk) {
            this.setSelectedItem(null);
        }
    }

    private final boolean isUseModuleSdk() {
        return this.addDefault && this.getSelectedItem() == null;
    }

    @Nullable
    public final Sdk getSelectedSdk() {
        Sdk selectedSdk;
        Object object = this.getSelectedItem();
        Sdk sdk2 = selectedSdk = object instanceof Sdk ? (Sdk)object : null;
        if (selectedSdk != null) {
            return selectedSdk;
        }
        if (this.isUseModuleSdk() && (object = (Module)this.moduleProvider.get()) != null) {
            Object it = object;
            boolean bl = false;
            return PythonSdkUtil.findPythonSdk((Module)it);
        }
        return null;
    }

    @Override
    public boolean isRemoteSelected() {
        return PythonSdkUtil.isRemote(this.getSelectedSdk());
    }

    private final void updateRemoteInterpreterMode() {
        boolean isRemote = this.isRemoteSelected();
        for (Consumer<Boolean> listener2 : this.interpreterModeListeners) {
            listener2.accept(isRemote);
        }
    }

    @Override
    public void addInterpreterModeListener(@NotNull Consumer<Boolean> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.interpreterModeListeners.add(listener2);
    }

    private static final void reset$lambda$0(PySdkComboBox this$0, ActionEvent it) {
        this$0.updateRemoteInterpreterMode();
    }
}

