/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyPossibleClassMember;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.pyi.PyiFile;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyElementPresentation
implements ColoredItemPresentation {
    @NotNull
    private final PyElement myElement;

    public PyElementPresentation(@NotNull PyElement element) {
        if (element == null) {
            PyElementPresentation.$$$reportNull$$$0(0);
        }
        this.myElement = element;
    }

    @Nullable
    public TextAttributesKey getTextAttributesKey() {
        return null;
    }

    @Nullable
    public String getPresentableText() {
        String name2 = this.myElement.getName();
        return name2 != null ? name2 : "<unnamed>";
    }

    @Nullable
    public String getLocationString() {
        PyClass containingClass;
        PsiFile containingFile = this.myElement.getContainingFile();
        String packageForFile = PyElementPresentation.getPackageForFile(containingFile);
        if (packageForFile == null) {
            return null;
        }
        boolean isPyiFile = containingFile instanceof PyiFile;
        PyClass pyClass = containingClass = this.myElement instanceof PyPossibleClassMember ? ((PyPossibleClassMember)((Object)this.myElement)).getContainingClass() : null;
        if (containingClass != null) {
            if (isPyiFile) {
                return PyPsiBundle.message("element.presentation.location.string.in.class.stub", containingClass.getName(), packageForFile);
            }
            return PyPsiBundle.message("element.presentation.location.string.in.class", containingClass.getName(), packageForFile);
        }
        if (isPyiFile) {
            return PyPsiBundle.message("element.presentation.location.string.module.stub", packageForFile);
        }
        return PyPsiBundle.message("element.presentation.location.string.module", packageForFile);
    }

    @Nullable
    public Icon getIcon(boolean unused) {
        return this.myElement.getIcon(0);
    }

    @Nullable
    public static String getPackageForFile(@NotNull PsiFile containingFile) {
        VirtualFile vFile;
        if (containingFile == null) {
            PyElementPresentation.$$$reportNull$$$0(1);
        }
        if ((vFile = containingFile.getVirtualFile()) != null) {
            return QualifiedNameFinder.findShortestImportableName((PsiElement)containingFile, vFile);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/psi/impl/PyElementPresentation";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getPackageForFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

