/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jewel.markdown.processing;

import androidx.compose.runtime.internal.StabilityInferred;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.commonmark.node.Block;
import org.commonmark.node.BlockQuote;
import org.commonmark.node.BulletList;
import org.commonmark.node.CustomBlock;
import org.commonmark.node.Document;
import org.commonmark.node.FencedCodeBlock;
import org.commonmark.node.Heading;
import org.commonmark.node.HtmlBlock;
import org.commonmark.node.IndentedCodeBlock;
import org.commonmark.node.ListBlock;
import org.commonmark.node.ListItem;
import org.commonmark.node.Node;
import org.commonmark.node.OrderedList;
import org.commonmark.node.Paragraph;
import org.commonmark.node.SourceSpan;
import org.commonmark.node.ThematicBreak;
import org.commonmark.parser.Parser;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.jewel.foundation.ExperimentalJewelApi;
import org.jetbrains.jewel.foundation.InternalJewelApi;
import org.jetbrains.jewel.foundation.code.MimeType;
import org.jetbrains.jewel.markdown.MarkdownBlock;
import org.jetbrains.jewel.markdown.MarkdownMode;
import org.jetbrains.jewel.markdown.extensions.MarkdownBlockProcessorExtension;
import org.jetbrains.jewel.markdown.extensions.MarkdownDelimitedInlineProcessorExtension;
import org.jetbrains.jewel.markdown.extensions.MarkdownProcessorExtension;
import org.jetbrains.jewel.markdown.processing.MarkdownParserFactory;
import org.jetbrains.jewel.markdown.processing.ProcessingUtilKt;
import org.jetbrains.jewel.markdown.scrolling.ScrollingSynchronizer;

@ExperimentalJewelApi
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00d0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001:\u0001LB+\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\u0015\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170\u00160\u0003H\u0001\u00a2\u0006\u0002\b\u0018J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00032\b\b\u0001\u0010\u001d\u001a\u00020\u001eJ\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00032\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u001d\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u00032\b\b\u0001\u0010\u001d\u001a\u00020\u001eH\u0001\u00a2\u0006\u0002\b\"J\u0018\u0010#\u001a\b\u0012\u0004\u0012\u00020!0\u00032\b\b\u0001\u0010\u001d\u001a\u00020\u001eH\u0002J\u000e\u0010$\u001a\u0004\u0018\u00010\u001c*\u00020%H\u0002J \u0010&\u001a\u00020'2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020!2\u0006\u0010)\u001a\u00020\u001cH\u0002J\f\u0010*\u001a\u00020+*\u00020,H\u0002J\f\u0010-\u001a\u00020.*\u00020/H\u0002J\u000e\u00100\u001a\u0004\u0018\u000101*\u000202H\u0002J\f\u00103\u001a\u000204*\u000205H\u0002J\f\u00103\u001a\u000206*\u000207H\u0002J\u000e\u00108\u001a\u0004\u0018\u000109*\u00020:H\u0002J\u000e\u00108\u001a\u0004\u0018\u00010;*\u00020<H\u0002J\u0012\u0010=\u001a\b\u0012\u0004\u0012\u00020>0\u0003*\u00020?H\u0002J\u0016\u0010@\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00032\u0006\u0010A\u001a\u00020%H\u0007J \u0010B\u001a\u00020'*\u00020%2\u0012\u0010C\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020'0DH\u0002J \u0010E\u001a\u00020'*\u00020%2\u0012\u0010C\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020'0DH\u0002J\u000e\u0010F\u001a\u0004\u0018\u00010G*\u00020HH\u0002J\u0011\u0010I\u001a\u00020\u00002\u0006\u0010J\u001a\u00020\u0004H\u0087\u0002J\u000e\u0010K\u001a\u00020\u00002\u0006\u0010J\u001a\u00020\u0004R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\fR\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006M"}, d2={"Lorg/jetbrains/jewel/markdown/processing/MarkdownProcessor;", "", "extensions", "", "Lorg/jetbrains/jewel/markdown/extensions/MarkdownProcessorExtension;", "markdownMode", "Lorg/jetbrains/jewel/markdown/MarkdownMode;", "commonMarkParser", "Lorg/commonmark/parser/Parser;", "<init>", "(Ljava/util/List;Lorg/jetbrains/jewel/markdown/MarkdownMode;Lorg/commonmark/parser/Parser;)V", "getExtensions", "()Ljava/util/List;", "blockExtensions", "Lorg/jetbrains/jewel/markdown/extensions/MarkdownBlockProcessorExtension;", "getBlockExtensions", "delimitedInlineExtensions", "Lorg/jetbrains/jewel/markdown/extensions/MarkdownDelimitedInlineProcessorExtension;", "getDelimitedInlineExtensions", "currentState", "Lorg/jetbrains/jewel/markdown/processing/MarkdownProcessor$State;", "getCurrentIndexesInTest", "Lkotlin/Pair;", "", "getCurrentIndexesInTest$intellij_platform_jewel_markdown_core", "scrollingSynchronizer", "Lorg/jetbrains/jewel/markdown/scrolling/ScrollingSynchronizer;", "processMarkdownDocument", "Lorg/jetbrains/jewel/markdown/MarkdownBlock;", "rawMarkdown", "", "doProcess", "processWithQuickEdits", "Lorg/commonmark/node/Block;", "processWithQuickEdits$intellij_platform_jewel_markdown_core", "parseRawMarkdown", "tryProcessMarkdownBlock", "Lorg/commonmark/node/Node;", "postProcess", "", "block", "mdBlock", "toMarkdownParagraph", "Lorg/jetbrains/jewel/markdown/MarkdownBlock$Paragraph;", "Lorg/commonmark/node/Paragraph;", "toMarkdownBlockQuote", "Lorg/jetbrains/jewel/markdown/MarkdownBlock$BlockQuote;", "Lorg/commonmark/node/BlockQuote;", "toMarkdownHeadingOrNull", "Lorg/jetbrains/jewel/markdown/MarkdownBlock$Heading;", "Lorg/commonmark/node/Heading;", "toMarkdownCodeBlockOrNull", "Lorg/jetbrains/jewel/markdown/MarkdownBlock$CodeBlock$FencedCodeBlock;", "Lorg/commonmark/node/FencedCodeBlock;", "Lorg/jetbrains/jewel/markdown/MarkdownBlock$CodeBlock$IndentedCodeBlock;", "Lorg/commonmark/node/IndentedCodeBlock;", "toMarkdownListOrNull", "Lorg/jetbrains/jewel/markdown/MarkdownBlock$ListBlock$UnorderedList;", "Lorg/commonmark/node/BulletList;", "Lorg/jetbrains/jewel/markdown/MarkdownBlock$ListBlock$OrderedList;", "Lorg/commonmark/node/OrderedList;", "processListItems", "Lorg/jetbrains/jewel/markdown/MarkdownBlock$ListItem;", "Lorg/commonmark/node/ListBlock;", "processChildren", "node", "forEachChild", "action", "Lkotlin/Function1;", "traverseAll", "toMarkdownHtmlBlockOrNull", "Lorg/jetbrains/jewel/markdown/MarkdownBlock$HtmlBlock;", "Lorg/commonmark/node/HtmlBlock;", "plus", "extension", "withExtension", "State", "intellij.platform.jewel.markdown.core"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nMarkdownProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownProcessor.kt\norg/jetbrains/jewel/markdown/processing/MarkdownProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,368:1\n1611#2,9:369\n1863#2:378\n1864#2:380\n1620#2:381\n1611#2,9:382\n1863#2:391\n1864#2:393\n1620#2:394\n1611#2,9:395\n1863#2:404\n1864#2:406\n1620#2:407\n1557#2:408\n1628#2,3:409\n1557#2:412\n1628#2,3:413\n1557#2:417\n1628#2,3:418\n1557#2:421\n1628#2,3:422\n1#3:379\n1#3:392\n1#3:405\n1#3:416\n*S KotlinDebug\n*F\n+ 1 MarkdownProcessor.kt\norg/jetbrains/jewel/markdown/processing/MarkdownProcessor\n*L\n68#1:369,9\n68#1:378\n68#1:380\n68#1:381\n75#1:382,9\n75#1:391\n75#1:393\n75#1:394\n107#1:395,9\n107#1:404\n107#1:406\n107#1:407\n161#1:408\n161#1:409,3\n175#1:412\n175#1:413,3\n198#1:417\n198#1:418,3\n228#1:421\n228#1:422,3\n68#1:379\n75#1:392\n107#1:405\n*E\n"})
public final class MarkdownProcessor {
    @NotNull
    private final List<MarkdownProcessorExtension> extensions;
    @NotNull
    private final MarkdownMode markdownMode;
    @NotNull
    private final Parser commonMarkParser;
    @NotNull
    private final List<MarkdownBlockProcessorExtension> blockExtensions;
    @NotNull
    private final List<MarkdownDelimitedInlineProcessorExtension> delimitedInlineExtensions;
    @NotNull
    private State currentState;
    @Nullable
    private final ScrollingSynchronizer scrollingSynchronizer;
    public static final int $stable = 8;

    public MarkdownProcessor(@NotNull List<? extends MarkdownProcessorExtension> extensions, @NotNull MarkdownMode markdownMode, @NotNull Parser commonMarkParser) {
        Object it$iv$iv;
        boolean bl;
        MarkdownProcessorExtension it;
        boolean bl2;
        Object element$iv$iv;
        Object element$iv$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter(extensions, (String)"extensions");
        Intrinsics.checkNotNullParameter((Object)markdownMode, (String)"markdownMode");
        Intrinsics.checkNotNullParameter((Object)commonMarkParser, (String)"commonMarkParser");
        this.extensions = extensions;
        this.markdownMode = markdownMode;
        this.commonMarkParser = commonMarkParser;
        Iterable iterable = this.extensions;
        MarkdownProcessor markdownProcessor = this;
        boolean $i$f$mapNotNull = false;
        void var6_8 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = element$iv$iv$iv = iterator.next();
            bl2 = false;
            it = (MarkdownProcessorExtension)element$iv$iv;
            boolean bl3 = false;
            if (it.getBlockProcessorExtension() == null) continue;
            bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        markdownProcessor.blockExtensions = (List)destination$iv$iv;
        $this$mapNotNull$iv = this.extensions;
        markdownProcessor = this;
        $i$f$mapNotNull = false;
        $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = element$iv$iv$iv = iterator.next();
            bl2 = false;
            it = (MarkdownProcessorExtension)element$iv$iv;
            boolean bl4 = false;
            if (it.getDelimitedInlineProcessorExtension() == null) continue;
            bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        markdownProcessor.delimitedInlineExtensions = (List)destination$iv$iv;
        this.currentState = new State(CollectionsKt.emptyList(), CollectionsKt.emptyList(), CollectionsKt.emptyList());
        MarkdownMode markdownMode2 = this.markdownMode;
        MarkdownMode.EditorPreview editorPreview = markdownMode2 instanceof MarkdownMode.EditorPreview ? (MarkdownMode.EditorPreview)markdownMode2 : null;
        this.scrollingSynchronizer = editorPreview != null ? editorPreview.getScrollingSynchronizer() : null;
    }

    public /* synthetic */ MarkdownProcessor(List list, MarkdownMode markdownMode, Parser parser, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 2) != 0) {
            markdownMode = MarkdownMode.Standalone.INSTANCE;
        }
        if ((n & 4) != 0) {
            parser = MarkdownParserFactory.create$default(MarkdownParserFactory.INSTANCE, markdownMode instanceof MarkdownMode.EditorPreview, list, null, 4, null);
        }
        this(list, markdownMode, parser);
    }

    @NotNull
    public final List<MarkdownProcessorExtension> getExtensions() {
        return this.extensions;
    }

    @NotNull
    public final List<MarkdownBlockProcessorExtension> getBlockExtensions() {
        return this.blockExtensions;
    }

    @NotNull
    public final List<MarkdownDelimitedInlineProcessorExtension> getDelimitedInlineExtensions() {
        return this.delimitedInlineExtensions;
    }

    @TestOnly
    @NotNull
    public final List<Pair<Integer, Integer>> getCurrentIndexesInTest$intellij_platform_jewel_markdown_core() {
        return this.currentState.getIndexes();
    }

    @NotNull
    public final List<MarkdownBlock> processMarkdownDocument(@Language(value="Markdown") @NotNull String rawMarkdown) {
        Intrinsics.checkNotNullParameter((Object)rawMarkdown, (String)"rawMarkdown");
        if (this.scrollingSynchronizer == null) {
            return this.doProcess(rawMarkdown);
        }
        return (List)this.scrollingSynchronizer.process(() -> MarkdownProcessor.processMarkdownDocument$lambda$2(this, rawMarkdown));
    }

    /*
     * WARNING - void declaration
     */
    private final List<MarkdownBlock> doProcess(String rawMarkdown) {
        void $this$mapNotNullTo$iv$iv;
        List<Block> blocks = this.markdownMode instanceof MarkdownMode.EditorPreview ? this.processWithQuickEdits$intellij_platform_jewel_markdown_core(rawMarkdown) : this.parseRawMarkdown(rawMarkdown);
        Iterable $this$mapNotNull$iv = blocks;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            MarkdownBlock it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Block child = (Block)element$iv$iv;
            boolean bl2 = false;
            if (this.tryProcessMarkdownBlock(child) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @VisibleForTesting
    @NotNull
    public final List<Block> processWithQuickEdits$intellij_platform_jewel_markdown_core(@Language(value="Markdown") @NotNull String rawMarkdown) {
        Intrinsics.checkNotNullParameter((Object)rawMarkdown, (String)"rawMarkdown");
        var2_2 = this.currentState;
        previousLines = var2_2.component1();
        previousBlocks = var2_2.component2();
        previousIndexes = var2_2.component3();
        newLines = StringsKt.lines((CharSequence)rawMarkdown);
        nLinesDelta = newLines.size() - previousLines.size();
        firstBlock = 0;
        firstLine = 0;
        currFirstBlock = 0;
        currFirstLine = 0;
        var12_12 = ((Iterable)previousIndexes).iterator();
        var13_14 = 0;
        block0: while (var12_12.hasNext()) {
            i = var13_14++;
            j = currFirstLine;
            spans = (Pair)var12_12.next();
            end = ((Number)spans.component2()).intValue();
            if (j > end) ** GOTO lbl24
            while (j >= 0 && j < newLines.size() && Intrinsics.areEqual(newLines.get(j), (Object)previousLines.get(j))) {
                if (j != end) {
                    ++j;
                    continue;
                }
lbl24:
                // 3 sources

                firstBlock = currFirstBlock;
                firstLine = currFirstLine;
                currFirstBlock = i + 1;
                currFirstLine = end + 1;
                continue block0;
            }
            break block0;
        }
        lastBlock = previousBlocks.size();
        lastLine = previousLines.size();
        currLastBlock = lastBlock;
        currLastLine = lastLine;
        block2: for (IndexedValue j : CollectionsKt.reversed((Iterable)CollectionsKt.withIndex((Iterable)previousIndexes))) {
            i = j.component1();
            spans = (Pair)j.component2();
            var22_33 = currLastLine;
            for (j = begin = ((Number)spans.component1()).intValue(); j < var22_33; ++j) {
                newIndex = j + nLinesDelta;
                if (newIndex < 0 || newIndex >= newLines.size() || !Intrinsics.areEqual((Object)previousLines.get(j), newLines.get(newIndex))) break block2;
            }
            lastBlock = currLastBlock;
            lastLine = currLastLine;
            currLastBlock = i;
            currLastLine = begin;
        }
        if (firstLine > lastLine + nLinesDelta) {
            return previousBlocks;
        }
        updatedText = CollectionsKt.joinToString$default((Iterable)newLines.subList(firstLine, lastLine + nLinesDelta), (CharSequence)"\n", null, (CharSequence)"\n", (int)0, null, null, (int)58, null);
        updatedBlocks = this.parseRawMarkdown(updatedText);
        $this$map$iv = updatedBlocks;
        $i$f$map = false;
        j = $this$map$iv;
        destination$iv$iv /* !! */  = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            var26_45 = (Block)item$iv$iv;
            var30_52 = destination$iv$iv /* !! */ ;
            $i$a$-map-MarkdownProcessor$processWithQuickEdits$updatedIndexes$1 = false;
            if (node.getSourceSpans().isEmpty()) {
                node.setSourceSpans(node.getPrevious().getSourceSpans());
            }
            v0 = node.getSourceSpans();
            Intrinsics.checkNotNullExpressionValue(v0, (String)"getSourceSpans(...)");
            firstLineIndex = ((SourceSpan)CollectionsKt.first(v0)).getLineIndex() + firstLine;
            v1 = node.getSourceSpans();
            Intrinsics.checkNotNullExpressionValue(v1, (String)"getSourceSpans(...)");
            lastLineIndex = ((SourceSpan)CollectionsKt.last(v1)).getLineIndex() + firstLine;
            var30_52.add(TuplesKt.to((Object)firstLineIndex, (Object)lastLineIndex));
        }
        updatedIndexes = (List)destination$iv$iv /* !! */ ;
        $this$map$iv = previousIndexes.subList(lastBlock, previousBlocks.size());
        $i$f$map = false;
        destination$iv$iv /* !! */  = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (E item$iv$iv : $this$mapTo$iv$iv) {
            $i$a$-map-MarkdownProcessor$processWithQuickEdits$updatedIndexes$1 = (Pair)item$iv$iv;
            var30_52 = destination$iv$iv;
            $i$a$-map-MarkdownProcessor$processWithQuickEdits$suffixIndexes$1 = false;
            var30_52.add(TuplesKt.to((Object)(((Number)it.getFirst()).intValue() + nLinesDelta), (Object)(((Number)it.getSecond()).intValue() + nLinesDelta)));
        }
        suffixIndexes = (List)destination$iv$iv;
        newBlocks = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)previousBlocks.subList(0, firstBlock), (Iterable)updatedBlocks), (Iterable)previousBlocks.subList(lastBlock, previousBlocks.size()));
        newIndexes = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)previousIndexes.subList(0, firstBlock), (Iterable)updatedIndexes), (Iterable)suffixIndexes);
        var23_39 = newBlocks.size();
        for (i = lastBlock; i < var23_39; ++i) {
            this.traverseAll((Node)newBlocks.get(i), (Function1<? super Node, Unit>)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, processWithQuickEdits$lambda$7(int org.commonmark.node.Node ), (Lorg/commonmark/node/Node;)Lkotlin/Unit;)((int)nLinesDelta));
        }
        for (Pair var23_40 : CollectionsKt.zip((Iterable)updatedBlocks, (Iterable)updatedIndexes)) {
            block = (Block)var23_40.component1();
            indexes = (Pair)var23_40.component2();
            v2 = block.getSourceSpans();
            Intrinsics.checkNotNullExpressionValue(v2, (String)"getSourceSpans(...)");
            v3 = (SourceSpan)CollectionsKt.firstOrNull(v2);
            if (v3 == null) {
                continue;
            }
            firstSpanLineIndex = v3.getLineIndex();
            firstIndex = ((Number)indexes.getFirst()).intValue();
            this.traverseAll(block, (Function1<? super Node, Unit>)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, processWithQuickEdits$lambda$9(int int org.commonmark.node.Node ), (Lorg/commonmark/node/Node;)Lkotlin/Unit;)((int)firstSpanLineIndex, (int)firstIndex));
        }
        this.currentState = new State(newLines, newBlocks, newIndexes);
        return newBlocks;
    }

    private final List<Block> parseRawMarkdown(@Language(value="Markdown") String rawMarkdown) {
        List list;
        Node node = this.commonMarkParser.parse(rawMarkdown);
        Document document = node instanceof Document ? (Document)node : null;
        if (document == null) {
            throw new IllegalStateException("This doesn't look like a Markdown document".toString());
        }
        Document document2 = document;
        List $this$parseRawMarkdown_u24lambda_u2411 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        this.forEachChild(document2, (Function1<? super Node, Unit>)((Function1)arg_0 -> MarkdownProcessor.parseRawMarkdown$lambda$11$lambda$10($this$parseRawMarkdown_u24lambda_u2411, arg_0)));
        return CollectionsKt.build((List)list);
    }

    private final MarkdownBlock tryProcessMarkdownBlock(Node $this$tryProcessMarkdownBlock) {
        MarkdownBlock markdownBlock;
        Object object = $this$tryProcessMarkdownBlock;
        if (object instanceof Paragraph) {
            markdownBlock = this.toMarkdownParagraph((Paragraph)$this$tryProcessMarkdownBlock);
        } else if (object instanceof Heading) {
            markdownBlock = this.toMarkdownHeadingOrNull((Heading)$this$tryProcessMarkdownBlock);
        } else if (object instanceof BulletList) {
            markdownBlock = this.toMarkdownListOrNull((BulletList)$this$tryProcessMarkdownBlock);
        } else if (object instanceof OrderedList) {
            markdownBlock = this.toMarkdownListOrNull((OrderedList)$this$tryProcessMarkdownBlock);
        } else if (object instanceof BlockQuote) {
            markdownBlock = this.toMarkdownBlockQuote((BlockQuote)$this$tryProcessMarkdownBlock);
        } else if (object instanceof FencedCodeBlock) {
            markdownBlock = this.toMarkdownCodeBlockOrNull((FencedCodeBlock)$this$tryProcessMarkdownBlock);
        } else if (object instanceof IndentedCodeBlock) {
            markdownBlock = this.toMarkdownCodeBlockOrNull((IndentedCodeBlock)$this$tryProcessMarkdownBlock);
        } else if (object instanceof ThematicBreak) {
            markdownBlock = MarkdownBlock.ThematicBreak.INSTANCE;
        } else if (object instanceof HtmlBlock) {
            markdownBlock = this.toMarkdownHtmlBlockOrNull((HtmlBlock)$this$tryProcessMarkdownBlock);
        } else if (object instanceof CustomBlock) {
            Object v1;
            block22: {
                Iterable iterable = this.blockExtensions;
                for (Object t : iterable) {
                    MarkdownBlockProcessorExtension it = (MarkdownBlockProcessorExtension)t;
                    boolean bl = false;
                    if (!it.canProcess((CustomBlock)$this$tryProcessMarkdownBlock)) continue;
                    v1 = t;
                    break block22;
                }
                v1 = null;
            }
            MarkdownBlockProcessorExtension markdownBlockProcessorExtension = v1;
            markdownBlock = markdownBlockProcessorExtension != null ? markdownBlockProcessorExtension.processMarkdownBlock((CustomBlock)$this$tryProcessMarkdownBlock, this) : null;
        } else {
            markdownBlock = null;
        }
        Object block = object = markdownBlock;
        boolean bl = false;
        if (this.scrollingSynchronizer != null && $this$tryProcessMarkdownBlock instanceof Block && block != null) {
            this.postProcess(this.scrollingSynchronizer, (Block)$this$tryProcessMarkdownBlock, (MarkdownBlock)block);
        }
        return object;
    }

    private final void postProcess(ScrollingSynchronizer scrollingSynchronizer, Block block, MarkdownBlock mdBlock) {
        List<SourceSpan> list;
        List<SourceSpan> it = list = block.getSourceSpans();
        boolean bl = false;
        Intrinsics.checkNotNull(it);
        List<SourceSpan> list2 = !((Collection)it).isEmpty() ? list : null;
        if (list2 == null) {
            return;
        }
        List<SourceSpan> spans = list2;
        scrollingSynchronizer.acceptBlockSpans(mdBlock, new IntRange(((SourceSpan)CollectionsKt.first(spans)).getLineIndex(), ((SourceSpan)CollectionsKt.last(spans)).getLineIndex()));
    }

    private final MarkdownBlock.Paragraph toMarkdownParagraph(Paragraph $this$toMarkdownParagraph) {
        return new MarkdownBlock.Paragraph(ProcessingUtilKt.readInlineMarkdown($this$toMarkdownParagraph, this));
    }

    private final MarkdownBlock.BlockQuote toMarkdownBlockQuote(BlockQuote $this$toMarkdownBlockQuote) {
        return new MarkdownBlock.BlockQuote(this.processChildren($this$toMarkdownBlockQuote));
    }

    private final MarkdownBlock.Heading toMarkdownHeadingOrNull(Heading $this$toMarkdownHeadingOrNull) {
        if ($this$toMarkdownHeadingOrNull.getLevel() < 1 || $this$toMarkdownHeadingOrNull.getLevel() > 6) {
            return null;
        }
        return new MarkdownBlock.Heading(ProcessingUtilKt.readInlineMarkdown($this$toMarkdownHeadingOrNull, this), $this$toMarkdownHeadingOrNull.getLevel());
    }

    private final MarkdownBlock.CodeBlock.FencedCodeBlock toMarkdownCodeBlockOrNull(FencedCodeBlock $this$toMarkdownCodeBlockOrNull) {
        String string = $this$toMarkdownCodeBlockOrNull.getLiteral();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLiteral(...)");
        String string2 = StringsKt.removeSuffix((String)string, (CharSequence)"\n");
        String string3 = $this$toMarkdownCodeBlockOrNull.getInfo();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getInfo(...)");
        return new MarkdownBlock.CodeBlock.FencedCodeBlock(string2, MimeType.Known.INSTANCE.fromMarkdownLanguageName-YABSuFg(string3), null);
    }

    private final MarkdownBlock.CodeBlock.IndentedCodeBlock toMarkdownCodeBlockOrNull(IndentedCodeBlock $this$toMarkdownCodeBlockOrNull) {
        String string = $this$toMarkdownCodeBlockOrNull.getLiteral();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLiteral(...)");
        char[] cArray = new char[]{'\n'};
        return new MarkdownBlock.CodeBlock.IndentedCodeBlock(StringsKt.trimEnd((String)string, (char[])cArray));
    }

    private final MarkdownBlock.ListBlock.UnorderedList toMarkdownListOrNull(BulletList $this$toMarkdownListOrNull) {
        List<MarkdownBlock.ListItem> children = this.processListItems($this$toMarkdownListOrNull);
        if (children.isEmpty()) {
            return null;
        }
        boolean bl = $this$toMarkdownListOrNull.isTight();
        String string = $this$toMarkdownListOrNull.getMarker();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMarker(...)");
        return new MarkdownBlock.ListBlock.UnorderedList(children, bl, string);
    }

    private final MarkdownBlock.ListBlock.OrderedList toMarkdownListOrNull(OrderedList $this$toMarkdownListOrNull) {
        List<MarkdownBlock.ListItem> children = this.processListItems($this$toMarkdownListOrNull);
        if (children.isEmpty()) {
            return null;
        }
        boolean bl = $this$toMarkdownListOrNull.isTight();
        Integer n = $this$toMarkdownListOrNull.getMarkerStartNumber();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getMarkerStartNumber(...)");
        int n2 = ((Number)n).intValue();
        String string = $this$toMarkdownListOrNull.getMarkerDelimiter();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMarkerDelimiter(...)");
        return new MarkdownBlock.ListBlock.OrderedList(children, bl, n2, string);
    }

    private final List<MarkdownBlock.ListItem> processListItems(ListBlock $this$processListItems) {
        List list;
        List $this$processListItems_u24lambda_u2416 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        this.forEachChild($this$processListItems, (Function1<? super Node, Unit>)((Function1)arg_0 -> MarkdownProcessor.processListItems$lambda$16$lambda$15($this$processListItems_u24lambda_u2416, this, arg_0)));
        return CollectionsKt.build((List)list);
    }

    @InternalJewelApi
    @NotNull
    public final List<MarkdownBlock> processChildren(@NotNull Node node) {
        List list;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        List $this$processChildren_u24lambda_u2418 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        this.forEachChild(node, (Function1<? super Node, Unit>)((Function1)arg_0 -> MarkdownProcessor.processChildren$lambda$18$lambda$17(this, $this$processChildren_u24lambda_u2418, arg_0)));
        return CollectionsKt.build((List)list);
    }

    private final void forEachChild(Node $this$forEachChild, Function1<? super Node, Unit> action) {
        for (Node child = $this$forEachChild.getFirstChild(); child != null; child = child.getNext()) {
            action.invoke((Object)child);
        }
    }

    private final void traverseAll(Node $this$traverseAll, Function1<? super Node, Unit> action) {
        action.invoke((Object)$this$traverseAll);
        this.forEachChild($this$traverseAll, (Function1<? super Node, Unit>)((Function1)arg_0 -> MarkdownProcessor.traverseAll$lambda$19(this, action, arg_0)));
    }

    private final MarkdownBlock.HtmlBlock toMarkdownHtmlBlockOrNull(HtmlBlock $this$toMarkdownHtmlBlockOrNull) {
        String string = $this$toMarkdownHtmlBlockOrNull.getLiteral();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLiteral(...)");
        if (StringsKt.isBlank((CharSequence)string)) {
            return null;
        }
        String string2 = $this$toMarkdownHtmlBlockOrNull.getLiteral();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getLiteral(...)");
        char[] cArray = new char[]{'\n'};
        return new MarkdownBlock.HtmlBlock(StringsKt.trimEnd((String)string2, (char[])cArray));
    }

    @ExperimentalJewelApi
    @NotNull
    public final MarkdownProcessor plus(@NotNull MarkdownProcessorExtension extension) {
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        return this.withExtension(extension);
    }

    @NotNull
    public final MarkdownProcessor withExtension(@NotNull MarkdownProcessorExtension extension) {
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        return new MarkdownProcessor(CollectionsKt.plus((Collection)this.extensions, (Object)extension), this.markdownMode, this.commonMarkParser);
    }

    private static final List processMarkdownDocument$lambda$2(MarkdownProcessor this$0, String $rawMarkdown) {
        return this$0.doProcess($rawMarkdown);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit processWithQuickEdits$lambda$7(int $nLinesDelta, Node node) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        List<SourceSpan> list = node.getSourceSpans();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getSourceSpans(...)");
        Iterable iterable = list;
        Node node2 = node;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void span;
            SourceSpan sourceSpan = (SourceSpan)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(SourceSpan.of(span.getLineIndex() + $nLinesDelta, span.getColumnIndex(), span.getInputIndex(), span.getLength()));
        }
        node2.setSourceSpans((List)destination$iv$iv);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit processWithQuickEdits$lambda$9(int $firstSpanLineIndex, int $firstIndex, Node node) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        List<SourceSpan> list = node.getSourceSpans();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getSourceSpans(...)");
        Iterable iterable = list;
        Node node2 = node;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void span;
            SourceSpan sourceSpan = (SourceSpan)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(SourceSpan.of(span.getLineIndex() - $firstSpanLineIndex + $firstIndex, span.getColumnIndex(), span.getInputIndex(), span.getLength()));
        }
        node2.setSourceSpans((List)destination$iv$iv);
        return Unit.INSTANCE;
    }

    private static final Unit parseRawMarkdown$lambda$11$lambda$10(List $this_buildList, Node child) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        if (child instanceof Block) {
            $this_buildList.add(child);
        }
        return Unit.INSTANCE;
    }

    private static final Unit processListItems$lambda$16$lambda$15(List $this_buildList, MarkdownProcessor this$0, Node child) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        if (!(child instanceof ListItem)) {
            return Unit.INSTANCE;
        }
        $this_buildList.add(new MarkdownBlock.ListItem(this$0.processChildren(child)));
        return Unit.INSTANCE;
    }

    private static final Unit processChildren$lambda$18$lambda$17(MarkdownProcessor this$0, List $this_buildList, Node child) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        MarkdownBlock parsedBlock = this$0.tryProcessMarkdownBlock(child);
        if (parsedBlock != null) {
            $this_buildList.add(parsedBlock);
        }
        return Unit.INSTANCE;
    }

    private static final Unit traverseAll$lambda$19(MarkdownProcessor this$0, Function1 $action, Node child) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        this$0.traverseAll(child, (Function1<? super Node, Unit>)$action);
        return Unit.INSTANCE;
    }

    public MarkdownProcessor() {
        this(null, null, null, 7, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B=\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u0018\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b0\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0003J\u001b\u0010\u0012\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b0\u0003H\u00c6\u0003JE\u0010\u0013\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00032\u001a\b\u0002\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b0\u0003H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\tH\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR#\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/jewel/markdown/processing/MarkdownProcessor$State;", "", "lines", "", "", "blocks", "Lorg/commonmark/node/Block;", "indexes", "Lkotlin/Pair;", "", "<init>", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getLines", "()Ljava/util/List;", "getBlocks", "getIndexes", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "intellij.platform.jewel.markdown.core"})
    private static final class State {
        @NotNull
        private final List<String> lines;
        @NotNull
        private final List<Block> blocks;
        @NotNull
        private final List<Pair<Integer, Integer>> indexes;

        public State(@NotNull List<String> lines, @NotNull List<? extends Block> blocks, @NotNull List<Pair<Integer, Integer>> indexes) {
            Intrinsics.checkNotNullParameter(lines, (String)"lines");
            Intrinsics.checkNotNullParameter(blocks, (String)"blocks");
            Intrinsics.checkNotNullParameter(indexes, (String)"indexes");
            this.lines = lines;
            this.blocks = blocks;
            this.indexes = indexes;
        }

        @NotNull
        public final List<String> getLines() {
            return this.lines;
        }

        @NotNull
        public final List<Block> getBlocks() {
            return this.blocks;
        }

        @NotNull
        public final List<Pair<Integer, Integer>> getIndexes() {
            return this.indexes;
        }

        @NotNull
        public final List<String> component1() {
            return this.lines;
        }

        @NotNull
        public final List<Block> component2() {
            return this.blocks;
        }

        @NotNull
        public final List<Pair<Integer, Integer>> component3() {
            return this.indexes;
        }

        @NotNull
        public final State copy(@NotNull List<String> lines, @NotNull List<? extends Block> blocks, @NotNull List<Pair<Integer, Integer>> indexes) {
            Intrinsics.checkNotNullParameter(lines, (String)"lines");
            Intrinsics.checkNotNullParameter(blocks, (String)"blocks");
            Intrinsics.checkNotNullParameter(indexes, (String)"indexes");
            return new State(lines, blocks, indexes);
        }

        public static /* synthetic */ State copy$default(State state, List list, List list2, List list3, int n, Object object) {
            if ((n & 1) != 0) {
                list = state.lines;
            }
            if ((n & 2) != 0) {
                list2 = state.blocks;
            }
            if ((n & 4) != 0) {
                list3 = state.indexes;
            }
            return state.copy(list, list2, list3);
        }

        @NotNull
        public String toString() {
            return "State(lines=" + this.lines + ", blocks=" + this.blocks + ", indexes=" + this.indexes + ")";
        }

        public int hashCode() {
            int result = ((Object)this.lines).hashCode();
            result = result * 31 + ((Object)this.blocks).hashCode();
            result = result * 31 + ((Object)this.indexes).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof State)) {
                return false;
            }
            State state = (State)other;
            if (!Intrinsics.areEqual(this.lines, state.lines)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.blocks, state.blocks)) {
                return false;
            }
            return Intrinsics.areEqual(this.indexes, state.indexes);
        }
    }
}

