/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsLogTabLocation;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.ui.MainVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public abstract class OpenAnotherLogTabAction
extends DumbAwareAction {
    protected OpenAnotherLogTabAction() {
        this.getTemplatePresentation().setText(() -> this.getText(VcsLogBundle.message("vcs", new Object[0])));
        this.getTemplatePresentation().setDescription(() -> this.getDescription(VcsLogBundle.message("vcs", new Object[0])));
    }

    public void update(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            OpenAnotherLogTabAction.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        VcsProjectLog projectLog = VcsProjectLog.getInstance(project);
        VcsLogManager logManager2 = (VcsLogManager)ObjectUtils.chooseNotNull((Object)((VcsLogManager)e.getData(VcsLogInternalDataKeys.LOG_MANAGER)), (Object)projectLog.getLogManager());
        if (logManager2 == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setEnabledAndVisible(projectLog.getLogManager() == logManager2);
        String vcsName = VcsLogUtil.getVcsDisplayName(project, logManager2);
        e.getPresentation().setText(this.getText(vcsName));
        e.getPresentation().setDescription(this.getDescription(vcsName));
    }

    @NotNull
    @Nls(capitalization=Nls.Capitalization.Sentence)
    protected String getDescription(@Nls @NotNull String vcsName) {
        if (vcsName == null) {
            OpenAnotherLogTabAction.$$$reportNull$$$0(1);
        }
        String string = VcsLogBundle.message("vcs.log.action.description.open.new.tab.with.log", vcsName);
        if (string == null) {
            OpenAnotherLogTabAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    @Nls(capitalization=Nls.Capitalization.Title)
    protected String getText(@Nls @NotNull String vcsName) {
        if (vcsName == null) {
            OpenAnotherLogTabAction.$$$reportNull$$$0(3);
        }
        String string = VcsLogBundle.message("vcs.log.action.open.new.tab.with.log", vcsName);
        if (string == null) {
            OpenAnotherLogTabAction.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            OpenAnotherLogTabAction.$$$reportNull$$$0(5);
        }
        VcsLogUsageTriggerCollector.triggerUsage(e, (Object)this);
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        VcsLogFilterCollection filters = Registry.is((String)"vcs.log.copy.filters.to.new.tab") ? this.getFilters(project, e) : VcsLogFilterObject.collection(new VcsLogFilter[0]);
        VcsProjectLog.getInstance(project).openLogTab(filters, this.getLocation(e));
    }

    @NotNull
    protected VcsLogFilterCollection getFilters(@NotNull Project project, @NotNull AnActionEvent e) {
        VcsLogUi logUi;
        if (project == null) {
            OpenAnotherLogTabAction.$$$reportNull$$$0(6);
        }
        if (e == null) {
            OpenAnotherLogTabAction.$$$reportNull$$$0(7);
        }
        if ((logUi = (VcsLogUi)e.getData(VcsLogDataKeys.VCS_LOG_UI)) == null) {
            VcsLogFilterCollection vcsLogFilterCollection = VcsLogFilterObject.collection(new VcsLogFilter[0]);
            if (vcsLogFilterCollection == null) {
                OpenAnotherLogTabAction.$$$reportNull$$$0(8);
            }
            return vcsLogFilterCollection;
        }
        VcsLogFilterCollection vcsLogFilterCollection = logUi.getFilterUi().getFilters();
        if (vcsLogFilterCollection == null) {
            OpenAnotherLogTabAction.$$$reportNull$$$0(9);
        }
        return vcsLogFilterCollection;
    }

    @NotNull
    protected abstract VcsLogTabLocation getLocation(@NotNull AnActionEvent var1);

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            OpenAnotherLogTabAction.$$$reportNull$$$0(10);
        }
        return actionUpdateThread;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsName";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/actions/OpenAnotherLogTabAction";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/actions/OpenAnotherLogTabAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilters";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDescription";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFilters";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 8, 9, 10 -> new IllegalStateException(string);
        };
    }

    @ApiStatus.Internal
    public static class InEditor
    extends OpenAnotherLogTabAction {
        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                InEditor.$$$reportNull$$$0(0);
            }
            if (Registry.is((String)"toolwindow.open.tab.in.editor")) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            super.update(e);
            if (e.getData(PlatformDataKeys.TOOL_WINDOW) != null && "Vcs.Log.Toolbar".equals(e.getPlace())) {
                e.getPresentation().setEnabledAndVisible(false);
            }
        }

        @Override
        @NotNull
        @Nls(capitalization=Nls.Capitalization.Sentence)
        protected String getDescription(@Nls @NotNull String vcsName) {
            if (vcsName == null) {
                InEditor.$$$reportNull$$$0(1);
            }
            String string = VcsLogBundle.message("vcs.log.action.description.open.new.tab.with.log.in.editor", vcsName);
            if (string == null) {
                InEditor.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @NotNull
        @Nls(capitalization=Nls.Capitalization.Title)
        protected String getText(@Nls @NotNull String vcsName) {
            if (vcsName == null) {
                InEditor.$$$reportNull$$$0(3);
            }
            String string = VcsLogBundle.message("vcs.log.action.open.new.tab.with.log.in.editor", vcsName);
            if (string == null) {
                InEditor.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Override
        @NotNull
        protected VcsLogTabLocation getLocation(@NotNull AnActionEvent e) {
            if (e == null) {
                InEditor.$$$reportNull$$$0(5);
            }
            VcsLogTabLocation vcsLogTabLocation = VcsLogTabLocation.EDITOR;
            if (vcsLogTabLocation == null) {
                InEditor.$$$reportNull$$$0(6);
            }
            return vcsLogTabLocation;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 4, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "vcsName";
                    break;
                }
                case 2: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/ui/actions/OpenAnotherLogTabAction$InEditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/ui/actions/OpenAnotherLogTabAction$InEditor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescription";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLocation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getDescription";
                    break;
                }
                case 2: 
                case 4: 
                case 6: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getText";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getLocation";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 4, 6 -> new IllegalStateException(string);
            };
        }
    }

    @ApiStatus.Internal
    public static class InToolWindow
    extends OpenAnotherLogTabAction {
        @Override
        @NotNull
        protected VcsLogTabLocation getLocation(@NotNull AnActionEvent e) {
            if (e == null) {
                InToolWindow.$$$reportNull$$$0(0);
            }
            VcsLogTabLocation vcsLogTabLocation = VcsLogTabLocation.TOOL_WINDOW;
            if (vcsLogTabLocation == null) {
                InToolWindow.$$$reportNull$$$0(1);
            }
            return vcsLogTabLocation;
        }

        @Override
        @NotNull
        protected VcsLogFilterCollection getFilters(@NotNull Project project, @NotNull AnActionEvent e) {
            VcsLogManager logManager2;
            if (project == null) {
                InToolWindow.$$$reportNull$$$0(2);
            }
            if (e == null) {
                InToolWindow.$$$reportNull$$$0(3);
            }
            if ((logManager2 = VcsProjectLog.getInstance(project).getLogManager()) == null) {
                VcsLogFilterCollection vcsLogFilterCollection = VcsLogFilterObject.collection(new VcsLogFilter[0]);
                if (vcsLogFilterCollection == null) {
                    InToolWindow.$$$reportNull$$$0(4);
                }
                return vcsLogFilterCollection;
            }
            List uis = ContainerUtil.filterIsInstance(logManager2.getVisibleLogUis(VcsLogTabLocation.TOOL_WINDOW), MainVcsLogUi.class);
            if (uis.isEmpty()) {
                VcsLogFilterCollection vcsLogFilterCollection = VcsLogFilterObject.collection(new VcsLogFilter[0]);
                if (vcsLogFilterCollection == null) {
                    InToolWindow.$$$reportNull$$$0(5);
                }
                return vcsLogFilterCollection;
            }
            VcsLogFilterCollection vcsLogFilterCollection = ((VcsLogUi)ContainerUtil.getFirstItem((Collection)uis)).getFilterUi().getFilters();
            if (vcsLogFilterCollection == null) {
                InToolWindow.$$$reportNull$$$0(6);
            }
            return vcsLogFilterCollection;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 4, 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/ui/actions/OpenAnotherLogTabAction$InToolWindow";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/ui/actions/OpenAnotherLogTabAction$InToolWindow";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLocation";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilters";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getLocation";
                    break;
                }
                case 1: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getFilters";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 4, 5, 6 -> new IllegalStateException(string);
            };
        }
    }
}

