/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.sftp;

import java.io.File;
import java.util.Arrays;
import java.util.Objects;

public class IdentityInfo {
    private final File privateKey;
    private final File publicKey;
    private final byte[] passPhrase;

    public IdentityInfo(File privateKey) {
        this(privateKey, null, null);
    }

    public IdentityInfo(File privateKey, byte[] passPhrase) {
        this(privateKey, null, passPhrase);
    }

    public IdentityInfo(File privateKey, File publicKey, byte[] passPhrase) {
        this.privateKey = privateKey;
        this.publicKey = publicKey;
        this.passPhrase = passPhrase;
    }

    public File getPrivateKey() {
        return this.privateKey;
    }

    public File getPublicKey() {
        return this.publicKey;
    }

    public byte[] getPassPhrase() {
        return this.passPhrase;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdentityInfo that = (IdentityInfo)o;
        if (!Objects.equals(this.privateKey, that.privateKey)) {
            return false;
        }
        if (!Objects.equals(this.publicKey, that.publicKey)) {
            return false;
        }
        return Arrays.equals(this.passPhrase, that.passPhrase);
    }

    public int hashCode() {
        int result = this.privateKey != null ? this.privateKey.hashCode() : 0;
        result = 31 * result + (this.publicKey != null ? this.publicKey.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.passPhrase);
        return result;
    }
}

