/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.remoteEdit.fs;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.jetbrains.plugins.webDeployment.ConnectionOwnerFactory;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.remoteEdit.FileContentQueue;
import com.jetbrains.plugins.webDeployment.remoteEdit.RemoteEditUploadFilesTask;
import com.jetbrains.plugins.webDeployment.remoteEdit.fs.RemoteVirtualFile;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
public final class RemoteEditedFilesUploadingService {
    private static final Logger LOG = Logger.getInstance(RemoteEditedFilesUploadingService.class);
    private final Project myProject;
    private final FileContentQueue myQueue = new FileContentQueue();
    private final Object TASK_LOCK = new Object();
    private RemoteEditUploadFilesTask myTask;

    @NotNull
    public static RemoteEditedFilesUploadingService getInstance(Project project) {
        RemoteEditedFilesUploadingService remoteEditedFilesUploadingService = (RemoteEditedFilesUploadingService)project.getService(RemoteEditedFilesUploadingService.class);
        if (remoteEditedFilesUploadingService == null) {
            RemoteEditedFilesUploadingService.$$$reportNull$$$0(0);
        }
        return remoteEditedFilesUploadingService;
    }

    public RemoteEditedFilesUploadingService(Project project) {
        this.myProject = project;
    }

    public void queueUpload(RemoteVirtualFile file) {
        try {
            byte[] content = file.contentsToByteArray();
            this.queueUpload(file, content);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueUpload(@NotNull RemoteVirtualFile file, byte @NotNull [] content) {
        if (file == null) {
            RemoteEditedFilesUploadingService.$$$reportNull$$$0(1);
        }
        if (content == null) {
            RemoteEditedFilesUploadingService.$$$reportNull$$$0(2);
        }
        this.myQueue.pushFile(file, content);
        Object object = this.TASK_LOCK;
        synchronized (object) {
            if (!this.myQueue.isEmpty() && (this.myTask == null || this.myTask.isFinished())) {
                this.myTask = new RemoteEditUploadFilesTask(this.myProject, ConnectionOwnerFactory.createConnectionOwner(this.myProject), WDBundle.message("remote.edit.uploading.edited.content.of.remote.files", new Object[0]), this.myQueue);
                this.myTask.queue();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/remoteEdit/fs/RemoteEditedFilesUploadingService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/remoteEdit/fs/RemoteEditedFilesUploadingService";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "queueUpload";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

