/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.actions.CompareLocalVsRemoteAction;
import com.jetbrains.plugins.webDeployment.actions.LoadFilesAction;
import com.jetbrains.plugins.webDeployment.actions.LocalVsRemoteActionBase;
import com.jetbrains.plugins.webDeployment.actions.PublishActionUtil;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerGroupingWrap;
import com.jetbrains.plugins.webDeployment.ui.LocalMappingDiffRoot;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class CompareLocalVsRemoteWithAction
extends CompareLocalVsRemoteAction {
    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            CompareLocalVsRemoteWithAction.$$$reportNull$$$0(0);
        }
        boolean enabled = true;
        VirtualFile[] files = PublishActionUtil.getVirtualFiles(e);
        if (files == null || files.length != 1 || files[0] == null || files[0].isDirectory()) {
            enabled = false;
        }
        if (enabled) {
            Collection<WebServerGroupingWrap> servers = LoadFilesAction.getExtraWraps(e, false, true, true);
            enabled = !servers.isEmpty();
        }
        e.getPresentation().setEnabled(enabled);
        if (e.isFromContextMenu()) {
            e.getPresentation().setVisible(enabled);
        }
    }

    @Override
    protected void actionPerformedOnProjectView(AnActionEvent event) {
        Project project = CompareLocalVsRemoteWithAction.getValidProject(event.getDataContext());
        if (project == null) {
            return;
        }
        VirtualFile[] files = PublishActionUtil.getVirtualFiles(event);
        if (files == null || files.length != 1 || files[0] == null || files[0].isDirectory()) {
            return;
        }
        Collection<WebServerGroupingWrap> wraps = LoadFilesAction.getExtraWraps(event, false, true, true);
        if (wraps.isEmpty()) {
            return;
        }
        PublishConfig publishConfig = PublishConfig.getInstance(project);
        VirtualFile file = files[0];
        PublishActionUtil.chooseServerFromWraps(publishConfig, wraps, event, WDBundle.message("choose.server.to.compare.with", new Object[0]), false).onSuccess(wrap -> {
            WebServerConfig server = wrap.getAsSingleServer();
            DeploymentPathMapping mapping = (DeploymentPathMapping)publishConfig.getNearestMappingForLocal(file.getPath(), false, true, false, server, true).getFirst();
            if (mapping == null || StringUtil.isEmpty((String)mapping.getDeployPath())) {
                return;
            }
            LocalVsRemoteActionBase.LocalData localData = new LocalVsRemoteActionBase.LocalData(project, Deployable.create(server, project), Collections.singletonList(LocalMappingDiffRoot.create(file, mapping)));
            this.createTask(localData).queue();
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/plugins/webDeployment/actions/CompareLocalVsRemoteWithAction", "update"));
    }
}

