/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import java.util.List;
import org.jrubyparser.NodeVisitor;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.ILocalVariable;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.IParameter;
import org.jrubyparser.ast.IScope;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptArgNode
extends Node
implements IParameter {
    private Node value;

    public OptArgNode(SourcePosition position, Node value) {
        super(position);
        this.value = this.adopt(value);
    }

    @Override
    public boolean isSame(Node node) {
        if (super.isSame(node)) {
            return false;
        }
        OptArgNode other = (OptArgNode)node;
        return this.isNameMatch(other.getName()) && this.getValue().isSame(other.getValue());
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.OPTARGNODE;
    }

    public Node getValue() {
        return this.value;
    }

    @Override
    public Object accept(NodeVisitor visitor) {
        return visitor.visitOptArgNode(this);
    }

    @Override
    public String getLexicalName() {
        return this.getName();
    }

    @Override
    public String getName() {
        if (this.value instanceof INameNode) {
            return ((INameNode)((Object)this.value)).getName();
        }
        return null;
    }

    @Override
    public void setName(String newName) {
        if (this.value instanceof INameNode) {
            ((INameNode)((Object)this.value)).setName(newName);
        }
    }

    @Override
    public boolean isNameMatch(String name) {
        String thisName = this.getName();
        return thisName != null && thisName.equals(name);
    }

    @Override
    public SourcePosition getNamePosition() {
        if (this.value instanceof INameNode) {
            return ((INameNode)((Object)this.value)).getNamePosition();
        }
        return this.getPosition();
    }

    @Override
    public SourcePosition getLexicalNamePosition() {
        return this.getNamePosition();
    }

    @Override
    public ILocalVariable getDeclaration() {
        return this;
    }

    @Override
    public List<ILocalVariable> getOccurrences() {
        return this.getDefinedScope().getVariableReferencesNamed(this.getName());
    }

    @Override
    public IScope getDefinedScope() {
        return this.getClosestIScope();
    }
}

