/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.scss.introduce;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssRulesetList;
import com.intellij.psi.css.CssSelectorList;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.scss.SASSSCSSLangUtil;
import org.jetbrains.plugins.scss.introduce.SassScssPlacingIntroduceVariableType;
import org.jetbrains.plugins.scss.psi.SassScssBlock;
import org.jetbrains.plugins.scss.psi.SassScssPropertyRuleset;
import org.jetbrains.plugins.scss.psi.SassScssRuleset;
import org.jetbrains.plugins.scss.psi.SassScssStatement;
import org.jetbrains.plugins.scss.psi.SassScssStylesheetFile;
import org.jetbrains.plugins.scss.psi.SassScssVariableDeclaration;
import org.jetbrains.plugins.scss.psi.SassScssVariableImpl;
import org.jetbrains.plugins.scss.references.SassScssVariableReference;

public final class SassScssPlacingVariableManager {
    @Nullable
    public static Pair<PsiElement, Boolean> getPlaceForDeclaration(@Nullable SassScssPlacingIntroduceVariableType placingType, PsiElement expression) {
        if (placingType == null) {
            return null;
        }
        return switch (placingType) {
            default -> throw new IncompatibleClassChangeError();
            case SassScssPlacingIntroduceVariableType.GLOBAL -> SassScssPlacingVariableManager.getGlobalPlaceForDeclaration(expression);
            case SassScssPlacingIntroduceVariableType.LOCAL -> SassScssPlacingVariableManager.getLocalPlaceForDeclaration(expression);
        };
    }

    @Nullable
    private static Pair<PsiElement, Boolean> getGlobalPlaceForDeclaration(PsiElement expression) {
        SassScssStylesheetFile file = (SassScssStylesheetFile)expression.getContainingFile();
        CssStylesheet stylesheet = file.getStylesheet();
        CssRulesetList rulesetList = stylesheet != null ? stylesheet.getRulesetList() : null;
        PsiElement targetDeclaration = null;
        if (rulesetList != null) {
            for (PsiElement child : rulesetList.getChildren()) {
                if (child instanceof SassScssVariableDeclaration) {
                    targetDeclaration = child;
                }
                if (SASSSCSSLangUtil.isValidScope(child)) break;
            }
        }
        if (targetDeclaration != null) {
            return new Pair(targetDeclaration, (Object)false);
        }
        if (rulesetList != null) {
            PsiElement[] children;
            for (PsiElement child : children = rulesetList.getChildren()) {
                if (child instanceof PsiComment || child instanceof PsiWhiteSpace) continue;
                return new Pair((Object)child, (Object)true);
            }
        }
        return null;
    }

    private static Pair<PsiElement, Boolean> getLocalPlaceForDeclaration(PsiElement expression) {
        PsiElement block = SassScssPlacingVariableManager.getParentBlock(expression);
        Collection variablesInExpression = PsiTreeUtil.findChildrenOfAnyType((PsiElement)expression, (Class[])new Class[]{SassScssVariableImpl.class});
        PsiElement anchor = null;
        for (SassScssVariableImpl variable : variablesInExpression) {
            PsiReference ref;
            PsiReference[] references = variable.getReferences();
            PsiReference psiReference = ref = references.length > 0 ? references[0] : null;
            if (!(ref instanceof SassScssVariableReference)) continue;
            for (ResolveResult result : ((SassScssVariableReference)ref).multiResolve(false)) {
                PsiElement element = result.getElement();
                if (!(element instanceof SassScssVariableDeclaration) || !PsiTreeUtil.isAncestor((PsiElement)block, (PsiElement)element, (boolean)false)) continue;
                PsiElement possibleAnchor = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{CssDeclaration.class, SassScssStatement.class, SassScssRuleset.class});
                if (possibleAnchor instanceof SassScssRuleset) {
                    possibleAnchor = PsiTreeUtil.getChildOfAnyType((PsiElement)possibleAnchor, (Class[])new Class[]{CssBlock.class, SassScssBlock.class});
                }
                if (possibleAnchor == null || anchor != null && anchor.getTextOffset() >= possibleAnchor.getTextOffset()) continue;
                anchor = possibleAnchor;
            }
        }
        CssSelectorList selectorList = (CssSelectorList)PsiTreeUtil.getParentOfType((PsiElement)expression, CssSelectorList.class);
        if (anchor == null && selectorList != null) {
            return new Pair((Object)block, (Object)true);
        }
        return new Pair(anchor != null ? anchor : PsiTreeUtil.findChildOfAnyType((PsiElement)block, (Class[])new Class[]{CssDeclaration.class, SassScssStatement.class, SassScssRuleset.class}), (Object)(anchor == null ? 1 : 0));
    }

    @Nullable
    private static PsiElement getParentBlock(PsiElement expression) {
        SassScssPropertyRuleset propertyRuleset = (SassScssPropertyRuleset)PsiTreeUtil.getTopmostParentOfType((PsiElement)expression, SassScssPropertyRuleset.class);
        return PsiTreeUtil.getParentOfType((PsiElement)(propertyRuleset != null ? propertyRuleset : expression), (Class[])new Class[]{PsiFile.class, CssBlock.class, SassScssBlock.class});
    }

    public static boolean variableExtractAvailable(SassScssPlacingIntroduceVariableType type, PsiElement expression, boolean replaceAll, List<PsiElement> occurrences) {
        if (type == null) {
            return false;
        }
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case SassScssPlacingIntroduceVariableType.GLOBAL -> SassScssPlacingVariableManager.globalExtractAvailable(expression);
            case SassScssPlacingIntroduceVariableType.LOCAL -> SassScssPlacingVariableManager.localExtractAvailable(expression, replaceAll, occurrences);
        };
    }

    private static boolean localExtractAvailable(PsiElement expression, boolean replaceAll, List<PsiElement> occurrences) {
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)expression, (Class[])new Class[]{CssBlock.class, SassScssBlock.class});
        if (!replaceAll) {
            return true;
        }
        for (PsiElement occurrence : occurrences) {
            boolean isAncestor = PsiTreeUtil.isAncestor((PsiElement)parent, (PsiElement)occurrence, (boolean)true);
            if (isAncestor) continue;
            return false;
        }
        return true;
    }

    private static boolean globalExtractAvailable(PsiElement expression) {
        Collection variablesInExpression = PsiTreeUtil.findChildrenOfAnyType((PsiElement)expression, (Class[])new Class[]{SassScssVariableImpl.class});
        for (SassScssVariableImpl variable : variablesInExpression) {
            PsiReference ref;
            PsiReference[] references = variable.getReferences();
            PsiReference psiReference = ref = references.length > 0 ? references[0] : null;
            if (!(ref instanceof SassScssVariableReference)) continue;
            for (ResolveResult result : ((SassScssVariableReference)ref).multiResolve(false)) {
                PsiElement element = result.getElement();
                if (!(element instanceof SassScssVariableDeclaration) || ((SassScssVariableDeclaration)element).isGlobal()) continue;
                return false;
            }
        }
        return true;
    }
}

