/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.visualization.r.inlays;

import com.intellij.notebooks.visualization.r.VisualizationBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JTable;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0018\u0019B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u00052\b\b\u0002\u0010\u000b\u001a\u00020\fH\u0002J\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u00052\b\b\u0002\u0010\u000b\u001a\u00020\fJ\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u0005J\u0018\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u0005J\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00012\b\b\u0002\u0010\n\u001a\u00020\u0005J\u000e\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/notebooks/visualization/r/inlays/ClipboardUtils;", "", "<init>", "()V", "LINE_BREAK", "", "CELL_BREAK", "copyAllToString", "table", "Ljavax/swing/JTable;", "cellBreak", "limit", "", "copyAllToClipboard", "", "copySelectedToString", "copySelectedToClipboard", "escape", "cell", "copyImageToClipboard", "image", "Ljava/awt/Image;", "copyPngImageToClipboard", "Ljava/awt/image/BufferedImage;", "FileTransferable", "ImageTransferable", "intellij.notebooks.visualization"})
@SourceDebugExtension(value={"SMAP\nClipboardUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClipboardUtils.kt\ncom/intellij/notebooks/visualization/r/inlays/ClipboardUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,158:1\n1#2:159\n*E\n"})
public final class ClipboardUtils {
    @NotNull
    public static final ClipboardUtils INSTANCE = new ClipboardUtils();
    @NotNull
    public static final String LINE_BREAK = "\r";
    @NotNull
    private static final String CELL_BREAK = "\t";

    private ClipboardUtils() {
    }

    private final String copyAllToString(JTable table, String cellBreak, int limit) {
        if (table.getRowCount() == 0 || table.getColumnCount() == 0) {
            Notifications.Bus.notify((Notification)new Notification("Notebook Table", VisualizationBundle.INSTANCE.message("clipboard.utils.error", new Object[0]), VisualizationBundle.INSTANCE.message("clipboard.utils.no.columns.or.rows", new Object[0]), NotificationType.ERROR));
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int n = table.getRowCount();
        for (int i = 0; i < n; ++i) {
            if (i >= limit) {
                Object[] objectArray = new Object[]{limit};
                builder.append("\n").append(VisualizationBundle.INSTANCE.message("clipboard.utils.copy.load.limit", objectArray));
                break;
            }
            int n2 = table.getColumnCount();
            for (int j = 0; j < n2; ++j) {
                if (table.getValueAt(i, j) != null) {
                    Object it;
                    boolean bl = false;
                    builder.append(INSTANCE.escape(it, cellBreak));
                }
                if (j >= table.getColumnCount() - 1) continue;
                builder.append(cellBreak);
            }
            if (i == table.getRowCount() - 1) continue;
            builder.append(LINE_BREAK);
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    static /* synthetic */ String copyAllToString$default(ClipboardUtils clipboardUtils, JTable jTable, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string = CELL_BREAK;
        }
        if ((n2 & 4) != 0) {
            n = Integer.MAX_VALUE;
        }
        return clipboardUtils.copyAllToString(jTable, string, n);
    }

    public final void copyAllToClipboard(@NotNull JTable table, @NotNull String cellBreak, int limit) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)cellBreak, (String)"cellBreak");
        StringSelection sel = new StringSelection(this.copyAllToString(table, cellBreak, limit));
        CopyPasteManager.getInstance().setContents((Transferable)sel);
    }

    public static /* synthetic */ void copyAllToClipboard$default(ClipboardUtils clipboardUtils, JTable jTable, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string = CELL_BREAK;
        }
        if ((n2 & 4) != 0) {
            n = Integer.MAX_VALUE;
        }
        clipboardUtils.copyAllToClipboard(jTable, string, n);
    }

    @NotNull
    public final String copySelectedToString(@NotNull JTable table, @NotNull String cellBreak) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)cellBreak, (String)"cellBreak");
        int selectedColumnCount = table.getSelectedColumnCount();
        int selectedRowCount = table.getSelectedRowCount();
        int[] selectedRows = table.getSelectedRows();
        int[] selectedColumns = table.getSelectedColumns();
        if (selectedColumnCount == 0 || selectedRowCount == 0) {
            Notifications.Bus.notify((Notification)new Notification("Notebook Table", VisualizationBundle.INSTANCE.message("clipboard.utils.error", new Object[0]), VisualizationBundle.INSTANCE.message("clipboard.utils.no.selection", new Object[0]), NotificationType.ERROR));
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < selectedRowCount; ++i) {
            for (int j = 0; j < selectedColumnCount; ++j) {
                if (table.getValueAt(selectedRows[i], selectedColumns[j]) != null) {
                    Object it;
                    boolean bl = false;
                    String cellString = selectedColumnCount > 1 ? INSTANCE.escape(it, cellBreak) : it.toString();
                    builder.append(cellString);
                }
                if (j >= selectedColumnCount - 1) continue;
                builder.append(cellBreak);
            }
            if (i == selectedRowCount - 1) continue;
            builder.append(LINE_BREAK);
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static /* synthetic */ String copySelectedToString$default(ClipboardUtils clipboardUtils, JTable jTable, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = CELL_BREAK;
        }
        return clipboardUtils.copySelectedToString(jTable, string);
    }

    public final void copySelectedToClipboard(@NotNull JTable table, @NotNull String cellBreak) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)cellBreak, (String)"cellBreak");
        StringSelection sel = new StringSelection(this.copySelectedToString(table, cellBreak));
        CopyPasteManager.getInstance().setContents((Transferable)sel);
    }

    public static /* synthetic */ void copySelectedToClipboard$default(ClipboardUtils clipboardUtils, JTable jTable, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = CELL_BREAK;
        }
        clipboardUtils.copySelectedToClipboard(jTable, string);
    }

    @NotNull
    public final String escape(@NotNull Object cell, @NotNull String cellBreak) {
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        Intrinsics.checkNotNullParameter((Object)cellBreak, (String)"cellBreak");
        String cellString = cell.toString();
        return StringsKt.contains$default((CharSequence)cellString, (CharSequence)LINE_BREAK, (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)cellString, (CharSequence)cellBreak, (boolean)false, (int)2, null) ? "\"" + StringUtil.escapeQuotes((String)cellString) + "\"" : cellString;
    }

    public static /* synthetic */ String escape$default(ClipboardUtils clipboardUtils, Object object, String string, int n, Object object2) {
        if ((n & 2) != 0) {
            string = CELL_BREAK;
        }
        return clipboardUtils.escape(object, string);
    }

    public final void copyImageToClipboard(@NotNull Image image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        CopyPasteManager.getInstance().setContents((Transferable)new ImageTransferable(image));
    }

    public final void copyPngImageToClipboard(@NotNull BufferedImage image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        File file = FileUtil.createTempFile((String)"clipboard", (String)".png");
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempFile(...)");
        File tempImage = file;
        ImageIO.write((RenderedImage)image, "png", tempImage);
        CopyPasteManager.getInstance().setContents((Transferable)new FileTransferable(CollectionsKt.listOf((Object)tempImage)));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0013\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tH\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\r\u001a\u00020\tH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/notebooks/visualization/r/inlays/ClipboardUtils$FileTransferable;", "Ljava/awt/datatransfer/Transferable;", "files", "", "Ljava/io/File;", "<init>", "(Ljava/util/List;)V", "getTransferDataFlavors", "", "Ljava/awt/datatransfer/DataFlavor;", "()[Ljava/awt/datatransfer/DataFlavor;", "isDataFlavorSupported", "", "flavor", "getTransferData", "intellij.notebooks.visualization"})
    private static final class FileTransferable
    implements Transferable {
        @NotNull
        private final List<File> files;

        public FileTransferable(@NotNull List<? extends File> files) {
            Intrinsics.checkNotNullParameter(files, (String)"files");
            this.files = files;
        }

        @Override
        @NotNull
        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] dataFlavorArray = new DataFlavor[]{DataFlavor.javaFileListFlavor};
            return dataFlavorArray;
        }

        @Override
        public boolean isDataFlavorSupported(@NotNull DataFlavor flavor) {
            Intrinsics.checkNotNullParameter((Object)flavor, (String)"flavor");
            return DataFlavor.javaFileListFlavor.equals(flavor);
        }

        @Override
        @NotNull
        public List<File> getTransferData(@NotNull DataFlavor flavor) {
            Intrinsics.checkNotNullParameter((Object)flavor, (String)"flavor");
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.files;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0013\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/notebooks/visualization/r/inlays/ClipboardUtils$ImageTransferable;", "Ljava/awt/datatransfer/Transferable;", "image", "Ljava/awt/Image;", "<init>", "(Ljava/awt/Image;)V", "getTransferDataFlavors", "", "Ljava/awt/datatransfer/DataFlavor;", "()[Ljava/awt/datatransfer/DataFlavor;", "isDataFlavorSupported", "", "flavor", "getTransferData", "", "intellij.notebooks.visualization"})
    private static final class ImageTransferable
    implements Transferable {
        @NotNull
        private final Image image;

        public ImageTransferable(@NotNull Image image) {
            Intrinsics.checkNotNullParameter((Object)image, (String)"image");
            this.image = image;
        }

        @Override
        @NotNull
        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] dataFlavorArray = new DataFlavor[]{DataFlavor.imageFlavor};
            return dataFlavorArray;
        }

        @Override
        public boolean isDataFlavorSupported(@NotNull DataFlavor flavor) {
            Intrinsics.checkNotNullParameter((Object)flavor, (String)"flavor");
            return Intrinsics.areEqual((Object)flavor, (Object)DataFlavor.imageFlavor);
        }

        @Override
        @NotNull
        public Object getTransferData(@NotNull DataFlavor flavor) {
            Intrinsics.checkNotNullParameter((Object)flavor, (String)"flavor");
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.image;
        }
    }
}

