/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.packages.celery.ref;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.TreeElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ProcessingContext;
import com.jetbrains.django.ref.DjangoItemFilter;
import com.jetbrains.django.ref.DjangoItemReference;
import com.jetbrains.django.ref.DjangoItemReferenceSet;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0002\u000e\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/python/django/packages/celery/ref/CeleryBeatScheduleReferenceProvider;", "Lcom/intellij/psi/PsiReferenceProvider;", "<init>", "()V", "getReferencesByElement", "", "Lcom/intellij/psi/PsiReference;", "element", "Lcom/intellij/psi/PsiElement;", "context", "Lcom/intellij/util/ProcessingContext;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/util/ProcessingContext;)[Lcom/intellij/psi/PsiReference;", "inBeatSchedule", "", "PyStringLiteralEquals", "CeleryBeatScheduleReferenceSet", "intellij.python.django"})
public final class CeleryBeatScheduleReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.inBeatSchedule(element)) {
            DjangoItemFilter djangoItemFilter = DjangoItemFilter.CLASSES_AND_FUNCTIONS;
            Intrinsics.checkNotNullExpressionValue((Object)djangoItemFilter, (String)"CLASSES_AND_FUNCTIONS");
            PsiReference[] psiReferenceArray = new CeleryBeatScheduleReferenceSet(element, djangoItemFilter).getAllReferences();
            Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"getAllReferences(...)");
            return psiReferenceArray;
        }
        Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
        return PsiReference.EMPTY_ARRAY;
    }

    private final boolean inBeatSchedule(PsiElement element) {
        if (!Registry.Companion.is("django.celery.enabled", false)) {
            return false;
        }
        TreeElementPattern treeElementPattern = ((PsiElementPattern.Capture)PlatformPatterns.psiElement(PyStringLiteralExpression.class).afterLeafSkipping((ElementPattern)PlatformPatterns.psiElement(PsiWhiteSpace.class), (ElementPattern)PlatformPatterns.psiElement((IElementType)((IElementType)PyTokenTypes.COLON)))).withParent((ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement(PyKeyValueExpression.class).withFirstChild((ElementPattern)PlatformPatterns.psiElement(PyStringLiteralExpression.class).with((PatternCondition)new PyStringLiteralEquals("task")))).withParent((ElementPattern)PlatformPatterns.psiElement(PyDictLiteralExpression.class).withParent((ElementPattern)PlatformPatterns.psiElement(PyKeyValueExpression.class).withParent((ElementPattern)PlatformPatterns.psiElement(PyDictLiteralExpression.class).withParent((ElementPattern)PlatformPatterns.psiElement(PyAssignmentStatement.class).withChild((ElementPattern)PlatformPatterns.psiElement(PyTargetExpression.class).withName("CELERY_BEAT_SCHEDULE")))))));
        Intrinsics.checkNotNullExpressionValue((Object)treeElementPattern, (String)"withParent(...)");
        PsiElementPattern.Capture pattern = (PsiElementPattern.Capture)treeElementPattern;
        return pattern.accepts((Object)element);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0012B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014\u00a8\u0006\u0013"}, d2={"Lcom/intellij/python/django/packages/celery/ref/CeleryBeatScheduleReferenceProvider$CeleryBeatScheduleReferenceSet;", "Lcom/jetbrains/django/ref/DjangoItemReferenceSet;", "element", "Lcom/intellij/psi/PsiElement;", "filter", "Lcom/jetbrains/django/ref/DjangoItemFilter;", "<init>", "(Lcom/intellij/psi/PsiElement;Lcom/jetbrains/django/ref/DjangoItemFilter;)V", "createDjangoReference", "Lcom/jetbrains/django/ref/DjangoItemReference;", "range", "Lcom/intellij/openapi/util/TextRange;", "index", "", "subreferenceText", "", "isLast", "", "CeleryBeatScheduleReference", "intellij.python.django"})
    public static final class CeleryBeatScheduleReferenceSet
    extends DjangoItemReferenceSet {
        public CeleryBeatScheduleReferenceSet(@NotNull PsiElement element, @NotNull DjangoItemFilter filter) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
            super(element, filter);
        }

        @NotNull
        protected DjangoItemReference createDjangoReference(@NotNull TextRange range, int index, @NotNull String subreferenceText, boolean isLast) {
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Intrinsics.checkNotNullParameter((Object)subreferenceText, (String)"subreferenceText");
            return new CeleryBeatScheduleReference(range, index, subreferenceText);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0080\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/python/django/packages/celery/ref/CeleryBeatScheduleReferenceProvider$CeleryBeatScheduleReferenceSet$CeleryBeatScheduleReference;", "Lcom/jetbrains/django/ref/DjangoItemReference;", "range", "Lcom/intellij/openapi/util/TextRange;", "index", "", "subreferenceText", "", "<init>", "(Lcom/intellij/python/django/packages/celery/ref/CeleryBeatScheduleReferenceProvider$CeleryBeatScheduleReferenceSet;Lcom/intellij/openapi/util/TextRange;ILjava/lang/String;)V", "intellij.python.django"})
        public final class CeleryBeatScheduleReference
        extends DjangoItemReference {
            public CeleryBeatScheduleReference(TextRange range, @NotNull int index, String subreferenceText) {
                Intrinsics.checkNotNullParameter((Object)range, (String)"range");
                Intrinsics.checkNotNullParameter((Object)subreferenceText, (String)"subreferenceText");
                super((DjangoItemReferenceSet)CeleryBeatScheduleReferenceSet.this, range, index, subreferenceText);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/python/django/packages/celery/ref/CeleryBeatScheduleReferenceProvider$PyStringLiteralEquals;", "Lcom/intellij/patterns/PatternCondition;", "Lcom/jetbrains/python/psi/PyStringLiteralExpression;", "stringValue", "", "<init>", "(Ljava/lang/String;)V", "accepts", "", "t", "context", "Lcom/intellij/util/ProcessingContext;", "intellij.python.django"})
    private static final class PyStringLiteralEquals
    extends PatternCondition<PyStringLiteralExpression> {
        @NotNull
        private final String stringValue;

        public PyStringLiteralEquals(@NotNull String stringValue) {
            Intrinsics.checkNotNullParameter((Object)stringValue, (String)"stringValue");
            super("pyStringEquals");
            this.stringValue = stringValue;
        }

        public boolean accepts(@NotNull PyStringLiteralExpression t, @Nullable ProcessingContext context) {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            return Intrinsics.areEqual((Object)t.getStringValue(), (Object)this.stringValue);
        }
    }
}

