/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.packages.celery.ref;

import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.django.ui.DjangoBundle;
import com.jetbrains.python.codeInsight.imports.AddImportHelper;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\r\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/python/django/packages/celery/ref/CeleryBeatScheduleFunctionSharedTaskQuickFix;", "Lcom/intellij/modcommand/PsiUpdateModCommandQuickFix;", "functionToFix", "Lcom/jetbrains/python/psi/PyFunction;", "<init>", "(Lcom/jetbrains/python/psi/PyFunction;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "element", "Lcom/intellij/psi/PsiElement;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "getFamilyName", "", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "intellij.python.django"})
public final class CeleryBeatScheduleFunctionSharedTaskQuickFix
extends PsiUpdateModCommandQuickFix {
    @NotNull
    private final PyFunction functionToFix;

    public CeleryBeatScheduleFunctionSharedTaskQuickFix(@NotNull PyFunction functionToFix) {
        Intrinsics.checkNotNullParameter((Object)functionToFix, (String)"functionToFix");
        this.functionToFix = functionToFix;
    }

    protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        if (!Registry.Companion.is("django.celery.enabled")) {
            return;
        }
        PyFunction functionToFixWritable = (PyFunction)updater.getWritable((PsiElement)this.functionToFix);
        PyUtil.addDecorator((PyFunction)functionToFixWritable, (String)"@shared_task");
        AddImportHelper.addOrUpdateFromImportStatement((PsiFile)functionToFixWritable.getContainingFile(), (String)"celery", (String)"shared_task", null, (AddImportHelper.ImportPriority)AddImportHelper.ImportPriority.THIRD_PARTY, null);
        updater.moveCaretTo((PsiElement)functionToFixWritable);
    }

    @NotNull
    public String getFamilyName() {
        String string = DjangoBundle.message((String)"celery.unregistered-shared-task-function.quickfix", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }
}

