/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dataWrangler.core.statistics;

import com.intellij.dataWrangler.core.statistics.CoreStatisticsHeaderKt;
import com.intellij.dataWrangler.core.statistics.model.CoreStatisticsHeaderDataProvider;
import com.intellij.dataWrangler.core.statistics.view.CoreStatisticsTableHeaderPanel;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.run.ui.table.TableResultView;
import com.intellij.database.run.ui.table.statisticsPanel.StatisticsPanelMode;
import com.intellij.database.run.ui.table.statisticsPanel.StatisticsTableHeader;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0016"}, d2={"Lcom/intellij/dataWrangler/core/statistics/CoreStatisticsHeader;", "", "table", "Lcom/intellij/database/run/ui/table/TableResultView;", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "<init>", "(Lcom/intellij/database/run/ui/table/TableResultView;Lcom/intellij/database/datagrid/DataGrid;)V", "getTable", "()Lcom/intellij/database/run/ui/table/TableResultView;", "dataProvider", "Lcom/intellij/dataWrangler/core/statistics/model/CoreStatisticsHeaderDataProvider;", "getDataProvider", "()Lcom/intellij/dataWrangler/core/statistics/model/CoreStatisticsHeaderDataProvider;", "headerPanel", "Lcom/intellij/dataWrangler/core/statistics/view/CoreStatisticsTableHeaderPanel;", "getHeaderPanel", "()Lcom/intellij/dataWrangler/core/statistics/view/CoreStatisticsTableHeaderPanel;", "setMode", "", "mode", "Lcom/intellij/database/run/ui/table/statisticsPanel/StatisticsPanelMode;", "intellij.dataWrangler.core"})
public final class CoreStatisticsHeader {
    @NotNull
    private final TableResultView table;
    @NotNull
    private final CoreStatisticsHeaderDataProvider dataProvider;
    @NotNull
    private final CoreStatisticsTableHeaderPanel headerPanel;

    public CoreStatisticsHeader(@NotNull TableResultView table, @NotNull DataGrid grid) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        this.table = table;
        this.dataProvider = new CoreStatisticsHeaderDataProvider(grid);
        CoroutineScope coroutineScope = grid.getCoroutineScope();
        Intrinsics.checkNotNullExpressionValue((Object)coroutineScope, (String)"getCoroutineScope(...)");
        this.headerPanel = new CoreStatisticsTableHeaderPanel(this.table, this.dataProvider, coroutineScope);
        this.table.setStatisticsHeader((StatisticsTableHeader)this.headerPanel);
        grid.putUserData(CoreStatisticsHeaderKt.CORE_STATISTICS_HEADER_KEY, (Object)this);
    }

    @NotNull
    public final TableResultView getTable() {
        return this.table;
    }

    @NotNull
    public final CoreStatisticsHeaderDataProvider getDataProvider() {
        return this.dataProvider;
    }

    @NotNull
    public final CoreStatisticsTableHeaderPanel getHeaderPanel() {
        return this.headerPanel;
    }

    public final void setMode(@NotNull StatisticsPanelMode mode) {
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        this.table.setStatisticsPanelMode(mode);
    }
}

