/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/vcs/changes/patch/PatchDateParser;", "", "<init>", "()V", "dateRegex", "Lkotlin/text/Regex;", "parseVersionAsDate", "Ljava/util/Date;", "versionId", "", "intellij.platform.vcs.impl"})
public final class PatchDateParser {
    @NotNull
    public static final PatchDateParser INSTANCE = new PatchDateParser();
    @NotNull
    private static final Regex dateRegex = new Regex("\\(date ([0-9]+)\\)");

    private PatchDateParser() {
    }

    @JvmStatic
    @Nullable
    public static final Date parseVersionAsDate(@NotNull String versionId) {
        Date date;
        Intrinsics.checkNotNullParameter((Object)versionId, (String)"versionId");
        try {
            Date date2;
            MatchResult tsMatcher = dateRegex.matchEntire((CharSequence)versionId);
            if (tsMatcher != null) {
                Object e = tsMatcher.getGroupValues().get(1);
                Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                long fromTsPattern = Long.parseLong((String)e);
                date2 = new Date(fromTsPattern);
            } else {
                date2 = new Date(versionId);
            }
            date = date2;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            date = null;
        }
        return date;
    }
}

