/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.util.ui.OptionsDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

class VcsConfirmationDialog
extends OptionsDialog {
    @NotNull
    @NlsContexts.Button
    private final String myOkText;
    @NotNull
    @NlsContexts.Button
    private final String myCancelText;
    private final VcsShowConfirmationOption myOption;
    private final @NlsContexts.Label String myMessage;
    private final @NlsContexts.Checkbox String myDoNotShowMessage;

    VcsConfirmationDialog(@NotNull Project project, @NotNull @NlsContexts.DialogTitle String title, @NotNull @NlsContexts.Button String okText, @NotNull @NlsContexts.Button String cancelText, @NotNull VcsShowConfirmationOption option, @NotNull @NlsContexts.Label String message, @NotNull @NlsContexts.Checkbox String doNotShowMessage) {
        if (project == null) {
            VcsConfirmationDialog.$$$reportNull$$$0(0);
        }
        if (title == null) {
            VcsConfirmationDialog.$$$reportNull$$$0(1);
        }
        if (okText == null) {
            VcsConfirmationDialog.$$$reportNull$$$0(2);
        }
        if (cancelText == null) {
            VcsConfirmationDialog.$$$reportNull$$$0(3);
        }
        if (option == null) {
            VcsConfirmationDialog.$$$reportNull$$$0(4);
        }
        if (message == null) {
            VcsConfirmationDialog.$$$reportNull$$$0(5);
        }
        if (doNotShowMessage == null) {
            VcsConfirmationDialog.$$$reportNull$$$0(6);
        }
        super(project);
        this.myOkText = okText;
        this.myCancelText = cancelText;
        this.myOption = option;
        this.myMessage = message;
        this.myDoNotShowMessage = doNotShowMessage;
        this.setTitle(title);
        this.init();
    }

    protected boolean isToBeShown() {
        return this.myOption.getValue() == VcsShowConfirmationOption.Value.SHOW_CONFIRMATION;
    }

    protected void setToBeShown(boolean value, boolean onOk) {
        this.myOption.setValue(value ? VcsShowConfirmationOption.Value.SHOW_CONFIRMATION : (onOk ? VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY : VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY));
    }

    protected boolean shouldSaveOptionsOnCancel() {
        return true;
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout(15, 0));
        panel.add(new JLabel(this.myMessage));
        panel.add((Component)new JLabel(Messages.getQuestionIcon()), "West");
        return panel;
    }

    @NotNull
    protected String getDoNotShowMessage() {
        String string = this.myDoNotShowMessage;
        if (string == null) {
            VcsConfirmationDialog.$$$reportNull$$$0(7);
        }
        return string;
    }

    protected Action @NotNull [] createActions() {
        Action[] actionArray;
        AbstractAction okAction = new AbstractAction(this.myOkText){
            {
                this.putValue("DefaultAction", Boolean.TRUE);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                VcsConfirmationDialog.this.doOKAction();
            }
        };
        AbstractAction cancelAction = new AbstractAction(this.myCancelText){

            @Override
            public void actionPerformed(ActionEvent e) {
                VcsConfirmationDialog.this.doCancelAction();
            }
        };
        if (SystemInfo.isMac) {
            Action[] actionArray2 = new Action[2];
            actionArray2[0] = cancelAction;
            actionArray = actionArray2;
            actionArray2[1] = okAction;
        } else {
            Action[] actionArray3 = new Action[2];
            actionArray3[0] = okAction;
            actionArray = actionArray3;
            actionArray3[1] = cancelAction;
        }
        if (actionArray == null) {
            VcsConfirmationDialog.$$$reportNull$$$0(8);
        }
        return actionArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "okText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cancelText";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doNotShowMessage";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/VcsConfirmationDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/VcsConfirmationDialog";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDoNotShowMessage";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8 -> new IllegalStateException(string);
        };
    }
}

