/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.actions;

import com.intellij.jupyter.core.jupyter.actions.JupyterEditorActionBase;
import com.intellij.jupyter.core.jupyter.editor.actions.JupyterSelectAllCellsActionHandlerKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterDataContextExtensionsKt;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.context.NotebookDataContext;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.TextRange;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/jupyter/core/jupyter/actions/JupyterSelectSourceAction;", "Lcom/intellij/jupyter/core/jupyter/actions/JupyterEditorActionBase;", "Lcom/intellij/openapi/actionSystem/remoting/ActionRemoteBehaviorSpecification$Frontend;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.jupyter.core"})
public final class JupyterSelectSourceAction
extends JupyterEditorActionBase
implements ActionRemoteBehaviorSpecification.Frontend {
    private JupyterSelectSourceAction() {
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        EditorImpl editorImpl = JupyterDataContextExtensionsKt.getJupyterEditor(dataContext);
        if (editorImpl == null) {
            return;
        }
        EditorImpl editor = editorImpl;
        boolean wasHandled = JupyterSelectAllCellsActionHandlerKt.selectAllCellsInCommandMode((Editor)editor);
        if (!wasHandled) {
            DataContext dataContext2 = e.getDataContext();
            Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
            NotebookCellLines.Interval interval = NotebookDataContext.INSTANCE.getSelectedCellInterval(dataContext2);
            if (interval == null) {
                return;
            }
            NotebookCellLines.Interval cellInterval = interval;
            TextRange cellRange = cellInterval.getContentRange((Editor)editor);
            Pair pair = editor.getSelectionModel().getSelectionStart() == cellRange.getStartOffset() && editor.getSelectionModel().getSelectionEnd() == cellRange.getEndOffset() ? TuplesKt.to((Object)0, (Object)editor.getDocument().getTextLength()) : TuplesKt.to((Object)cellRange.getStartOffset(), (Object)cellRange.getEndOffset());
            int selectionStart = ((Number)pair.component1()).intValue();
            int selectionEnd = ((Number)pair.component2()).intValue();
            CommandProcessor.getInstance().executeCommand(e.getProject(), () -> JupyterSelectSourceAction.actionPerformed$lambda$0(editor, selectionStart, selectionEnd), e.getPresentation().getText(), null);
        }
    }

    private static final void actionPerformed$lambda$0(EditorImpl $editor, int $selectionStart, int $selectionEnd) {
        $editor.getSelectionModel().setSelection($selectionStart, $selectionEnd);
    }
}

