/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dataFlow.CursorState;
import com.intellij.sql.dataFlow.FlowUtilKt;
import com.intellij.sql.dataFlow.instructions.SqlCursorInstruction;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlIllegalCursorStateInspection;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlCreateProcedureStatement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlRoutineDefinition;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006\u000f"}, d2={"Lcom/intellij/sql/inspections/SqlIllegalCursorStateInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "<init>", "()V", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "result", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "", "intellij.database.sql.impl"})
public final class SqlIllegalCursorStateInspection
extends SqlInspectionBase {
    @Override
    @NotNull
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result2, onTheFly){
            final /* synthetic */ boolean $onTheFly;
            {
                this.$onTheFly = $onTheFly;
                super($manager, $dialect, (Collection<ProblemDescriptor>)$result);
            }

            public void visitSqlCreateProcedureStatement(SqlCreateProcedureStatement o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                this.visitSqlRoutineDefinition((SqlRoutineDefinition)o);
            }

            public void visitSqlRoutineDefinition(SqlRoutineDefinition o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                FlowUtilKt.computeCursorStates(FlowUtilKt.buildFlowGraph(o)).forEach((arg_0, arg_1) -> createAnnotationVisitor.1.visitSqlRoutineDefinition$lambda$1((arg_0, arg_1) -> createAnnotationVisitor.1.visitSqlRoutineDefinition$lambda$0(this, this.$onTheFly, arg_0, arg_1), arg_0, arg_1));
            }

            private static final Unit visitSqlRoutineDefinition$lambda$0(createAnnotationVisitor.1 this$0, boolean $onTheFly, SqlCursorInstruction instruction, Set states) {
                Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
                Intrinsics.checkNotNullParameter((Object)states, (String)"states");
                ProgressManager.checkCanceled();
                SqlReferenceExpression sqlReferenceExpression = instruction.getReference();
                if (sqlReferenceExpression == null) {
                    return Unit.INSTANCE;
                }
                SqlReferenceExpression source = sqlReferenceExpression;
                String problem = null;
                switch (createAnnotationVisitor.WhenMappings.$EnumSwitchMapping$0[instruction.getOp().ordinal()]) {
                    case 1: {
                        if (!states.contains((Object)((Object)CursorState.OPEN))) break;
                        problem = SqlBundle.message((String)"inspection.message.cursor.might.not.have.been.closed", (Object[])new Object[0]);
                        break;
                    }
                    case 2: {
                        if (!states.contains((Object)((Object)CursorState.CLOSE))) break;
                        problem = SqlBundle.message((String)"inspection.message.cursor.might.not.have.been.open", (Object[])new Object[0]);
                        break;
                    }
                    case 3: {
                        if (!states.contains((Object)((Object)CursorState.CLOSE))) break;
                        problem = SqlBundle.message((String)"inspection.message.cursor.might.not.have.been.open", (Object[])new Object[0]);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                if (problem != null) {
                    this$0.addDescriptor(this$0.myManager.createProblemDescriptor((PsiElement)source, problem, true, ProblemHighlightType.WARNING, $onTheFly, new LocalQuickFix[0]));
                }
                return Unit.INSTANCE;
            }

            private static final void visitSqlRoutineDefinition$lambda$1(Function2 $tmp0, Object p0, Object p1) {
                $tmp0.invoke(p0, p1);
            }
        };
    }
}

