/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter;

import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.FormattingModel;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.lineIndent.LineIndentProvider;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.sql.SqlUtilFun;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.formatter.SqlFormattingModelBuilder;
import com.intellij.sql.formatter.SqlLineIndentProviderKt;
import com.intellij.sql.formatter.model.AdjacentBlocks;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlLeafBlock;
import com.intellij.sql.formatter.model.SqlRootBlock;
import com.intellij.sql.formatter.settings.SqlCodeStyles;
import com.intellij.sql.psi.SqlFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/sql/formatter/SqlLineIndentProvider;", "Lcom/intellij/psi/codeStyle/lineIndent/LineIndentProvider;", "<init>", "()V", "getLineIndent", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "language", "Lcom/intellij/lang/Language;", "offset", "", "isSuitableFor", "", "intellij.database.sql.core.impl"})
public final class SqlLineIndentProvider
implements LineIndentProvider {
    @Nullable
    public String getLineIndent(@NotNull Project project, @NotNull Editor editor2, @Nullable Language language, int offset) {
        PsiFile psiFile;
        FileViewProvider viewProvider;
        PsiFile psiFile2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        documentManager.commitDocument(document2);
        VirtualFile virtualFile = editor2.getVirtualFile();
        PsiFile psiFile3 = psiFile2 = documentManager.getPsiFile(document2);
        Object object = viewProvider = psiFile3 != null ? psiFile3.getViewProvider() : null;
        if (viewProvider instanceof TemplateLanguageFileViewProvider) {
            psiFile2 = ((TemplateLanguageFileViewProvider)viewProvider).getPsi(((TemplateLanguageFileViewProvider)viewProvider).getTemplateDataLanguage());
        }
        SqlFile sqlFile = (psiFile = psiFile2) instanceof SqlFile ? (SqlFile)psiFile : null;
        if (sqlFile == null) {
            return "";
        }
        SqlFile file = sqlFile;
        psiFile = virtualFile != null ? SqlCodeStyles.getSqlSettings((Project)project, (VirtualFile)editor2.getVirtualFile()) : SqlCodeStyles.getSqlSettings((PsiFile)((PsiFile)file));
        Intrinsics.checkNotNull((Object)psiFile);
        PsiFile settings = psiFile;
        if (settings.DISABLE_FORMATTING) {
            return LineIndentProvider.DO_NOT_ADJUST;
        }
        int length = document2.getTextLength();
        TextRange interestingTextRange = new TextRange(SqlUtilFun.fitInto(offset - 1, new IntRange(0, length)), SqlUtilFun.fitInto(offset + 1, new IntRange(0, length)));
        FormattingModel formattingModel = SqlFormattingModelBuilder.makeModel((PsiElement)file, FormattingMode.ADJUST_INDENT_ON_ENTER, document2, interestingTextRange, null);
        Intrinsics.checkNotNullExpressionValue((Object)formattingModel, (String)"makeModel(...)");
        FormattingModel model = formattingModel;
        Block block = model.getRootBlock();
        SqlRootBlock sqlRootBlock = block instanceof SqlRootBlock ? (SqlRootBlock)block : null;
        if (sqlRootBlock == null) {
            return LineIndentProvider.DO_NOT_ADJUST;
        }
        SqlRootBlock rootBlock = sqlRootBlock;
        AdjacentBlocks enclosedBlocks = SqlLineIndentProviderKt.access$findEnclosingBlocks(rootBlock, offset);
        SqlBlock parentBlock = (enclosedBlocks = SqlLineIndentProviderKt.access$adjustEnclosingBlocks(enclosedBlocks)).getParent();
        if (parentBlock == null) {
            return LineIndentProvider.DO_NOT_ADJUST;
        }
        if (enclosedBlocks.getSame() && enclosedBlocks.getBlock1() instanceof SqlLeafBlock) {
            return SqlLineIndentProviderKt.access$getLineIndentInsideLeaf(enclosedBlocks, offset);
        }
        String indent = parentBlock.getNewLineIndent(enclosedBlocks);
        return indent;
    }

    public boolean isSuitableFor(@Nullable Language language) {
        return language instanceof SqlLanguageDialect;
    }
}

