/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.codeInsight.daemon.impl.ErrorStripeUpdateManager;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.SearchPath;
import com.intellij.database.view.DatabaseDialogsHelper;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.EditorTextField;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlPreviewComponent {
    private final EditorTextField myPreviewEditor;
    private final EventDispatcher<OpenInConsoleListener> myDispatcher;
    private final DasDataSource myDataSource;
    private final List<Pair<RangeMarker, String>> myErrors;
    private final List<RangeHighlighter> myHighlighters;

    public SqlPreviewComponent(@NotNull Project project, @NotNull DasDataSource dataSource, @Nullable SearchPath searchPath, @NotNull String query, boolean isViewer) {
        if (project == null) {
            SqlPreviewComponent.$$$reportNull$$$0(0);
        }
        if (dataSource == null) {
            SqlPreviewComponent.$$$reportNull$$$0(1);
        }
        if (query == null) {
            SqlPreviewComponent.$$$reportNull$$$0(2);
        }
        this.myDispatcher = EventDispatcher.create(OpenInConsoleListener.class);
        this.myErrors = new ArrayList<Pair<RangeMarker, String>>();
        this.myHighlighters = new ArrayList<RangeHighlighter>();
        this.myDataSource = dataSource;
        this.myPreviewEditor = DatabaseDialogsHelper.createLanguageEditorArea(project, this.myDataSource, searchPath, "", isViewer);
        this.myPreviewEditor.addSettingsProvider(editor2 -> {
            ((EditorMarkupModel)editor2.getMarkupModel()).setErrorStripeVisible(true);
            ErrorStripeUpdateManager.getInstance((Project)project).launchRepaintErrorStripePanel(List.of(editor2), false);
        });
        this.setQuery(query);
    }

    @NotNull
    public DasDataSource getDataSource() {
        DasDataSource dasDataSource = this.myDataSource;
        if (dasDataSource == null) {
            SqlPreviewComponent.$$$reportNull$$$0(3);
        }
        return dasDataSource;
    }

    private void updateHighlighting(@NotNull MarkupModelEx mm) {
        if (mm == null) {
            SqlPreviewComponent.$$$reportNull$$$0(4);
        }
        this.clearHighlighting(mm);
        for (Pair<RangeMarker, String> error : this.myErrors) {
            HighlightInfo info2 = SqlPreviewComponent.createHighlightInfo((String)error.second, ((RangeMarker)error.first).getTextRange());
            this.myHighlighters.add((RangeHighlighter)SqlPreviewComponent.registerHighlighter(mm, info2));
        }
    }

    @NotNull
    private static HighlightInfo createHighlightInfo(@Nls @NotNull String error, @NotNull TextRange rg) {
        if (error == null) {
            SqlPreviewComponent.$$$reportNull$$$0(5);
        }
        if (rg == null) {
            SqlPreviewComponent.$$$reportNull$$$0(6);
        }
        HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(rg).descriptionAndTooltip(error).createUnconditionally();
        if (highlightInfo == null) {
            SqlPreviewComponent.$$$reportNull$$$0(7);
        }
        return highlightInfo;
    }

    @NotNull
    private static RangeHighlighterEx registerHighlighter(@NotNull MarkupModelEx mm, @NotNull HighlightInfo info2) {
        if (mm == null) {
            SqlPreviewComponent.$$$reportNull$$$0(8);
        }
        if (info2 == null) {
            SqlPreviewComponent.$$$reportNull$$$0(9);
        }
        RangeHighlighterEx highlighter = mm.addRangeHighlighterAndChangeAttributes(info2.type.getAttributesKey(), info2.startOffset, info2.endOffset, 4000, HighlighterTargetArea.EXACT_RANGE, false, rh -> rh.setErrorStripeTooltip((Object)info2));
        info2.setHighlighter(highlighter);
        RangeHighlighterEx rangeHighlighterEx = highlighter;
        if (rangeHighlighterEx == null) {
            SqlPreviewComponent.$$$reportNull$$$0(10);
        }
        return rangeHighlighterEx;
    }

    private void clearHighlighting(@NotNull MarkupModelEx mm) {
        if (mm == null) {
            SqlPreviewComponent.$$$reportNull$$$0(11);
        }
        for (RangeHighlighter highlighter : this.myHighlighters) {
            mm.removeHighlighter(highlighter);
        }
        this.myHighlighters.clear();
    }

    public SqlPreviewComponent(@NotNull Project project, @NotNull DasDataSource dataSource, @Nullable SearchPath searchPath, @NotNull String query, boolean isViewer, @NotNull Runnable closeDialog) {
        if (project == null) {
            SqlPreviewComponent.$$$reportNull$$$0(12);
        }
        if (dataSource == null) {
            SqlPreviewComponent.$$$reportNull$$$0(13);
        }
        if (query == null) {
            SqlPreviewComponent.$$$reportNull$$$0(14);
        }
        if (closeDialog == null) {
            SqlPreviewComponent.$$$reportNull$$$0(15);
        }
        this(project, dataSource, searchPath, query, isViewer);
        this.subscribeOpenInConsole(closeDialog::run);
    }

    public JComponent createToolbar() {
        ClientProperty.put((JComponent)this.myPreviewEditor, (Key)ActionUtil.ALLOW_ACTION_PERFORM_WHEN_HIDDEN, (Object)true);
        JComponent open = DbUIUtil.createToolbar(new DefaultActionGroup(this.createActions(this.myDataSource)), (JComponent)this.myPreviewEditor);
        ((ActionToolbarImpl)open).setMiniMode(true);
        return open;
    }

    public void subscribeOpenInConsole(@NotNull OpenInConsoleListener listener2) {
        if (listener2 == null) {
            SqlPreviewComponent.$$$reportNull$$$0(16);
        }
        this.myDispatcher.addListener((EventListener)listener2);
    }

    public EditorTextField getEditor() {
        return this.myPreviewEditor;
    }

    @NotNull
    public List<AnAction> createActions(@NotNull DasDataSource delegate) {
        LocalDataSource dataSource;
        if (delegate == null) {
            SqlPreviewComponent.$$$reportNull$$$0(17);
        }
        if ((dataSource = (LocalDataSource)ObjectUtils.tryCast((Object)delegate, LocalDataSource.class)) == null) {
            return new ArrayList<AnAction>();
        }
        List<1> list = List.of(new DumbAwareAction(DatabaseBundle.messagePointer("action.SqlPreviewPanel.open.query.in.console.text", new Object[0]), AllIcons.Actions.MoveTo2){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                String query = SqlPreviewComponent.this.getQuery();
                if (DbUIUtil.openInConsole(SqlPreviewComponent.this.myPreviewEditor.getProject(), dataSource, null, query, true) == null) {
                    DbUIUtil.openInConsole(SqlPreviewComponent.this.myPreviewEditor.getProject(), dataSource, null, query, false);
                }
                ((OpenInConsoleListener)SqlPreviewComponent.this.myDispatcher.getMulticaster()).open();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/view/ui/SqlPreviewComponent$1", "actionPerformed"));
            }
        });
        if (list == null) {
            SqlPreviewComponent.$$$reportNull$$$0(18);
        }
        return list;
    }

    @NotNull
    public String getQuery() {
        String string = this.myPreviewEditor.getText();
        if (string == null) {
            SqlPreviewComponent.$$$reportNull$$$0(19);
        }
        return string;
    }

    public void setQuery(@NotNull CompositeText query) {
        if (query == null) {
            SqlPreviewComponent.$$$reportNull$$$0(20);
        }
        this.setQueryInner(query.getText().toString());
        this.clearErrors();
        this.myErrors.addAll(SqlPreviewComponent.extractErrors(this.myPreviewEditor.getDocument(), query));
        this.updateHighlighting();
    }

    @NotNull
    private static List<Pair<RangeMarker, String>> extractErrors(@NotNull Document document, @NotNull CompositeText query) {
        if (document == null) {
            SqlPreviewComponent.$$$reportNull$$$0(21);
        }
        if (query == null) {
            SqlPreviewComponent.$$$reportNull$$$0(22);
        }
        ArrayList<Pair<RangeMarker, String>> errors = new ArrayList<Pair<RangeMarker, String>>();
        for (CompositeText.Fragment fragment : query.getFragments()) {
            if (fragment.getError() == null) continue;
            RangeMarker marker = document.createRangeMarker(SqlPreviewComponent.shrink(fragment));
            errors.add((Pair<RangeMarker, String>)Pair.create((Object)marker, (Object)fragment.getError()));
        }
        ArrayList<Pair<RangeMarker, String>> arrayList = errors;
        if (arrayList == null) {
            SqlPreviewComponent.$$$reportNull$$$0(23);
        }
        return arrayList;
    }

    @NotNull
    private static TextRange shrink(@NotNull CompositeText.Fragment fragment) {
        int eo;
        if (fragment == null) {
            SqlPreviewComponent.$$$reportNull$$$0(24);
        }
        CharSequence text2 = fragment.getText();
        int bo = 0;
        if (StringUtil.startsWith((CharSequence)text2, (CharSequence)"--")) {
            bo += 2;
        }
        while (bo < text2.length() && Character.isWhitespace(text2.charAt(bo))) {
            ++bo;
        }
        for (eo = 0; eo < text2.length() && Character.isWhitespace(text2.charAt(text2.length() - 1 - eo)); ++eo) {
        }
        TextRange textRange = TextRange.create((int)(fragment.getBegin() + bo), (int)(fragment.getEnd() - eo));
        if (textRange == null) {
            SqlPreviewComponent.$$$reportNull$$$0(25);
        }
        return textRange;
    }

    public void setQuery(@NotNull String query) {
        if (query == null) {
            SqlPreviewComponent.$$$reportNull$$$0(26);
        }
        this.setQueryInner(query);
        this.clearErrors();
        this.updateHighlighting();
    }

    private void clearErrors() {
        for (Pair<RangeMarker, String> error : this.myErrors) {
            ((RangeMarker)error.first).dispose();
        }
        this.myErrors.clear();
    }

    private void setQueryInner(@NotNull String query) {
        if (query == null) {
            SqlPreviewComponent.$$$reportNull$$$0(27);
        }
        this.myPreviewEditor.setText(query);
        this.myPreviewEditor.setCaretPosition(0);
        UiNotifyConnector.doWhenFirstShown((JComponent)this.myPreviewEditor, this::scrollToStart);
    }

    private void updateHighlighting() {
        MarkupModel markupModel = DocumentMarkupModel.forDocument((Document)this.myPreviewEditor.getDocument(), (Project)this.getEditor().getProject(), (boolean)true);
        this.updateHighlighting((MarkupModelEx)markupModel);
    }

    private void scrollToStart() {
        Editor editor2 = this.myPreviewEditor.getEditor();
        if (editor2 == null) {
            return;
        }
        ScrollingModel model = editor2.getScrollingModel();
        model.disableAnimation();
        model.scrollVertically(0);
        model.enableAnimation();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 7, 10, 18, 19, 23, 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: 
            case 14: 
            case 20: 
            case 22: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 18: 
            case 19: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ui/SqlPreviewComponent";
                break;
            }
            case 4: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mm";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rg";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closeDialog";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ui/SqlPreviewComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSource";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createHighlightInfo";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "registerHighlighter";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuery";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "extractErrors";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "shrink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 18: 
            case 19: 
            case 23: 
            case 25: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateHighlighting";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createHighlightInfo";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "registerHighlighter";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "clearHighlighting";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "subscribeOpenInConsole";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createActions";
                break;
            }
            case 20: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "setQuery";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "extractErrors";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "shrink";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "setQueryInner";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 7, 10, 18, 19, 23, 25 -> new IllegalStateException(string);
        };
    }

    public static interface OpenInConsoleListener
    extends EventListener {
        public void open();
    }
}

