/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.SizeProvider;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.JdbcColumnDescriptor;
import com.intellij.database.extractors.ImageInfo;
import com.intellij.database.extractors.ObjectFormatterUtil;
import com.intellij.database.extractors.TextInfo;
import com.intellij.database.remote.jdbc.LobInfo;
import com.intellij.database.remote.jdbc.impl.BitString;
import com.intellij.database.util.JdbcUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbObjectFormatterUtil
extends ObjectFormatterUtil {
    private static final int H2_DEFAULT_SCALE = Short.MAX_VALUE;
    private static final int H2_DEFAULT_PRECISION = 65535;

    private DbObjectFormatterUtil() {
    }

    public static boolean isMsHierarchyid(@NotNull Dbms dbms, @Nullable GridColumn column2) {
        if (dbms == null) {
            DbObjectFormatterUtil.$$$reportNull$$$0(0);
        }
        return dbms.in(Dbms.MSSQL_LIKE) && column2 != null && "hierarchyid".equals(column2.getTypeName());
    }

    public static boolean isClickhouseUInt8Array(@NotNull Dbms dbms, @Nullable GridColumn column2) {
        if (dbms == null) {
            DbObjectFormatterUtil.$$$reportNull$$$0(1);
        }
        return dbms.is(Dbms.CLICKHOUSE) && column2 != null && "Array(UInt8)".equals(column2.getTypeName());
    }

    public static boolean isHstore(@NotNull GridColumn column2) {
        DataConsumer.Column c2;
        if (column2 == null) {
            DbObjectFormatterUtil.$$$reportNull$$$0(2);
        }
        return (c2 = (DataConsumer.Column)ObjectUtils.tryCast((Object)column2, DataConsumer.Column.class)) != null && "hstore".equals(column2.getTypeName()) && "java.util.Map".equals(c2.getJavaClassName());
    }

    public static boolean isPostgresRangeType(@NotNull GridColumn column2) {
        if (column2 == null) {
            DbObjectFormatterUtil.$$$reportNull$$$0(3);
        }
        return StringUtil.findIgnoreCase((String)column2.getTypeName(), (String[])new String[]{"int4range", "int8range", "numrange", "tsrange", "tstzrange", "daterange"});
    }

    @NotNull
    public static String bitsToString(@NotNull BitString string, @NotNull GridColumn column2) {
        int precision;
        if (string == null) {
            DbObjectFormatterUtil.$$$reportNull$$$0(4);
        }
        if (column2 == null) {
            DbObjectFormatterUtil.$$$reportNull$$$0(5);
        }
        long length = string.getLength();
        byte[] bytes2 = string.getBytes();
        StringBuilder sb = new StringBuilder();
        int j = 0;
        while ((long)j < length) {
            byte b = bytes2[j / 8];
            sb.append((b & 128 >>> j % 8) != 0 ? (char)'1' : '0');
            ++j;
        }
        int n = precision = column2 instanceof SizeProvider ? ((SizeProvider)column2).getSize() : -1;
        while (sb.length() > precision && !sb.isEmpty() && sb.charAt(0) == '0') {
            sb.delete(0, 1);
        }
        String string2 = sb.toString();
        if (string2 == null) {
            DbObjectFormatterUtil.$$$reportNull$$$0(6);
        }
        return string2;
    }

    @Nullable
    public static Object unwrap(@Nullable Object o) {
        if (o instanceof LobInfo.ClobInfo) {
            return ((LobInfo.ClobInfo)o).data;
        }
        if (o instanceof LobInfo.BlobInfo) {
            return ((LobInfo.BlobInfo)o).data;
        }
        if (o instanceof TextInfo) {
            return ((TextInfo)o).bytes;
        }
        if (o instanceof ImageInfo) {
            return ((ImageInfo)o).bytes;
        }
        return o;
    }

    public static boolean isFloatingPoint(@NotNull GridColumn column2) {
        if (column2 == null) {
            DbObjectFormatterUtil.$$$reportNull$$$0(7);
        }
        String className = column2 instanceof JdbcColumnDescriptor ? ((JdbcColumnDescriptor)column2).getJavaClassName() : null;
        return JdbcUtil.isFloat(className) || JdbcUtil.isDouble(className);
    }

    public static boolean isBitString(@NotNull GridColumn column2) {
        if (column2 == null) {
            DbObjectFormatterUtil.$$$reportNull$$$0(8);
        }
        if (!(column2 instanceof DataConsumer.Column)) {
            return false;
        }
        DataConsumer.Column c2 = (DataConsumer.Column)column2;
        return c2.getSize() > 1 && DbObjectFormatterUtil.isBit((String)c2.getTypeName(), (int)c2.getType());
    }

    public static boolean isH2DecimalWithUnspecifiedPrecision(@NotNull GridColumn column2) {
        if (column2 == null) {
            DbObjectFormatterUtil.$$$reportNull$$$0(9);
        }
        if (!(column2 instanceof DataConsumer.Column)) {
            return false;
        }
        DataConsumer.Column c2 = (DataConsumer.Column)column2;
        return "DECIMAL".equals(column2.getTypeName()) && 65535 == c2.getSize() && Short.MAX_VALUE == c2.getScale();
    }

    @Nullable
    private static Boolean parseBoolean(@NotNull String value) {
        if (value == null) {
            DbObjectFormatterUtil.$$$reportNull$$$0(10);
        }
        return StringUtil.findIgnoreCase((String)value, (String[])new String[]{"1", "true"}) ? Boolean.TRUE : (StringUtil.findIgnoreCase((String)value, (String[])new String[]{"0", "false"}) ? Boolean.FALSE : null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/extractors/DbObjectFormatterUtil";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/extractors/DbObjectFormatterUtil";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "bitsToString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isMsHierarchyid";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isClickhouseUInt8Array";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isHstore";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isPostgresRangeType";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "bitsToString";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isFloatingPoint";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isBitString";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isH2DecimalWithUnspecifiedPrecision";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parseBoolean";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

