/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.editor;

import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridAppearance;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridFilteringModel;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.extractors.DisplayType;
import com.intellij.database.run.ui.TableResultPanel;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.project.Project;
import java.util.Collections;
import java.util.Map;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorTableResultPanel
extends TableResultPanel {
    private Map<String, InitialColumnProperties> myInitialColumnProperties;

    public EditorTableResultPanel(@NotNull Project project, @NotNull GridDataHookUp<GridRow, GridColumn> hookUp, @NotNull BiConsumer<DataGrid, DataGridAppearance> configurator) {
        if (project == null) {
            EditorTableResultPanel.$$$reportNull$$$0(0);
        }
        if (hookUp == null) {
            EditorTableResultPanel.$$$reportNull$$$0(1);
        }
        if (configurator == null) {
            EditorTableResultPanel.$$$reportNull$$$0(2);
        }
        super(project, hookUp, DataGridUtil.getGridDatabasePopupActions(), configurator);
        this.myInitialColumnProperties = Collections.emptyMap();
    }

    protected void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            EditorTableResultPanel.$$$reportNull$$$0(3);
        }
        super.uiDataSnapshot(sink);
        DataGridUtil.uiDataSnapshot(sink, (DataGrid)this);
    }

    public void setIgnoreCurrentFilterText(boolean value) {
        GridFilteringModel model = this.getDataHookup().getFilteringModel();
        if (model != null) {
            model.setIgnoreCurrentText(value);
        }
    }

    protected boolean isInitiallyDisabled(@NotNull GridColumn column2) {
        if (column2 == null) {
            EditorTableResultPanel.$$$reportNull$$$0(4);
        }
        if (super.isInitiallyDisabled(column2)) {
            return true;
        }
        InitialColumnProperties properties2 = this.myInitialColumnProperties != null ? this.myInitialColumnProperties.get(column2.getName()) : null;
        return properties2 != null && !properties2.enabled;
    }

    protected Language getInitialContentLanguage(@NotNull GridColumn column2) {
        if (column2 == null) {
            EditorTableResultPanel.$$$reportNull$$$0(5);
        }
        if (this.myInitialColumnProperties == null) {
            return super.getInitialContentLanguage(column2);
        }
        InitialColumnProperties properties2 = this.myInitialColumnProperties.get(column2.getName());
        Language fromInitialProperties = properties2 != null ? properties2.language : Language.ANY;
        return fromInitialProperties == Language.ANY ? super.getInitialContentLanguage(column2) : fromInitialProperties;
    }

    protected int getInitialPosition(@NotNull GridColumn column2) {
        if (column2 == null) {
            EditorTableResultPanel.$$$reportNull$$$0(6);
        }
        if (this.myInitialColumnProperties == null) {
            return super.getInitialPosition(column2);
        }
        InitialColumnProperties properties2 = this.myInitialColumnProperties.get(column2.getName());
        return properties2 != null ? properties2.position : super.getInitialPosition(column2);
    }

    @Nullable
    protected DisplayType getInitialDisplayType(@NotNull GridColumn column2) {
        if (column2 == null) {
            EditorTableResultPanel.$$$reportNull$$$0(7);
        }
        if (this.myInitialColumnProperties == null) {
            return null;
        }
        InitialColumnProperties properties2 = this.myInitialColumnProperties.get(column2.getName());
        return properties2 != null ? properties2.displayType : null;
    }

    void setInitialColumnProperties(@NotNull Map<String, InitialColumnProperties> properties2) {
        if (properties2 == null) {
            EditorTableResultPanel.$$$reportNull$$$0(8);
        }
        this.myInitialColumnProperties = properties2;
        this.columnAttributesUpdated();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hookUp";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/editor/EditorTableResultPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "uiDataSnapshot";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isInitiallyDisabled";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getInitialContentLanguage";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getInitialPosition";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getInitialDisplayType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "setInitialColumnProperties";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class InitialColumnProperties {
        public final boolean enabled;
        public final Language language;
        public final int position;
        public final DisplayType displayType;

        InitialColumnProperties(boolean enabled, @NotNull Language language, int position, DisplayType displayType) {
            if (language == null) {
                InitialColumnProperties.$$$reportNull$$$0(0);
            }
            this.enabled = enabled;
            this.language = language;
            this.position = position;
            this.displayType = displayType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/database/editor/EditorTableResultPanel$InitialColumnProperties", "<init>"));
        }
    }
}

