/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.editor;

import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridAppearance;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DbGridDataHookUpUtil;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.objects.DasGridDataHookUp;
import com.intellij.database.editor.TableFileEditor;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ModalityUiUtil;
import org.jetbrains.annotations.NotNull;

public class DasGridFileEditor
extends TableFileEditor {
    private final DataGrid myDataGrid;

    public DasGridFileEditor(@NotNull Project project, @NotNull DatabaseElementVirtualFileImpl file) {
        if (project == null) {
            DasGridFileEditor.$$$reportNull$$$0(0);
        }
        if (file == null) {
            DasGridFileEditor.$$$reportNull$$$0(1);
        }
        super(project, (VirtualFile)file);
        this.myDataGrid = this.createDataGrid(DbGridDataHookUpUtil.getFamilyHookUp(project, file, (Disposable)this));
        DataGridUtil.addGridHeaderComponent(this.myDataGrid, file);
        String dsId = file.getDataSourceId();
        DataSourceStorage storage = DataSourceStorage.getProjectStorage(project);
        LocalDataSource dataSource = storage.getDataSourceById(dsId);
        if (dataSource != null) {
            storage.getLoadingPromise(dataSource).onProcessed(o -> ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> this.getHookup().getLoader().reloadCurrentPage(new GridRequestSource(null))));
        }
    }

    protected void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            DasGridFileEditor.$$$reportNull$$$0(2);
        }
        super.uiDataSnapshot(sink);
        DataGridUtil.uiDataSnapshot(sink, this.myDataGrid);
    }

    @NotNull
    public DataGrid getDataGrid() {
        DataGrid dataGrid = this.myDataGrid;
        if (dataGrid == null) {
            DasGridFileEditor.$$$reportNull$$$0(3);
        }
        return dataGrid;
    }

    @NotNull
    private DasGridDataHookUp getHookup() {
        DasGridDataHookUp dasGridDataHookUp = (DasGridDataHookUp)this.myDataGrid.getDataHookup();
        if (dasGridDataHookUp == null) {
            DasGridFileEditor.$$$reportNull$$$0(4);
        }
        return dasGridDataHookUp;
    }

    protected void configure(@NotNull DataGrid grid, @NotNull DataGridAppearance appearance) {
        if (grid == null) {
            DasGridFileEditor.$$$reportNull$$$0(5);
        }
        if (appearance == null) {
            DasGridFileEditor.$$$reportNull$$$0(6);
        }
        DataGridUtil.configure(grid, appearance);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/editor/DasGridFileEditor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appearance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/editor/DasGridFileEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataGrid";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getHookup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "uiDataSnapshot";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "configure";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

