/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.sqlite;

import com.intellij.database.dialects.base.SqlObjectBuilderImpl;
import com.intellij.database.dialects.sqlite.model.SqliteCheck;
import com.intellij.database.dialects.sqlite.model.SqliteCollation;
import com.intellij.database.dialects.sqlite.model.SqliteIndex;
import com.intellij.database.dialects.sqlite.model.SqliteKey;
import com.intellij.database.dialects.sqlite.model.SqliteRoot;
import com.intellij.database.dialects.sqlite.model.SqliteTable;
import com.intellij.database.dialects.sqlite.model.SqliteTableColumn;
import com.intellij.database.dialects.sqlite.model.SqliteTrigger;
import com.intellij.database.dialects.sqlite.model.SqliteVirtualTable;
import com.intellij.database.dialects.sqlite.model.properties.SqliteOnConflictAlgorithm;
import com.intellij.database.dialects.sqlite.sql.SqliteTypes;
import com.intellij.database.model.DasNamed;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.SqlObjectBuilder;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.TrigTurn;
import com.intellij.database.model.basic.BasicDataObject;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModIndex;
import com.intellij.database.model.basic.BasicModKey;
import com.intellij.database.model.basic.BasicModLikeCheck;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.model.basic.BasicModTrigger;
import com.intellij.database.model.basic.BasicModView;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.properties.ColumnKind;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.model.properties.references.BasicNameReference;
import com.intellij.database.util.ObjectPath;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlConstraintDefinition;
import com.intellij.sql.psi.SqlCreateIndexStatement;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlCreateTableStatement;
import com.intellij.sql.psi.SqlCreateTriggerStatement;
import com.intellij.sql.psi.SqlCreateViewStatement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.SqlTableDefinition;
import com.intellij.sql.psi.SqlTableKeyDefinition;
import com.intellij.sql.psi.SqlWhenClause;
import com.intellij.sql.psi.SqlWhereClause;
import com.intellij.sql.psi.impl.SqlConditionDefinition;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.stubs.SqlDefinitionStub;
import com.intellij.sql.psi.stubs.SqlStubbedElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00cc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J$\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J \u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J \u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J \u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u001b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u001d2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0006\u001a\u00020 H\u0002J \u0010!\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\"2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010#\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020$2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J \u0010%\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020&2\u0006\u0010\b\u001a\u00020'2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010(\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020)2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J \u0010*\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020+2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u0010,\u001a\u00020\u001f2\u0006\u0010-\u001a\u00020.H\u0002J \u0010/\u001a\u0004\u0018\u0001002\b\u00101\u001a\u0004\u0018\u0001002\n\u00102\u001a\u0006\u0012\u0002\b\u000303H\u0002J1\u00104\u001a\u0004\u0018\u0001H5\"\b\b\u0000\u00105*\u0002062\b\u00101\u001a\u0004\u0018\u0001002\f\u00102\u001a\b\u0012\u0004\u0012\u0002H503H\u0002\u00a2\u0006\u0002\u00107J\u0018\u00108\u001a\n\u0012\u0004\u0012\u000200\u0018\u0001092\u0006\u0010:\u001a\u00020;H\u0002J\u0012\u0010<\u001a\u0004\u0018\u00010=2\u0006\u0010>\u001a\u00020?H\u0002J\u0012\u0010@\u001a\u0004\u0018\u00010A2\u0006\u0010>\u001a\u00020?H\u0002J\u0014\u0010B\u001a\u0004\u0018\u00010;2\b\u0010:\u001a\u0004\u0018\u00010;H\u0002J\u0014\u0010C\u001a\u0004\u0018\u00010D2\b\u0010\u0012\u001a\u0004\u0018\u00010;H\u0002\u00a8\u0006E"}, d2={"Lcom/intellij/database/dialects/sqlite/SqliteObjectBuilder;", "Lcom/intellij/database/dialects/base/SqlObjectBuilderImpl;", "<init>", "()V", "build", "", "obj", "Lcom/intellij/database/model/basic/BasicModElement;", "source", "Lcom/intellij/database/model/DasObject;", "context", "Lcom/intellij/database/model/SqlObjectBuilder$Context;", "getCompactDefinition", "Lcom/intellij/openapi/util/TextRange;", "path", "Lcom/intellij/database/util/ObjectPath;", "text", "Lcom/intellij/database/model/properties/CompositeText;", "def", "Lcom/intellij/database/model/PsiObject;", "buildTable", "Lcom/intellij/database/dialects/sqlite/model/SqliteTable;", "buildViewSource", "Lcom/intellij/database/model/basic/BasicModView;", "buildCheck", "Lcom/intellij/database/model/basic/BasicModLikeCheck;", "buildCheckFromConstraintDefinition", "Lcom/intellij/database/dialects/sqlite/model/SqliteCheck;", "buildColumn", "Lcom/intellij/database/dialects/sqlite/model/SqliteTableColumn;", "isIdentity", "", "Lcom/intellij/sql/psi/SqlColumnDefinition;", "buildVirtualTable", "Lcom/intellij/database/dialects/sqlite/model/SqliteVirtualTable;", "buildKey", "Lcom/intellij/database/model/basic/BasicModKey;", "buildKeyFromTableKeyDefinition", "Lcom/intellij/database/dialects/sqlite/model/SqliteKey;", "Lcom/intellij/sql/psi/SqlTableKeyDefinition;", "buildTrigger", "Lcom/intellij/database/model/basic/BasicModTrigger;", "buildIndex", "Lcom/intellij/database/model/basic/BasicModIndex;", "isDesc", "expr", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "fixName", "", "name", "src", "Lcom/intellij/database/model/families/Family;", "findObject", "T", "Lcom/intellij/database/model/basic/BasicElement;", "(Ljava/lang/String;Lcom/intellij/database/model/families/Family;)Lcom/intellij/database/model/basic/BasicElement;", "getColumns", "", "el", "Lcom/intellij/psi/PsiElement;", "getEvent", "Lcom/intellij/database/model/TrigEvent;", "type", "Lcom/intellij/psi/tree/IElementType;", "getTurn", "Lcom/intellij/database/model/TrigTurn;", "skipUnsignificant", "getConflictResolution", "Lcom/intellij/database/dialects/sqlite/model/properties/SqliteOnConflictAlgorithm;", "intellij.database.dialects.sqlite"})
@SourceDebugExtension(value={"SMAP\nSqliteObjectBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqliteObjectBuilder.kt\ncom/intellij/database/dialects/sqlite/SqliteObjectBuilder\n+ 2 SqlObjectBuilderImpl.kt\ncom/intellij/database/dialects/base/SqlObjectBuilderImpl\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,312:1\n625#2,5:313\n614#2,10:318\n625#2,5:328\n625#2,5:333\n614#2,10:338\n644#2:349\n660#2,6:350\n625#2,5:356\n644#2:361\n660#2,6:362\n644#2:368\n660#2,6:369\n625#2,5:379\n625#2,5:384\n625#2,5:389\n1#3:348\n11158#4:375\n11493#4,3:376\n11158#4:396\n11493#4,3:397\n1310#4,2:400\n295#5,2:394\n*S KotlinDebug\n*F\n+ 1 SqliteObjectBuilder.kt\ncom/intellij/database/dialects/sqlite/SqliteObjectBuilder\n*L\n49#1:313,5\n56#1:318,10\n78#1:328,5\n89#1:333,5\n100#1:338,10\n134#1:349\n134#1:350,6\n143#1:356,5\n149#1:361\n149#1:362,6\n150#1:368\n150#1:369,6\n167#1:379,5\n177#1:384,5\n226#1:389,5\n152#1:375\n152#1:376,3\n283#1:396\n283#1:397,3\n308#1:400,2\n278#1:394,2\n*E\n"})
public final class SqliteObjectBuilder
extends SqlObjectBuilderImpl {
    @Override
    public void build(@NotNull BasicModElement obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BasicModElement basicModElement = obj2;
        if (basicModElement instanceof SqliteTable) {
            this.buildTable((SqliteTable)obj2, source, context);
        } else if (basicModElement instanceof SqliteTableColumn) {
            this.buildColumn((SqliteTableColumn)obj2, source, context);
        } else if (basicModElement instanceof SqliteVirtualTable) {
            this.buildVirtualTable((SqliteVirtualTable)obj2, source, context);
        } else if (basicModElement instanceof SqliteTrigger) {
            this.buildTrigger((BasicModTrigger)obj2, source, context);
        } else {
            super.build(obj2, source, context);
        }
    }

    @Override
    @Nullable
    public TextRange getCompactDefinition(@NotNull ObjectPath path, @NotNull CompositeText text2, @Nullable PsiObject def) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        ObjectKind objectKind = path.kind;
        return Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.VIEW) ? this.getViewQueryRange(def) : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.TRIGGER) ? this.getTriggerBodyRange(def) : super.getCompactDefinition(path, text2, def));
    }

    /*
     * WARNING - void declaration
     */
    private final void buildTable(SqliteTable obj2, DasObject source, SqlObjectBuilder.Context context) {
        SqliteTable stubbed;
        BasicElement basicElement;
        if (!context.isIntrospector()) {
            this.buildBasicElement(obj2, source, context);
        }
        SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
        DasObject $this$stubbed$iv = source;
        boolean $i$f$stubbed2 = false;
        DasObject dasObject = $this$stubbed$iv;
        if (dasObject instanceof SqliteTable) {
            basicElement = (BasicElement)$this$stubbed$iv;
        } else if (dasObject instanceof SqlStubbedElement) {
            StubElement stubElement = ((SqlStubbedElement)((Object)$this$stubbed$iv)).getGreenStub();
            SqlDefinitionStub sqlDefinitionStub = stubElement instanceof SqlDefinitionStub ? (SqlDefinitionStub)stubElement : null;
            BasicElement basicElement2 = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(basicElement2 instanceof SqliteTable)) {
                basicElement2 = null;
            }
            basicElement = (SqliteTable)basicElement2;
        } else {
            basicElement = null;
        }
        if ((stubbed = (SqliteTable)basicElement) != null) {
            obj2.setWithoutRowId(stubbed.isWithoutRowId());
        } else {
            void this_$iv;
            boolean withoutRowId = false;
            boolean strict = false;
            SqlObjectBuilderImpl $i$f$stubbed2 = this;
            PsiElement el$iv = (PsiElement)(source instanceof SqlCreateTableStatement ? (SqlCreateTableStatement)source : null);
            boolean $i$f$forEachChild = false;
            void var10_14 = this_$iv;
            PsiElement psiElement = el$iv;
            PsiElement first$iv$iv = psiElement != null ? psiElement.getFirstChild() : null;
            boolean $i$f$forEachSibling = false;
            for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement it = tmp$iv$iv;
                boolean bl = false;
                IElementType iElementType = PsiTreeUtilKt.getElementType((PsiElement)it);
                if (Intrinsics.areEqual((Object)iElementType, (Object)SqliteTypes.SQLITE_WITHOUT_ROWID_CLAUSE)) {
                    withoutRowId = true;
                    continue;
                }
                if (!Intrinsics.areEqual((Object)iElementType, (Object)SqliteTypes.SQLITE_STRICT)) continue;
                strict = true;
            }
            obj2.setWithoutRowId(withoutRowId);
            obj2.setStrict(strict);
        }
    }

    @Override
    protected void buildViewSource(@NotNull BasicModView obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.assignSources(obj2, context, (Function0<? extends CompositeText>)((Function0)() -> SqliteObjectBuilder.buildViewSource$lambda$1(source, this)));
    }

    @Override
    protected void buildCheck(@NotNull BasicModLikeCheck obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(obj2 instanceof SqliteCheck)) {
            super.buildCheck(obj2, source, context);
            return;
        }
        this.buildCheckFromConstraintDefinition((SqliteCheck)obj2, source, context);
    }

    private final void buildCheckFromConstraintDefinition(SqliteCheck obj2, DasObject source, SqlObjectBuilder.Context context) {
        SqliteCheck stubbed;
        BasicElement basicElement;
        if (!context.isIntrospector()) {
            super.buildCheck(obj2, source, context);
        }
        SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
        DasObject $this$stubbed$iv = source;
        boolean $i$f$stubbed = false;
        DasObject dasObject = $this$stubbed$iv;
        if (dasObject instanceof SqliteCheck) {
            basicElement = (BasicElement)$this$stubbed$iv;
        } else if (dasObject instanceof SqlStubbedElement) {
            StubElement stubElement = ((SqlStubbedElement)((Object)$this$stubbed$iv)).getGreenStub();
            SqlDefinitionStub sqlDefinitionStub = stubElement instanceof SqlDefinitionStub ? (SqlDefinitionStub)stubElement : null;
            BasicElement basicElement2 = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(basicElement2 instanceof SqliteCheck)) {
                basicElement2 = null;
            }
            basicElement = (SqliteCheck)basicElement2;
        } else {
            basicElement = null;
        }
        SqliteCheck sqliteCheck = stubbed = (SqliteCheck)basicElement;
        obj2.setOnConflict(sqliteCheck != null ? sqliteCheck.getOnConflict() : this.getConflictResolution((PsiElement)(source instanceof SqlConditionDefinition ? (SqlConditionDefinition)((Object)source) : null)));
    }

    /*
     * WARNING - void declaration
     */
    private final void buildColumn(SqliteTableColumn obj2, DasObject source, SqlObjectBuilder.Context context) {
        String defaultExpression;
        block16: {
            Object object;
            SqliteTableColumn sqliteTableColumn;
            block18: {
                String collationName;
                block17: {
                    void it;
                    void it2;
                    void this_$iv;
                    Object object2;
                    Object object3;
                    block15: {
                        SqliteTableColumn stubbed;
                        BasicElement basicElement;
                        this.buildTypedType(obj2, source, context);
                        if (!context.isIntrospector()) {
                            this.buildTypedNotNull(obj2, source, context);
                            this.buildArranged(obj2, source, context);
                        }
                        defaultExpression = null;
                        SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
                        DasObject $this$stubbed$iv = source;
                        boolean $i$f$stubbed = false;
                        object3 = $this$stubbed$iv;
                        if (object3 instanceof SqliteTableColumn) {
                            basicElement = (BasicElement)$this$stubbed$iv;
                        } else if (object3 instanceof SqlStubbedElement) {
                            object2 = ((SqlStubbedElement)((Object)$this$stubbed$iv)).getGreenStub();
                            SqlDefinitionStub sqlDefinitionStub = object2 instanceof SqlDefinitionStub ? (SqlDefinitionStub)((Object)object2) : null;
                            BasicElement basicElement2 = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
                            if (!(basicElement2 instanceof SqliteTableColumn)) {
                                basicElement2 = null;
                            }
                            basicElement = (SqliteTableColumn)basicElement2;
                        } else {
                            basicElement = null;
                        }
                        if ((stubbed = (SqliteTableColumn)basicElement) == null) break block15;
                        obj2.setCollationRef(stubbed.getCollationRef());
                        obj2.setSequenceIdentity(stubbed.getSequenceIdentity());
                        obj2.setColumnKind(stubbed.getColumnKind());
                        defaultExpression = stubbed.getDefaultExpression();
                        break block16;
                    }
                    collationName = null;
                    SqliteOnConflictAlgorithm conflictResolution = null;
                    ColumnKind columnKind = null;
                    columnKind = ColumnKind.NORMAL;
                    object3 = this;
                    PsiElement el$iv = (PsiElement)(source instanceof SqlColumnDefinition ? (SqlColumnDefinition)source : null);
                    boolean $i$f$forEachChild22 = false;
                    void var12_14 = this_$iv;
                    PsiElement psiElement = el$iv;
                    Object first$iv$iv = psiElement != null ? psiElement.getFirstChild() : null;
                    boolean $i$f$forEachSibling = false;
                    for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                        PsiElement it3 = tmp$iv$iv;
                        boolean bl = false;
                        if (it3 instanceof LeafPsiElement) continue;
                        IElementType iElementType = PsiTreeUtilKt.getElementType((PsiElement)it3);
                        if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)SqlCompositeElementTypes.SQL_DEFAULT_CONSTRAINT_DEFINITION))) {
                            SqlExpression defExpression;
                            SqlConstraintDefinition sqlConstraintDefinition = it3 instanceof SqlConstraintDefinition ? (SqlConstraintDefinition)it3 : null;
                            SqlExpression sqlExpression = defExpression = sqlConstraintDefinition != null ? (SqlExpression)sqlConstraintDefinition.getConstraintParameter(SqlConstraintDefinition.EXPRESSION) : null;
                            defaultExpression = sqlExpression != null ? sqlExpression.getText() : null;
                            continue;
                        }
                        if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)SqlCompositeElementTypes.SQL_COLLATE_CONSTRAINT_DEFINITION))) {
                            SqlExpression collationRef;
                            SqlConstraintDefinition sqlConstraintDefinition = it3 instanceof SqlConstraintDefinition ? (SqlConstraintDefinition)it3 : null;
                            SqlExpression sqlExpression = collationRef = sqlConstraintDefinition != null ? (SqlExpression)sqlConstraintDefinition.getConstraintParameter(SqlConstraintDefinition.EXPRESSION) : null;
                            collationName = sqlExpression != null ? sqlExpression.getText() : null;
                            continue;
                        }
                        if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)SqlCompositeElementTypes.SQL_NULLABLE_CONSTRAINT_DEFINITION))) {
                            conflictResolution = this.getConflictResolution(it3);
                            continue;
                        }
                        if (!Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_COLUMN_GENERATED_CLAUSE)) continue;
                        boolean isStored = SqlImplUtil.getChildOfType(it3, SqliteTypes.SQLITE_STORED) != null;
                        columnKind = isStored ? ColumnKind.GENERATED_STORED : ColumnKind.GENERATED_VIRTUAL;
                        SqlExpression sqlExpression = (SqlExpression)PsiTreeUtil.getChildOfType((PsiElement)it3, SqlExpression.class);
                        defaultExpression = sqlExpression != null ? sqlExpression.getText() : null;
                    }
                    if (StringsKt.equals((String)"binary", collationName, (boolean)true)) {
                        collationName = null;
                    }
                    obj2.setColumnKind(columnKind);
                    obj2.setOnNullConflict(conflictResolution);
                    Object $i$f$forEachChild22 = object2 = obj2;
                    SqliteTableColumn sqliteTableColumn2 = obj2;
                    boolean bl = false;
                    boolean bl2 = it2 instanceof BasicDataObject;
                    sqliteTableColumn = sqliteTableColumn2;
                    object = !bl2 ? object2 : null;
                    if (object == null || (object = (BasicModModel)object.getModel()) == null) break block17;
                    first$iv$iv = object;
                    sqliteTableColumn2 = sqliteTableColumn;
                    boolean bl3 = false;
                    BasicRoot basicRoot = it.getRoot();
                    Intrinsics.checkNotNull((Object)basicRoot, (String)"null cannot be cast to non-null type com.intellij.database.dialects.sqlite.model.SqliteRoot");
                    ModNamingFamily<? extends SqliteCollation> modNamingFamily = ((SqliteRoot)basicRoot).getCollations();
                    Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getCollations(...)");
                    String string = this.fixName(collationName, (Family)modNamingFamily);
                    sqliteTableColumn = sqliteTableColumn2;
                    object = string;
                    if (string != null) break block18;
                }
                object = collationName;
            }
            sqliteTableColumn.setCollationRef(BasicNameReference.create((String)object));
            obj2.setSequenceIdentity(source instanceof SqlColumnDefinition && this.isIdentity((SqlColumnDefinition)source) ? SequenceIdentity.UNKNOWN : null);
        }
        if (!context.isIntrospector() || obj2.getColumnKind() != ColumnKind.NORMAL) {
            obj2.setDefaultExpression(defaultExpression);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isIdentity(SqlColumnDefinition obj2) {
        List refs;
        SqlReferenceList refList;
        PsiElement psiElement;
        block7: {
            void el$iv;
            void this_$iv;
            PsiElement psiElement2;
            PsiElement this_$iv2;
            block6: {
                PsiElement psiElement3 = (PsiElement)obj2;
                SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_COLUMN_GENERATED_AS_IDENTITY_CLAUSE;
                Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType, (String)"SQL_COLUMN_GENERATED_AS_IDENTITY_CLAUSE");
                if (this.findChild(psiElement3, (IElementType)sqlCompositeElementType) != null) {
                    return true;
                }
                SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
                SqlObjectBuilderImpl sqlObjectBuilderImpl2 = this;
                PsiElement el$iv2 = obj2.getParent();
                boolean $i$f$findChild2 = false;
                void var7_8 = this_$iv2;
                PsiElement psiElement4 = el$iv2;
                PsiElement element$iv$iv = psiElement4 != null ? psiElement4.getFirstChild() : null;
                boolean $i$f$findSibling = false;
                for (PsiElement tmp$iv$iv = element$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                    PsiElement it$iv = tmp$iv$iv;
                    boolean bl = false;
                    if (!(it$iv instanceof SqlTableKeyDefinition)) continue;
                    psiElement2 = tmp$iv$iv;
                    break block6;
                }
                psiElement2 = null;
            }
            this_$iv2 = (PsiElement)((SqlTableKeyDefinition)psiElement2);
            boolean $i$f$findChild = false;
            void $i$f$findChild2 = this_$iv;
            void v4 = el$iv;
            PsiElement element$iv$iv = v4 != null ? v4.getFirstChild() : null;
            boolean $i$f$findSibling = false;
            for (PsiElement tmp$iv$iv = element$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement it$iv = tmp$iv$iv;
                boolean bl = false;
                if (!(it$iv instanceof SqlReferenceList)) continue;
                psiElement = tmp$iv$iv;
                break block7;
            }
            psiElement = null;
        }
        SqlReferenceList sqlReferenceList = refList = (SqlReferenceList)psiElement;
        List list = refs = sqlReferenceList != null ? sqlReferenceList.getReferenceList() : null;
        if (refs == null || refs.size() != 1) {
            return false;
        }
        PsiElement psiElement5 = (PsiElement)refs.get(0);
        SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_COLUMN_GENERATED_AS_IDENTITY_CLAUSE;
        Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType, (String)"SQL_COLUMN_GENERATED_AS_IDENTITY_CLAUSE");
        if (this.findSibling(psiElement5, (IElementType)sqlCompositeElementType) == null) {
            return false;
        }
        Object e = refs.get(0);
        Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
        String string = this.extractName((PsiElement)e);
        if (string == null) {
            string = "";
        }
        return StringsKt.equals((String)string, (String)obj2.getName(), (boolean)true);
    }

    /*
     * WARNING - void declaration
     */
    private final void buildVirtualTable(SqliteVirtualTable obj2, DasObject source, SqlObjectBuilder.Context context) {
        SqliteVirtualTable stubbed;
        StubElement stubElement;
        BasicElement basicElement;
        if (!context.isIntrospector()) {
            this.buildNamedElement(obj2, source, context);
        }
        SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
        Object $this$stubbed$iv = source;
        boolean $i$f$stubbed = false;
        Object object = $this$stubbed$iv;
        if (object instanceof SqliteVirtualTable) {
            basicElement = (BasicElement)$this$stubbed$iv;
        } else if (object instanceof SqlStubbedElement) {
            stubElement = ((SqlStubbedElement)((Object)$this$stubbed$iv)).getGreenStub();
            SqlDefinitionStub sqlDefinitionStub = stubElement instanceof SqlDefinitionStub ? (SqlDefinitionStub)stubElement : null;
            BasicElement basicElement2 = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(basicElement2 instanceof SqliteVirtualTable)) {
                basicElement2 = null;
            }
            basicElement = (SqliteVirtualTable)basicElement2;
        } else {
            basicElement = null;
        }
        if ((stubbed = (SqliteVirtualTable)basicElement) != null) {
            obj2.setArguments(stubbed.getArguments());
            obj2.setModuleRef(stubbed.getModuleRef());
        } else {
            List list;
            PsiElement psiElement;
            SqlClause[] this_$iv$iv;
            SqlClause moduleClause;
            block14: {
                PsiElement psiElement2;
                boolean bl;
                PsiElement it$iv;
                PsiElement tmp$iv$iv;
                boolean $i$f$findSibling;
                PsiElement element$iv$iv;
                boolean $i$f$findChild;
                block13: {
                    void this_$iv;
                    $this$stubbed$iv = this;
                    PsiElement el$iv = (PsiElement)(source instanceof SqlCreateStatement ? (SqlCreateStatement)source : null);
                    $i$f$findChild = false;
                    stubElement = this_$iv;
                    PsiElement psiElement3 = el$iv;
                    element$iv$iv = psiElement3 != null ? psiElement3.getFirstChild() : null;
                    $i$f$findSibling = false;
                    for (tmp$iv$iv = element$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                        it$iv = tmp$iv$iv;
                        bl = false;
                        if (!(it$iv instanceof SqlClause)) continue;
                        psiElement2 = tmp$iv$iv;
                        break block13;
                    }
                    psiElement2 = null;
                }
                moduleClause = (SqlClause)psiElement2;
                SqlClause[] this_$iv = (SqlClause[])this;
                $i$f$findChild = false;
                this_$iv$iv = this_$iv;
                PsiElement psiElement4 = (PsiElement)moduleClause;
                element$iv$iv = psiElement4 != null ? psiElement4.getFirstChild() : null;
                $i$f$findSibling = false;
                for (tmp$iv$iv = element$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                    it$iv = tmp$iv$iv;
                    bl = false;
                    if (!(it$iv instanceof SqlReferenceExpression)) continue;
                    psiElement = tmp$iv$iv;
                    break block14;
                }
                psiElement = null;
            }
            SqlReferenceExpression moduleRef = (SqlReferenceExpression)psiElement;
            SqlClause[] moduleArguments = (SqlClause[])PsiTreeUtil.getChildrenOfType((PsiElement)((PsiElement)moduleClause), SqlClause.class);
            SqliteVirtualTable sqliteVirtualTable = obj2;
            if (moduleArguments != null) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                this_$iv$iv = moduleArguments;
                SqliteVirtualTable sqliteVirtualTable2 = sqliteVirtualTable;
                boolean $i$f$map = false;
                void $i$f$findSibling = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
                boolean $i$f$mapTo = false;
                int n = ((void)$this$mapTo$iv$iv).length;
                for (int j = 0; j < n; ++j) {
                    void it;
                    void item$iv$iv;
                    void var17_23 = item$iv$iv = $this$mapTo$iv$iv[j];
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getText());
                }
                list = (List)destination$iv$iv;
                sqliteVirtualTable = sqliteVirtualTable2;
            } else {
                list = CollectionsKt.emptyList();
            }
            sqliteVirtualTable.setArguments(list);
            SqlReferenceExpression sqlReferenceExpression = moduleRef;
            obj2.setModuleRef(BasicNameReference.create(sqlReferenceExpression != null ? sqlReferenceExpression.getName() : null));
        }
    }

    @Override
    protected void buildKey(@NotNull BasicModKey obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(source instanceof SqlTableKeyDefinition) || !(obj2 instanceof SqliteKey)) {
            super.buildKey(obj2, source, context);
            return;
        }
        this.buildKeyFromTableKeyDefinition((SqliteKey)obj2, (SqlTableKeyDefinition)source, context);
    }

    private final void buildKeyFromTableKeyDefinition(SqliteKey obj2, SqlTableKeyDefinition source, SqlObjectBuilder.Context context) {
        SqliteKey stubbed;
        BasicElement basicElement;
        if (!context.isIntrospector()) {
            this.buildBasicElement(obj2, (DasObject)source, context);
        }
        if (!context.isStubBuilder()) {
            obj2.setPrimary(source.isPrimary());
        }
        SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
        DasObject $this$stubbed$iv = (DasObject)source;
        boolean $i$f$stubbed = false;
        DasObject dasObject = $this$stubbed$iv;
        if (dasObject instanceof SqliteKey) {
            basicElement = (BasicElement)$this$stubbed$iv;
        } else if (dasObject instanceof SqlStubbedElement) {
            StubElement stubElement = ((SqlStubbedElement)((Object)$this$stubbed$iv)).getGreenStub();
            SqlDefinitionStub sqlDefinitionStub = stubElement instanceof SqlDefinitionStub ? (SqlDefinitionStub)stubElement : null;
            BasicElement basicElement2 = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(basicElement2 instanceof SqliteKey)) {
                basicElement2 = null;
            }
            basicElement = (SqliteKey)basicElement2;
        } else {
            basicElement = null;
        }
        SqliteKey sqliteKey = stubbed = (SqliteKey)basicElement;
        obj2.setOnConflict(sqliteKey != null ? sqliteKey.getOnConflict() : this.getConflictResolution((PsiElement)source));
    }

    @Override
    protected void buildTrigger(@NotNull BasicModTrigger obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        SqliteTrigger stubbed;
        BasicElement basicElement;
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(obj2 instanceof SqliteTrigger)) {
            super.buildTrigger(obj2, source, context);
            return;
        }
        if (!context.isIntrospector()) {
            this.buildBasicElement(obj2, source, context);
        }
        SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
        DasObject $this$stubbed$iv = source;
        boolean $i$f$stubbed = false;
        DasObject dasObject = $this$stubbed$iv;
        if (dasObject instanceof SqliteTrigger) {
            basicElement = (BasicElement)$this$stubbed$iv;
        } else if (dasObject instanceof SqlStubbedElement) {
            StubElement stubElement = ((SqlStubbedElement)((Object)$this$stubbed$iv)).getGreenStub();
            SqlDefinitionStub sqlDefinitionStub = stubElement instanceof SqlDefinitionStub ? (SqlDefinitionStub)stubElement : null;
            BasicElement basicElement2 = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(basicElement2 instanceof SqliteTrigger)) {
                basicElement2 = null;
            }
            basicElement = (SqliteTrigger)basicElement2;
        } else {
            basicElement = null;
        }
        if ((stubbed = (SqliteTrigger)basicElement) != null) {
            ((SqliteTrigger)obj2).setColNames(stubbed.getColNames());
            ((SqliteTrigger)obj2).setEvents(stubbed.getEvents());
            ((SqliteTrigger)obj2).setTurn(stubbed.getTurn());
            ((SqliteTrigger)obj2).setCondition(stubbed.getCondition());
        } else {
            SqlWhenClause whenClause;
            TrigTurn trigTurn;
            PsiElement element;
            SqlNameElement name2;
            TrigTurn turn = null;
            TrigEvent event = null;
            List<String> cols = null;
            SqlCreateTriggerStatement sqlCreateTriggerStatement = source instanceof SqlCreateTriggerStatement ? (SqlCreateTriggerStatement)source : null;
            SqlNameElement sqlNameElement = name2 = sqlCreateTriggerStatement != null ? sqlCreateTriggerStatement.getNameElement() : null;
            PsiElement afterName = this.skipUnsignificant((PsiElement)(sqlNameElement != null ? sqlNameElement.getNextSibling() : null));
            if (afterName instanceof SqlClause && (element = this.skipUnsignificant(((SqlClause)afterName).getFirstChild())) != null) {
                IElementType iElementType = element.getNode().getElementType();
                Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
                IElementType type = iElementType;
                event = this.getEvent(type);
                if (event == null) {
                    turn = this.getTurn(type);
                    PsiElement nextClause = this.skipUnsignificant(((SqlClause)afterName).getNextSibling());
                    if (nextClause instanceof SqlClause && (element = this.skipUnsignificant(((SqlClause)nextClause).getFirstChild())) != null) {
                        IElementType iElementType2 = element.getNode().getElementType();
                        Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"getElementType(...)");
                        event = this.getEvent(iElementType2);
                        cols = this.getColumns(nextClause);
                    }
                } else {
                    cols = this.getColumns(afterName);
                }
            }
            if ((trigTurn = turn) == null) {
                trigTurn = TrigTurn.BEFORE_ROW;
            }
            turn = trigTurn;
            SqlWhenClause sqlWhenClause = whenClause = (SqlWhenClause)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)(source instanceof SqlCreateTriggerStatement ? (SqlCreateTriggerStatement)source : null)), SqlWhenClause.class);
            SqlExpression whenExpr = sqlWhenClause != null ? sqlWhenClause.getExpression() : null;
            SqlExpression sqlExpression = whenExpr;
            ((SqliteTrigger)obj2).setCondition(sqlExpression != null ? sqlExpression.getText() : null);
            ((SqliteTrigger)obj2).setTurn(turn);
            SqliteTrigger sqliteTrigger = (SqliteTrigger)obj2;
            List<String> list = cols;
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            sqliteTrigger.setColNames(list);
            TrigEvent trigEvent = event;
            ((SqliteTrigger)obj2).setEvents(trigEvent == null ? SetsKt.emptySet() : SetsKt.setOf((Object)((Object)trigEvent)));
        }
        this.assignSources((BasicModSourceAware)((Object)obj2), context, (Function0<? extends CompositeText>)((Function0)() -> SqliteObjectBuilder.buildTrigger$lambda$6(source, this)));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void buildIndex(@NotNull BasicModIndex obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        block14: {
            SqlTableColumnsList columnsList;
            SqlReferenceExpression tableRef;
            SqliteIndex stubbed;
            BasicElement basicElement;
            Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (!(obj2 instanceof SqliteIndex)) {
                super.buildIndex(obj2, source, context);
                return;
            }
            if (!context.isIntrospector()) {
                this.buildNamedElement((BasicModNamedElement)((Object)obj2), source, context);
            }
            SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
            DasObject $this$stubbed$iv = source;
            boolean $i$f$stubbed22 = false;
            DasObject dasObject = $this$stubbed$iv;
            if (dasObject instanceof SqliteIndex) {
                basicElement = (BasicElement)$this$stubbed$iv;
            } else if (dasObject instanceof SqlStubbedElement) {
                StubElement stubElement = ((SqlStubbedElement)((Object)$this$stubbed$iv)).getGreenStub();
                SqlDefinitionStub sqlDefinitionStub = stubElement instanceof SqlDefinitionStub ? (SqlDefinitionStub)stubElement : null;
                BasicElement basicElement2 = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
                if (!(basicElement2 instanceof SqliteIndex)) {
                    basicElement2 = null;
                }
                basicElement = (SqliteIndex)basicElement2;
            } else {
                basicElement = null;
            }
            if ((stubbed = (SqliteIndex)basicElement) != null) {
                ((SqliteIndex)obj2).setCondition(stubbed.getCondition());
            } else {
                SqlWhereClause where = (SqlWhereClause)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)(source instanceof SqlCreateIndexStatement ? (SqlCreateIndexStatement)source : null)), SqlWhereClause.class);
                SqlExpression whereExpr = (SqlExpression)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)where), SqlExpression.class);
                SqlExpression sqlExpression = whereExpr;
                ((SqliteIndex)obj2).setCondition(sqlExpression != null ? sqlExpression.getText() : null);
            }
            ((SqliteIndex)obj2).setUnique(this.buildIndexUnique(source));
            if (context.isStubBuilder()) {
                return;
            }
            SqlCreateIndexStatement sqlCreateIndexStatement = source instanceof SqlCreateIndexStatement ? (SqlCreateIndexStatement)source : null;
            SqlReferenceExpression sqlReferenceExpression = tableRef = sqlCreateIndexStatement != null ? sqlCreateIndexStatement.getTargetReference() : null;
            PsiElement $i$f$stubbed22 = sqlReferenceExpression != null ? sqlReferenceExpression.getParent() : null;
            SqlTableColumnsList sqlTableColumnsList = columnsList = $i$f$stubbed22 instanceof SqlTableColumnsList ? (SqlTableColumnsList)$i$f$stubbed22 : null;
            Object columns = sqlTableColumnsList != null ? sqlTableColumnsList.getColumnsReferenceList() : null;
            Object[] columnExprs = (SqlExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)((PsiElement)columns), SqlExpression.class);
            if (columnExprs == null) break block14;
            ArrayList<Object> newNames = new ArrayList<Object>(columnExprs.length);
            LinkedHashSet newRev = new LinkedHashSet();
            Iterator iterator = ArrayIteratorKt.iterator((Object[])columnExprs);
            while (iterator.hasNext()) {
                boolean curRev;
                block18: {
                    SqlExpression expr;
                    block15: {
                        Object object;
                        ArrayList<Object> arrayList;
                        block17: {
                            block16: {
                                void it;
                                expr = (SqlExpression)iterator.next();
                                curRev = false;
                                if (!(expr instanceof SqlReferenceExpression)) break block15;
                                arrayList = newNames;
                                object = ((SqliteIndex)obj2).getTable();
                                if (object == null || (object = object.getColumns()) == null) break block16;
                                BasicNode basicNode = object;
                                ArrayList<Object> arrayList2 = arrayList;
                                boolean bl = false;
                                String string = this.fixName(((SqlReferenceExpression)expr).getName(), (Family)it);
                                arrayList = arrayList2;
                                object = string;
                                if (string != null) break block17;
                            }
                            String string = ((SqlReferenceExpression)expr).getName();
                            object = string;
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                        }
                        arrayList.add(object);
                        curRev = this.isDesc((SqlReferenceExpression)expr);
                        break block18;
                    }
                    newNames.add(expr.getText());
                }
                if (!curRev) continue;
                newRev.add(newNames.get(newNames.size() - 1));
            }
            ((SqliteIndex)obj2).setColNames((List<String>)newNames);
            ((SqliteIndex)obj2).setReverseColNames(newRev);
        }
    }

    private final boolean isDesc(SqlReferenceExpression expr) {
        for (PsiElement tmp = expr.getNextSibling(); tmp != null && !(tmp instanceof SqlExpression); tmp = tmp.getNextSibling()) {
            IElementType type = PsiTreeUtilKt.getElementType((PsiElement)tmp);
            if (Intrinsics.areEqual((Object)type, (Object)SqliteTypes.SQLITE_ASC)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)type, (Object)SqliteTypes.SQLITE_DESC)) continue;
            return true;
        }
        return false;
    }

    private final String fixName(String name2, Family<?> src) {
        Object object = this.findObject(name2, src);
        if (object == null || (object = ((DasNamed)object).getName()) == null) {
            object = name2;
        }
        return object;
    }

    private final <T extends BasicElement> T findObject(String name2, Family<T> src) {
        Object v0;
        block2: {
            if (name2 == null) {
                return null;
            }
            Iterable $this$firstOrNull$iv = src;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                BasicElement it = (BasicElement)element$iv;
                boolean bl = false;
                if (!StringsKt.equals((String)name2, (String)((DasNamed)it).getName(), (boolean)true)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        return (T)((BasicElement)v0);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getColumns(PsiElement el) {
        List list;
        SqlReferenceExpression[] sqlReferenceExpressionArray = (SqlReferenceExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)el, SqlReferenceExpression.class);
        if (sqlReferenceExpressionArray != null) {
            void $this$mapTo$iv$iv;
            SqlReferenceExpression[] $this$map$iv = sqlReferenceExpressionArray;
            boolean $i$f$map = false;
            SqlReferenceExpression[] sqlReferenceExpressionArray2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int j = 0; j < n; ++j) {
                void it;
                void item$iv$iv;
                void var10_10 = item$iv$iv = $this$mapTo$iv$iv[j];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getName());
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        return list;
    }

    private final TrigEvent getEvent(IElementType type) {
        if (Intrinsics.areEqual((Object)type, (Object)SqliteTypes.SQLITE_INSERT)) {
            return TrigEvent.INSERT;
        }
        if (Intrinsics.areEqual((Object)type, (Object)SqliteTypes.SQLITE_DELETE)) {
            return TrigEvent.DELETE;
        }
        return Intrinsics.areEqual((Object)type, (Object)SqliteTypes.SQLITE_UPDATE) ? TrigEvent.UPDATE : null;
    }

    private final TrigTurn getTurn(IElementType type) {
        if (Intrinsics.areEqual((Object)type, (Object)SqliteTypes.SQLITE_BEFORE)) {
            return TrigTurn.BEFORE_ROW;
        }
        if (Intrinsics.areEqual((Object)type, (Object)SqliteTypes.SQLITE_AFTER)) {
            return TrigTurn.AFTER_ROW;
        }
        return Intrinsics.areEqual((Object)type, (Object)SqliteTypes.SQLITE_INSTEAD) ? TrigTurn.INSTEAD_OF : null;
    }

    private final PsiElement skipUnsignificant(PsiElement el) {
        PsiElement tmp = el;
        while (tmp instanceof PsiWhiteSpace || tmp instanceof PsiComment) {
            tmp = tmp.getNextSibling();
        }
        return tmp;
    }

    private final SqliteOnConflictAlgorithm getConflictResolution(PsiElement def) {
        SqliteOnConflictAlgorithm algo;
        block3: {
            SqliteOnConflictAlgorithm sqliteOnConflictAlgorithm;
            IElementType iElementType = SqliteTypes.SQLITE_CONFLICT_CLAUSE;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"SQLITE_CONFLICT_CLAUSE");
            PsiElement psiElement = this.findChild(def, iElementType);
            if (psiElement == null) {
                return null;
            }
            PsiElement onConflict = psiElement;
            PsiElement psiElement2 = PsiTreeUtil.getDeepestLast((PsiElement)onConflict);
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getDeepestLast(...)");
            PsiElement how = psiElement2;
            String text2 = how.getText();
            SqliteOnConflictAlgorithm[] $this$firstOrNull$iv = SqliteOnConflictAlgorithm.values();
            boolean $i$f$firstOrNull = false;
            int n = $this$firstOrNull$iv.length;
            for (int j = 0; j < n; ++j) {
                SqliteOnConflictAlgorithm element$iv;
                SqliteOnConflictAlgorithm it = element$iv = $this$firstOrNull$iv[j];
                boolean bl = false;
                if (!StringsKt.equals((String)it.toString(), (String)text2, (boolean)true)) continue;
                sqliteOnConflictAlgorithm = element$iv;
                break block3;
            }
            sqliteOnConflictAlgorithm = algo = null;
        }
        if (algo == SqliteOnConflictAlgorithm.ABORT) {
            return null;
        }
        return algo;
    }

    private static final CompositeText buildViewSource$lambda$1(DasObject $source, SqliteObjectBuilder this$0) {
        String string;
        SqlCreateViewStatement sqlCreateViewStatement = $source instanceof SqlCreateViewStatement ? (SqlCreateViewStatement)$source : null;
        return sqlCreateViewStatement != null && (string = this$0.wholeStatement((SqlTableDefinition)sqlCreateViewStatement)) != null ? SqlObjectBuilderImpl.asComposite$default(this$0, string, null, 1, null) : null;
    }

    private static final CompositeText buildTrigger$lambda$6(DasObject $source, SqliteObjectBuilder this$0) {
        String string;
        SqlCreateTriggerStatement sqlCreateTriggerStatement = $source instanceof SqlCreateTriggerStatement ? (SqlCreateTriggerStatement)$source : null;
        return sqlCreateTriggerStatement != null && (string = sqlCreateTriggerStatement.getText()) != null ? SqlObjectBuilderImpl.asComposite$default(this$0, string, null, 1, null) : null;
    }
}

